/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.intercom.api.Author;
import io.intercom.api.AuthorizationException;
import io.intercom.api.DataResource;
import io.intercom.api.InvalidException;
import io.intercom.api.NoteCollection;
import io.intercom.api.TypedData;
import io.intercom.api.User;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Note
extends TypedData {
    private static final HashMap<String, String> SENTINEL = Maps.newHashMap();
    @JsonProperty(value="type")
    private final String type = "note";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="body")
    private String body;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="user")
    private User user;
    @JsonProperty(value="author")
    private Author author;

    public static Note find(String id) throws InvalidException, AuthorizationException {
        return DataResource.find(id, "notes", Note.class);
    }

    public static Note create(Note note) throws InvalidException, AuthorizationException {
        return DataResource.create(note, "notes", Note.class);
    }

    public static NoteCollection list(Map<String, String> params) throws InvalidException, AuthorizationException {
        if (!(params.containsKey("email") || params.containsKey("id") || params.containsKey("user_id") || params.containsKey("intercom_user_id"))) {
            throw new InvalidException("a notes query must include an email, user_id or intercom_user_id parameter");
        }
        return DataResource.list(params, "notes", NoteCollection.class);
    }

    @Override
    public String getType() {
        return "note";
    }

    public String getId() {
        return this.id;
    }

    public String getBody() {
        return this.body;
    }

    public Note setBody(String body) {
        this.body = body;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public User getUser() {
        return this.user;
    }

    public Note setUser(User user) {
        this.user = user;
        return this;
    }

    public Author getAuthor() {
        return this.author;
    }

    public Note setAuthor(Author author) {
        this.author = author;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        if (this.createdAt != note.createdAt) {
            return false;
        }
        if (this.author != null ? !this.author.equals(note.author) : note.author != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(note.body) : note.body != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(note.id) : note.id != null) {
            return false;
        }
        if (!"note".equals(note.type)) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(note.user) : note.user != null);
    }

    public int hashCode() {
        int result = "note".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Note{id='" + this.id + '\'' + ", body='" + this.body + '\'' + ", createdAt=" + this.createdAt + ", user=" + this.user + ", author=" + this.author + "} " + super.toString();
    }
}

