/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.intercom.api.Company;
import io.intercom.api.TypedDataCollection;
import io.intercom.api.TypedDataCollectionIterator;
import java.util.Iterator;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CompanyCollection
extends TypedDataCollection<Company>
implements Iterator<Company> {
    protected TypedDataCollectionIterator<Company> iterator;
    @JsonProperty(value="total_count")
    private long totalCount;

    public CompanyCollection() {
        this.type = "company.list";
        this.iterator = new TypedDataCollectionIterator<Company>(this);
    }

    public CompanyCollection(List<Company> companies) {
        this();
        this.page = companies;
    }

    @Override
    @JsonProperty(value="companies")
    public List<Company> getPage() {
        return super.getPage();
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public CompanyCollection nextPage() {
        return this.fetchNextPage(CompanyCollection.class);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Company next() {
        return (Company)this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public String toString() {
        return "CompanyCollection{, totalCount=" + this.totalCount + "} " + super.toString();
    }

    void addCompany(Company company) {
        this.page.add(company);
    }
}

