/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.media.SoundPool;
import android.os.IBinder;
import android.os.Parcelable;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.squareup.otto.Subscribe;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Lifecycles;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.MainActivity;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.Events.ReadEvent;
import io.intercom.android.sdk.models.Events.UnreadConversationsEvent;
import io.intercom.android.sdk.models.Events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.Events.realtime.NewCommentEvent;
import io.intercom.android.sdk.models.api.response.Conversation;
import io.intercom.android.sdk.preview.IntercomPreviewPosition;
import io.intercom.android.sdk.preview.PreviewStateHolder;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.Prefs;
import io.intercom.android.sdk.utilities.ScreenUtils;
import java.util.List;

@TargetApi(value=15)
public class PreviewService
extends Service
implements View.OnTouchListener,
Animation.AnimationListener {
    public static final String ORIENTATION_CHANGE = "android.intent.action.CONFIGURATION_CHANGED";
    public static final String PREVIEW_VISIBILITY = "previewVisibility";
    public static final String RESET = "";
    private static final int TOP_BORDER_DP = 140;
    private static final int BOTTOM_BORDER_DP = 40;
    private static final int X_BORDER_DP = 10;
    private int TOP_BORDER_PX;
    private int BOTTOM_BORDER_PX;
    private WindowManager windowManager;
    private RelativeLayout rootView;
    private FrameLayout indicatorLayout;
    private FrameLayout notificationContainer;
    private ImageView notificationAvatar;
    private View shadow;
    private TextView notificationText;
    private TextView indicatorText;
    private boolean mBound;
    private WindowManager.LayoutParams params;
    private int initialY;
    private float initialTouchY;
    private double aspectRatio;
    private int unreadCount;
    private List<Conversation> conversations;
    private Conversation currentlyDisplayedConversation;
    private Point windowSize = new Point();
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(PreviewService.ORIENTATION_CHANGE)) {
                ((PreviewService)PreviewService.this).params.y = context.getResources().getConfiguration().orientation == 1 ? (int)((double)((PreviewService)PreviewService.this).params.y * PreviewService.this.aspectRatio) : (int)((double)((PreviewService)PreviewService.this).params.y / PreviewService.this.aspectRatio);
                PreviewService.this.setUpBoundaries();
                PreviewService.this.checkBoundaries(PreviewService.this.params);
            }
        }
    };

    @SuppressLint(value={"InflateParams"})
    public void onCreate() {
        super.onCreate();
        Bridge.init(this.getApplicationContext());
        Logger.INTERNAL("notificationAvatar", "on create");
        if (Lifecycles.isAppBackgrounded()) {
            Logger.INTERNAL("notificationAvatar", "stopping self because we're backgrounded");
            this.stopSelf();
        } else {
            this.rootView = Prefs.isLeftAligned(this.getApplicationContext()) ? (RelativeLayout)LayoutInflater.from((Context)this).inflate(R.layout.intercomsdk_chathead_layout_left_aligned, null) : (RelativeLayout)LayoutInflater.from((Context)this).inflate(R.layout.intercomsdk_chathead_layout_right_aligned, null);
            this.conversations = PreviewStateHolder.getInstance().getUnreadConversations();
            this.unreadCount = this.conversations.size();
            this.currentlyDisplayedConversation = new Conversation();
            this.mBound = false;
            this.windowManager = (WindowManager)this.getSystemService("window");
            this.params = new WindowManager.LayoutParams(-2, -2, 2002, 520, -3);
            this.setUpBoundaries();
            this.windowManager.addView((View)this.rootView, (ViewGroup.LayoutParams)this.params);
            this.initializeChathead();
            Bridge.getPoller().startPreviewPolling();
        }
        Bridge.getBus().register((Object)this);
        Bridge.getBus().register((Object)PreviewStateHolder.getInstance());
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Logger.INTERNAL("notificationAvatar", "on start command");
        if (intent != null) {
            PreviewStateHolder stateHolder = PreviewStateHolder.getInstance();
            stateHolder.setPreviewVisiblity(intent.getIntExtra(PREVIEW_VISIBILITY, stateHolder.getPreviewVisibility()));
        }
        this.checkConversations();
        return 2;
    }

    public IBinder onBind(Intent intent) {
        Logger.INTERNAL("notificationAvatar", "on bind");
        this.mBound = true;
        this.hideChathead();
        Bridge.getPoller().startInboxPolling();
        return null;
    }

    public boolean onUnbind(Intent intent) {
        Logger.INTERNAL("notificationAvatar", "on unbind");
        this.mBound = false;
        this.getUnreadConversations();
        Bridge.getPoller().startPreviewPolling();
        return true;
    }

    public void onRebind(Intent intent) {
        Logger.INTERNAL("notificationAvatar", "on rebind");
        this.mBound = true;
        this.hideChathead();
        Bridge.getPoller().startInboxPolling();
        super.onRebind(intent);
    }

    public void onDestroy() {
        Logger.INTERNAL("notificationAvatar", "on destroy");
        if (this.rootView != null) {
            this.windowManager.removeView((View)this.rootView);
        }
        Bridge.getBus().unregister((Object)this);
        Bridge.getBus().unregister((Object)PreviewStateHolder.getInstance());
        Bridge.getPoller().endPolling();
        this.unregisterReceiver(this.mBroadcastReceiver);
        super.onDestroy();
    }

    private void initializeChathead() {
        Display display = this.windowManager.getDefaultDisplay();
        Point windowSize = new Point();
        display.getSize(windowSize);
        this.aspectRatio = windowSize.x >= windowSize.y ? (double)windowSize.x / (double)windowSize.y : (double)windowSize.y / (double)windowSize.x;
        IntentFilter filter = new IntentFilter();
        filter.addAction(ORIENTATION_CHANGE);
        this.registerReceiver(this.mBroadcastReceiver, filter);
        this.notificationAvatar = (ImageView)this.rootView.findViewById(R.id.avatar);
        this.shadow = this.rootView.findViewById(R.id.avatar_shadow);
        this.notificationContainer = (FrameLayout)this.rootView.findViewById(R.id.notification_container);
        this.notificationText = (TextView)this.rootView.findViewById(R.id.notification_text);
        this.indicatorText = (TextView)this.rootView.findViewById(R.id.indicator_text);
        this.indicatorLayout = (FrameLayout)this.rootView.findViewById(R.id.indicator_container);
        ImageView unreadIndicator = (ImageView)this.rootView.findViewById(R.id.unreadImageView);
        unreadIndicator.setColorFilter(this.getResources().getColor(R.color.intercomsdk_red));
        this.notificationText.setTypeface(FontUtils.getTypeface("Roboto-Medium.ttf", (Context)this));
        this.indicatorText.setTypeface(FontUtils.getTypeface("Roboto-Medium.ttf", (Context)this));
        this.notificationAvatar.setOnTouchListener((View.OnTouchListener)this);
        this.notificationContainer.setOnTouchListener((View.OnTouchListener)this);
    }

    private void getUnreadConversations() {
        if (!this.mBound) {
            Bridge.getApi().getUnreadConversations();
            Bridge.getPoller().resetPreviewPoll();
        }
    }

    @Subscribe
    public void unreadCountUpdated(UnreadConversationsEvent event) {
        this.conversations.clear();
        this.conversations.addAll(event.getResponse().getConversations());
        this.unreadCount = event.getResponse().getTotalUnreadCount();
        this.checkConversations();
    }

    @Subscribe
    public void conversationMarkedAsRead(ReadEvent event) {
        for (Conversation conversation : this.conversations) {
            if (!conversation.getId().equals(event.getConversationId())) continue;
            this.conversations.remove(conversation);
            --this.unreadCount;
            break;
        }
        if (this.conversations.size() == 1 && this.unreadCount > this.conversations.size()) {
            this.getUnreadConversations();
        }
    }

    private void checkConversations() {
        if (PreviewStateHolder.getInstance().getPreviewVisibility() == 0) {
            if (this.conversations.isEmpty()) {
                this.hideChathead();
            } else {
                Conversation conversation = this.conversations.get(0);
                String messageStyle = conversation.getLastPart().getMessageStyle();
                if ("announcement".equals(messageStyle) || "small-announcement".equals(messageStyle)) {
                    Intent intent = new Intent((Context)this, MainActivity.class);
                    intent.putExtra("OpenConversation", (Parcelable)conversation);
                    intent.addFlags(0x10000000);
                    this.startActivity(intent);
                } else if ("chat".equals(messageStyle)) {
                    this.updateChatHeadUI(conversation);
                }
            }
        } else {
            this.hideChathead();
        }
    }

    private void updateChatHeadUI(Conversation conversation) {
        boolean shouldFadeIn = this.rootView.getVisibility() != 0;
        AvatarUtils.createAvatar(conversation.getLastAdmin().isAdmin(), conversation.getLastAdmin().getAvatar(), this.notificationAvatar, (Context)this);
        String lastAdminText = conversation.getLastAdminPart().getSummary();
        if (!lastAdminText.isEmpty()) {
            this.notificationText.setText((CharSequence)lastAdminText);
        } else {
            this.notificationText.setText(R.string.intercomsdk_image_attached);
        }
        this.indicatorText.setText((CharSequence)String.valueOf(this.unreadCount));
        this.showChathead();
        if (shouldFadeIn) {
            this.fadeInChatHead();
        }
        if (!this.currentlyDisplayedConversation.equals(conversation)) {
            this.animateTextBubble();
            this.playSound();
        }
        this.currentlyDisplayedConversation = conversation;
    }

    private void showChathead() {
        if (!this.mBound) {
            Logger.INTERNAL("notificationAvatar", "showing notificationAvatar");
            this.rootView.setVisibility(0);
            this.notificationAvatar.setVisibility(0);
            this.shadow.setVisibility(0);
            this.indicatorLayout.setVisibility(0);
        }
    }

    private void hideChathead() {
        Logger.INTERNAL("notificationAvatar", "hiding notificationAvatar");
        this.rootView.setVisibility(8);
        this.notificationAvatar.setVisibility(8);
        this.shadow.setVisibility(8);
        this.indicatorLayout.setVisibility(8);
    }

    private void fadeInChatHead() {
        Animation chatheadFadeIn = AnimationUtils.loadAnimation((Context)this, (int)R.anim.intercomsdk_chathead_fade_in_anim);
        this.notificationAvatar.startAnimation(chatheadFadeIn);
        Animation badgeFadeIn = AnimationUtils.loadAnimation((Context)this, (int)R.anim.intercomsdk_unread_badge_fade_in_anim);
        this.indicatorLayout.startAnimation(badgeFadeIn);
        Animation shadowFadeIn = AnimationUtils.loadAnimation((Context)this, (int)R.anim.intercomsdk_chathead_fade_in_anim);
        this.shadow.startAnimation(shadowFadeIn);
    }

    private void animateTextBubble() {
        if (!Prefs.isLeftAligned(this.getApplicationContext())) {
            return;
        }
        Animation textAnim = AnimationUtils.loadAnimation((Context)this, (int)R.anim.intercomsdk_chathead_text_notification_left_aligned_anim);
        this.notificationContainer.getBackground().setColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()), PorterDuff.Mode.MULTIPLY);
        this.notificationContainer.setVisibility(0);
        this.notificationContainer.startAnimation(textAnim);
        textAnim.setAnimationListener((Animation.AnimationListener)this);
    }

    private void playSound() {
        if (Bridge.getIdentityStore().getAppConfig().isAudioEnabled()) {
            final SoundPool spool = new SoundPool(1, 5, 0);
            spool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

                public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                    spool.play(sampleId, 1.0f, 1.0f, 1, 0, 1.0f);
                }
            });
            spool.load((Context)this, R.raw.birdy_done_1, 1);
        }
    }

    private void setUpBoundaries() {
        Display display = this.windowManager.getDefaultDisplay();
        display.getSize(this.windowSize);
        IntercomPreviewPosition previewPosition = Prefs.getPresentationMode(this.getApplicationContext());
        boolean topAligned = previewPosition == IntercomPreviewPosition.TOP_LEFT || previewPosition == IntercomPreviewPosition.TOP_RIGHT;
        this.TOP_BORDER_PX = ScreenUtils.convertDpToPixel(140.0f, (Context)this);
        this.BOTTOM_BORDER_PX = ScreenUtils.convertDpToPixel(40.0f, (Context)this);
        this.params.gravity = previewPosition.getGravity();
        this.params.x = ScreenUtils.convertDpToPixel(10.0f, (Context)this);
        this.params.y = topAligned ? this.windowSize.y - this.TOP_BORDER_PX : this.BOTTOM_BORDER_PX;
    }

    private void checkBoundaries(WindowManager.LayoutParams params) {
        if (params.y < this.BOTTOM_BORDER_PX) {
            params.y = this.BOTTOM_BORDER_PX;
        }
        if (params.y > this.windowSize.y - this.TOP_BORDER_PX) {
            params.y = this.windowSize.y - this.TOP_BORDER_PX;
        }
        this.windowManager.updateViewLayout((View)this.rootView, (ViewGroup.LayoutParams)params);
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        this.getUnreadConversations();
    }

    @Subscribe
    public void newConversation(CreateConversationEvent event) {
        this.getUnreadConversations();
    }

    public void onAnimationStart(Animation animation) {
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
        this.notificationContainer.setVisibility(8);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.initialY = this.params.y;
                this.initialTouchY = event.getRawY();
                return true;
            }
            case 1: {
                if (this.initialY == this.params.y) {
                    this.rootView.setVisibility(8);
                    Intent intent = new Intent((Context)this, MainActivity.class);
                    intent.putExtra("OpenConversation", (Parcelable)this.conversations.get(0));
                    intent.putExtra("intercomsdk-unreadCount", this.unreadCount);
                    intent.putExtra("intercomsdk-isRead", false);
                    intent.addFlags(0x10000000);
                    this.startActivity(intent);
                }
                return true;
            }
            case 2: {
                this.params.y = this.initialY - (int)(event.getRawY() - this.initialTouchY);
                this.checkBoundaries(this.params);
                return true;
            }
        }
        return false;
    }
}

