/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.Lifecycles;
import io.intercom.android.sdk.activities.MainActivity;
import io.intercom.android.sdk.gcm.GcmIntentService;
import io.intercom.android.sdk.identity.Migrations;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.Events.CloseIAMEvent;
import io.intercom.android.sdk.models.Events.ResetPreviewServiceEvent;
import io.intercom.android.sdk.models.api.response.Conversation;
import io.intercom.android.sdk.preview.IntercomPreviewPosition;
import io.intercom.android.sdk.preview.PreviewService;
import io.intercom.android.sdk.utilities.AttributeSanitiser;
import io.intercom.android.sdk.utilities.Prefs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TargetApi(value=14)
public class RealIntercom
extends Intercom {
    private boolean applicationSetup = false;

    protected RealIntercom(Application application, String apiKey, String appId) {
        if (application != null) {
            if (TextUtils.isEmpty((CharSequence)apiKey)) {
                Logger.ERROR("The apiKey you provided is either null or empty. We require a correct apiKey to enable the Intercom SDK");
                apiKey = "";
            }
            if (TextUtils.isEmpty((CharSequence)appId)) {
                Logger.ERROR("The appId you provided is either null or empty. We require a correct appId to enable the Intercom SDK");
                appId = "";
            }
            Bridge.init((Context)application);
            Migrations.runAll((Context)application);
            Bridge.getIdentityStore().setAppIdentity(apiKey, appId);
            Logger.INTERNAL("sdk ping", "startup ping");
            Bridge.getApi().ping();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new Lifecycles());
            this.applicationSetup = true;
        } else {
            Logger.ERROR("Intercom setup requires an Application, it appears the Application we received was null");
        }
    }

    @Override
    public void registerUnidentifiedUser() {
        if (this.applicationSetup) {
            if (Bridge.getIdentityStore().registerUnidentifiedUser()) {
                Bridge.getApi().registerUnidentifiedUser();
                this.updateNotificationsService();
            } else {
                Logger.INFO("Failed to register user. We already have a registered user. If you are attempting to register a new user, call reset before this. If you are attempting to register an identified user call: registerIdentifiedUser(Registration)");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    @Override
    public void registerIdentifiedUser(Registration userRegistration) {
        if (this.applicationSetup) {
            if (userRegistration != null) {
                if (Bridge.getIdentityStore().registerIdentifiedUser(userRegistration)) {
                    Bridge.getApi().registerIdentifiedUser(userRegistration);
                    this.updateNotificationsService();
                } else {
                    Logger.INFO("Failed to register user. We already have a registered user. If you are attempting to register a new user, call reset before this. If you are attempting to change the user call update instead.");
                }
            } else {
                Logger.ERROR("The registration object you passed to is null. An example successful call is registerIdentifiedUser(new Registration().withEmail(email));");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    @Override
    public void setSecureMode(String secureHash, String secureData) {
        if (this.applicationSetup) {
            if (TextUtils.isEmpty((CharSequence)secureHash)) {
                Logger.WARNING("The hmac you sent us for secure mode was either null or empty, we will not be able to authenticate your requests without a valid hmac.");
            } else if (TextUtils.isEmpty((CharSequence)secureData)) {
                Logger.WARNING("The data you sent us for secure mode was either null or empty, we will not be able to authenticate your requests without valid data.");
            } else {
                Bridge.getIdentityStore().setSecureMode(secureHash, secureData);
            }
        }
    }

    @Override
    public void updateUser(Map<String, Object> attributes) {
        if (this.applicationSetup) {
            if (attributes == null) {
                Logger.ERROR("updateUser method failed: the attributes Map provided is null");
            } else if (attributes.isEmpty()) {
                Logger.ERROR("updateUser method failed: the attributes Map provided is empty");
            } else {
                if (Bridge.getIdentityStore().isAnonymousUser()) {
                    AttributeSanitiser.anonymousSanitisation(attributes);
                }
                Bridge.getApi().updateUser(attributes);
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    @Override
    public void logEvent(String name) {
        if (this.applicationSetup) {
            if (!TextUtils.isEmpty((CharSequence)name)) {
                Bridge.getApi().logEvent(name, new HashMap<String, Object>());
            } else {
                Logger.ERROR("The event name is null or empty. We can't log an event with this string.");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    @Override
    public void logEvent(String name, Map<String, Object> metaData) {
        if (this.applicationSetup) {
            if (TextUtils.isEmpty((CharSequence)name)) {
                Logger.ERROR("The event name is null or empty. We can't log an event with this string.");
            } else if (metaData == null || metaData.isEmpty()) {
                Logger.ERROR("The metaData Map is null or empty. We can't log an event with this Map.");
            } else {
                Bridge.getApi().logEvent(name, metaData);
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    @Override
    public void displayMessageComposer() {
        if (this.applicationSetup) {
            if (Bridge.getIdentityStore().getAppConfig().isInboundMessages()) {
                this.openIAM(false, "");
            } else {
                Logger.ERROR("It appears your app is not on a plan that allows message composing As a fallback we are calling displayConversationsList()");
                this.displayConversationsList();
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    @Override
    public void displayConversationsList() {
        if (this.applicationSetup) {
            this.openIAM(true, "");
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    private void openIAM(boolean asConversationsList, String conversationId) {
        if (this.applicationSetup) {
            Context context = Bridge.getContext();
            Intent intent = new Intent(context, MainActivity.class);
            if (asConversationsList) {
                intent.putExtra("showInbox", true);
            } else {
                Conversation conversation = new Conversation.Builder().withId(conversationId).build();
                intent.putExtra("OpenConversation", (Parcelable)conversation);
            }
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    private void updateNotificationsService() {
        Context context = Bridge.getContext();
        Intent intent = new Intent(context, PreviewService.class);
        context.startService(intent);
    }

    @Override
    public void setPreviewPosition(IntercomPreviewPosition previewPosition) {
        if (this.applicationSetup) {
            if (previewPosition == null) {
                Logger.WARNING("The previewPosition provided is null. An example successful call is: setPreviewPosition(IntercomPreviewPosition.BOTTOM_LEFT);");
                previewPosition = IntercomPreviewPosition.BOTTOM_LEFT;
            }
            Prefs.setPresentationMode(previewPosition, Bridge.getContext());
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    @Override
    public void setVisibility(int visibility) {
        if (this.applicationSetup) {
            Context context = Bridge.getContext();
            Intent intent = new Intent(context, PreviewService.class);
            intent.putExtra("previewVisibility", visibility);
            context.startService(intent);
            if (visibility == 1) {
                Bridge.getBus().post((Object)new CloseIAMEvent());
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    @Override
    @Deprecated
    public void setMessagesHidden(boolean visibility) {
        this.setVisibility(visibility ? 0 : 1);
    }

    @Override
    public void setupGCM(String regId, int appLogo) {
        if (this.applicationSetup) {
            Context context = Bridge.getContext();
            PackageManager packageManager = context.getPackageManager();
            if (packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", context.getPackageName()) == 0 && packageManager.checkPermission("android.permission.WAKE_LOCK", context.getPackageName()) == 0 && packageManager.checkPermission("android.permission.VIBRATE", context.getPackageName()) == 0) {
                if (TextUtils.isEmpty((CharSequence)regId)) {
                    Logger.ERROR("It looks like the GCM registrationId you passed in is null or empty, we require a valid GCM registrationId to enable push");
                } else {
                    Bridge.getApi().setGCMPushKey(regId);
                    SharedPreferences settings = Bridge.getContext().getSharedPreferences("INTERCOM_SDK_PREFS", 0);
                    SharedPreferences.Editor editor = settings.edit();
                    editor.putInt("INTERCOM_SDK_PUSH_LOGO", appLogo);
                    editor.apply();
                }
            } else {
                Logger.ERROR("To enable GCM notifications the following permissions are required. <uses-permission android:name=\"android.permission.WAKE_LOCK\" />\n<uses-permission android:name=\"com.google.android.c2dm.permission.RECEIVE\" />\n<uses-permission android:name=\"android.permission.VIBRATE\"/>\nIn addition to the required permissions the following optional permissions improve push reliability<uses-permission android:name=\"android.permission.READ_PHONE_STATE\"/>\n<uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    @Override
    public boolean openGCMMessage(Uri data) {
        boolean wasSdkPush = false;
        if (this.applicationSetup) {
            if (data != null) {
                List pathParts = data.getPathSegments();
                if (pathParts.size() > 1 && ((String)pathParts.get(0)).equals("intercom_sdk")) {
                    wasSdkPush = true;
                    if (((String)pathParts.get(1)).equals("multiple_notifications")) {
                        this.openIAM(true, "");
                    } else {
                        this.openIAM(false, ((String)pathParts.get(1)).substring(((String)pathParts.get(1)).lastIndexOf(61) + 1));
                    }
                    Context context = Bridge.getContext();
                    Intent intent = new Intent(context, GcmIntentService.class);
                    intent.setAction("intercom_sdk_remove_notification");
                    context.startService(intent);
                } else {
                    Logger.INFO("The Uri passed into the method openGCMMessage was not an Intercom GCM message");
                }
            } else {
                Logger.INFO("The Uri passed into the method openGCMMessage was null.");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
        return wasSdkPush;
    }

    @Override
    public void reset() {
        if (this.applicationSetup) {
            Bridge.getIdentityStore().getAppConfig().resetRealTimeConfig();
            Bridge.getNexusClient().disconnect();
            Bridge.getIdentityStore().resetUserIdentity();
            Bridge.getBus().post((Object)new CloseIAMEvent());
            Bridge.getBus().post((Object)new ResetPreviewServiceEvent());
            Context context = Bridge.getContext();
            Intent intent = new Intent(context, PreviewService.class);
            intent.putExtra("", true);
            context.stopService(intent);
            Logger.INFO("Successfully reset user. To resume communicating with Intercom, you can register a user");
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }
}

