/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.squareup.otto.Subscribe;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.conversation.events.AdminTypingEndedEvent;
import io.intercom.android.sdk.conversation.events.CancelAdminTypingEvent;
import io.intercom.android.sdk.logger.Logger;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@TargetApi(value=14)
public class AdminIsTypingView
extends LinearLayout {
    private static final int ANIMATION_DELAY = 100;
    private static final int IS_TYPING_DURATION = 10;
    private final ImageView[] dots = new ImageView[3];
    private final AnimatorSet[] dotsAnimations = new AnimatorSet[3];
    private final String partId;
    private final String adminId;
    private final String conversationId;
    private boolean animating = false;
    private ScheduledFuture future;
    private int iterationCount = 0;

    public AdminIsTypingView(Context context) {
        this(context, "", "", "");
    }

    public AdminIsTypingView(Context context, AttributeSet attrs) {
        this(context, "", "", "");
    }

    public AdminIsTypingView(Context context, String adminId, String conversationId, String partId) {
        super(context);
        AdminIsTypingView.inflate((Context)this.getContext(), (int)R.layout.intercomsdk_admin_is_typing, (ViewGroup)this);
        this.adminId = adminId;
        this.conversationId = conversationId;
        this.partId = partId;
        this.dots[0] = (ImageView)this.findViewById(R.id.dot1);
        this.dots[1] = (ImageView)this.findViewById(R.id.dot2);
        this.dots[2] = (ImageView)this.findViewById(R.id.dot3);
        for (int i = 0; i < this.dotsAnimations.length; ++i) {
            this.dotsAnimations[i] = (AnimatorSet)AnimatorInflater.loadAnimator((Context)this.getContext(), (int)R.animator.intercomsdk_admin_is_typing);
            this.dotsAnimations[i].setStartDelay((long)(i * 100));
        }
        Bridge.getBus().register((Object)this);
    }

    public void beginAnimation() {
        if (!this.animating) {
            this.animating = true;
            this.future = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (AdminIsTypingView.this.iterationCount < 10) {
                        AdminIsTypingView.this.iterationCount++;
                        for (int i = 0; i < AdminIsTypingView.this.dots.length; ++i) {
                            final int j = i;
                            AdminIsTypingView.this.dots[i].post(new Runnable(){

                                @Override
                                public void run() {
                                    AdminIsTypingView.this.dotsAnimations[j].setTarget((Object)AdminIsTypingView.this.dots[j]);
                                    AdminIsTypingView.this.dotsAnimations[j].start();
                                }
                            });
                        }
                    } else {
                        AdminIsTypingView.this.endAnimation();
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    private void endAnimation() {
        if (this.animating) {
            this.animating = false;
            Bridge.getBus().unregister((Object)this);
            Bridge.getBus().post((Object)new AdminTypingEndedEvent(this.adminId, this.conversationId, this.partId));
            Logger.INTERNAL("isTyping", "ending animation");
            if (!this.future.isCancelled()) {
                this.future.cancel(true);
            }
            for (AnimatorSet set : this.dotsAnimations) {
                set.cancel();
            }
        }
    }

    @Subscribe
    public void renewTypingAnimation(AdminIsTypingEvent event) {
        if (event.getAdminId().equals(this.adminId) && event.getConversationId().equals(this.conversationId)) {
            this.iterationCount = 0;
        }
    }

    @Subscribe
    public void cancelTypingAnimation(CancelAdminTypingEvent ignored) {
        this.endAnimation();
    }
}

