/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.blocks.blockInterfaces.AttachmentListBlock;
import io.intercom.android.blocks.models.BlockAttachment;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ScreenUtils;
import java.util.List;

@TargetApi(value=11)
public class Attachment
implements AttachmentListBlock {
    private static final int PADDING_IN_DP = 6;
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Context context;

    public Attachment(Context context, StyleType style) {
        this.style = style;
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addAttachmentList(List<BlockAttachment> attachments, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        LinearLayout layout2 = (LinearLayout)this.inflater.inflate(R.layout.intercomsdk_blocks_attachment_list, parent, false);
        for (final BlockAttachment attachment : attachments) {
            Drawable attachmentDrawable = this.context.getResources().getDrawable(R.drawable.intercomsdk_attachment);
            TextView textView = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_attachment, (ViewGroup)layout2, false);
            textView.setText((CharSequence)attachment.getName());
            textView.setCompoundDrawablesWithIntrinsicBounds(attachmentDrawable, null, null, null);
            textView.setCompoundDrawablePadding(ScreenUtils.convertDpToPixel(6.0f, this.context));
            textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Uri uri = Uri.parse((String)attachment.getUrl());
                    Intent intent = new Intent("android.intent.action.VIEW", uri);
                    intent.setFlags(0x10000000);
                    Attachment.this.context.startActivity(intent);
                }
            });
            if (this.style != StyleType.USER) {
                if (this.style == StyleType.WELCOME) {
                    textView.setTextColor(this.context.getResources().getColor(R.color.intercomsdk_poweredby_color));
                } else {
                    if (attachmentDrawable != null) {
                        attachmentDrawable.setColorFilter(this.context.getResources().getColor(R.color.intercomsdk_attachment_color), PorterDuff.Mode.SRC_IN);
                    }
                    textView.setTextColor(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
                }
            }
            layout2.addView((View)textView);
        }
        BlockUtils.setLayoutMarginsAndGravity((View)layout2, 3, isLastObject);
        return layout2;
    }
}

