/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.blocks;

import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.blocks.BlocksViewHolder;
import io.intercom.android.blocks.VideoProvider;
import io.intercom.android.blocks.models.Block;

public enum BlockType {
    paragraph{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getParagraph().addParagraph(block.getText(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    heading{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getHeading().addHeading(block.getText(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    subheading{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getSubheading().addSubheading(block.getText(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    unorderedList{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getUnorderedList().addUnorderedList(block.getItems(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    orderedList{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getOrderedList().addOrderedList(block.getItems(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    code{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getCode().addCode(block.getText(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    image{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getImage().addImage(block.getUrl(), 7.getUrl(block), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    lwr{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLwr().addLWR(block.getText(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    button{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getButton().addButton(block.getText(), 9.getUrl(block), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    facebookLikeButton{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getFacebookButton().addFacebookButton(block.getUrl(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    twitterFollowButton{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getTwitterButton().addTwitterButton("http://twitter.com/" + block.getUsername(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    video{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getVideo().addVideo(block.getEmbedUrl(), VideoProvider.videoValueOf(block.getProvider()), block.getId(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    attachmentList{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getAttachmentList().addAttachmentList(block.getAttachments(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    unknown{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            if (!block.getText().isEmpty()) {
                return viewHolder.getParagraph().addParagraph(block.getText(), block.getAlign(), isFirstObject, isLastObject, layout);
            }
            return null;
        }
    };


    public abstract View generateView(BlocksViewHolder var1, Block var2, ViewGroup var3, boolean var4, boolean var5);

    protected static String getUrl(Block block) {
        return block.getTrackingUrl().isEmpty() ? block.getLinkUrl() : block.getTrackingUrl();
    }

    public static BlockType typeValueOf(String type) {
        BlockType blockType = unknown;
        try {
            blockType = BlockType.valueOf(type);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return blockType;
    }
}

