/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.nexus;

import android.os.Handler;
import android.os.HandlerThread;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.nexus.NexusEvent;
import io.intercom.android.nexus.NexusLogger;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.json.JSONException;
import org.json.JSONObject;

class NexusSocket
implements WebSocketListener {
    private static final int OK_CLIENT_DISCONNECT = 4000;
    private static final int N_TIMEOUT_DISCONNECT = 4001;
    private static final int MAX_RECONNECT_TIME = 256;
    private static final String HEADER = "?X-Nexus-Version=android.1.0.0";
    private final NexusClient.EventNotifier eventNotifier;
    private final Handler backgroundHandler;
    private final String nexusUrl;
    private final long connectionTimeout;
    private final boolean shouldSendPresence;
    private WebSocket socket = new ClosedSocket();
    private Runnable timeoutRunnable = new Runnable(){

        @Override
        public void run() {
            NexusSocket.this.timedOut();
        }
    };
    private int reconnectAttempts = 0;

    public NexusSocket(String nexusUrl, int connectionTimeout, boolean shouldSendPresence, NexusClient.EventNotifier eventNotifier) {
        this.nexusUrl = nexusUrl;
        this.connectionTimeout = TimeUnit.SECONDS.toMillis(connectionTimeout);
        this.shouldSendPresence = shouldSendPresence;
        this.eventNotifier = eventNotifier;
        HandlerThread bgThread = new HandlerThread("background-handler");
        bgThread.start();
        this.backgroundHandler = new Handler(bgThread.getLooper());
        this.connect(nexusUrl);
    }

    private void connect(String url) {
        NexusLogger.log("connecting to a socket...");
        this.socket = new ConnectingSocket();
        final OkHttpClient client = new OkHttpClient();
        final Request request = new Request.Builder().url(url + HEADER).build();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                WebSocketCall.create((OkHttpClient)client, (Request)request).enqueue((WebSocketListener)NexusSocket.this);
                client.getDispatcher().getExecutorService().shutdown();
            }
        });
        this.backgroundHandler.postDelayed(this.timeoutRunnable, this.connectionTimeout);
    }

    public void fire(final String data) {
        if (!data.isEmpty()) {
            this.backgroundHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        NexusLogger.log("firing: " + data);
                        NexusSocket.this.socket.sendMessage(WebSocket.PayloadType.TEXT, new Buffer().writeUtf8(data));
                    }
                    catch (IOException | IllegalStateException e) {
                        NexusLogger.errorLog("fire: " + data, e);
                    }
                }
            });
        }
    }

    public void disconnect() {
        this.disconnect(4000);
    }

    public boolean isConnected() {
        return !(this.socket instanceof ClosedSocket);
    }

    private void disconnect(final int code) {
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    NexusSocket.this.socket.close(code, "Goodbye, world!");
                }
                catch (IOException e) {
                    NexusLogger.errorLog("disconnect: failed", e);
                }
                catch (IllegalStateException ex) {
                    NexusLogger.errorLog("disconnect: socket already closed", ex);
                }
            }
        });
    }

    private void timedOut() {
        if (this.socket == null) {
            this.connect(this.nexusUrl);
        } else {
            this.disconnect(4001);
        }
    }

    private void resetTimeout() {
        this.backgroundHandler.removeCallbacks(this.timeoutRunnable);
        this.backgroundHandler.postDelayed(this.timeoutRunnable, this.connectionTimeout);
    }

    private void scheduleReconnect() {
        ++this.reconnectAttempts;
        this.backgroundHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                NexusSocket.this.connect(NexusSocket.this.nexusUrl);
            }
        }, NexusSocket.calculateReconnectTimerInMS(this.reconnectAttempts));
    }

    public void onOpen(WebSocket webSocket, Request request, Response response) throws IOException {
        NexusLogger.log("onOpen: " + response.message());
        this.socket = webSocket;
        this.resetTimeout();
        this.reconnectAttempts = 0;
        if (this.shouldSendPresence) {
            this.fire(NexusEvent.UserPresence.toJsonFormattedString());
        }
    }

    public void onMessage(BufferedSource payload, WebSocket.PayloadType type) throws IOException {
        String s;
        this.resetTimeout();
        if (type == WebSocket.PayloadType.TEXT && !(s = payload.readUtf8()).isEmpty() && !s.equals(" ")) {
            try {
                JSONObject jObject = new JSONObject(s);
                String eventName = jObject.optString("eventName");
                if (!eventName.isEmpty() && !eventName.equals("ACK")) {
                    this.eventNotifier.notifyEvent(jObject);
                    NexusLogger.log("onMessage TEXT: " + s + " length: " + s.length());
                } else {
                    NexusLogger.log("onMessage ACK: " + s);
                }
            }
            catch (JSONException e) {
                NexusLogger.errorLog("onMessage: json parse exception", (Exception)((Object)e));
            }
        }
        payload.close();
    }

    public void onPong(Buffer payload) {
        payload.close();
    }

    public void onClose(int code, String reason) {
        switch (code) {
            case 4000: {
                this.shutdown();
                break;
            }
            default: {
                this.scheduleReconnect();
            }
        }
        NexusLogger.log("onClose code: " + code + " reason: " + reason);
    }

    public void onFailure(IOException e) {
        if (NexusSocket.shouldReconnectFromFailure(e.getMessage())) {
            this.scheduleReconnect();
        } else {
            this.shutdown();
        }
        NexusLogger.errorLog("onFailure: " + e.getMessage(), e);
    }

    private void shutdown() {
        this.socket = new ClosedSocket();
        this.backgroundHandler.removeCallbacksAndMessages(null);
        this.backgroundHandler.getLooper().quit();
    }

    public static long calculateReconnectTimerInMS(int reconnectAttempts) {
        int minimumBackoffSeconds = (int)Math.min(Math.pow(2.0, reconnectAttempts), 256.0);
        int jitter = new Random().nextInt(minimumBackoffSeconds + 1);
        long millis = TimeUnit.SECONDS.toMillis(minimumBackoffSeconds + jitter);
        NexusLogger.log("Scheduling reconnect in: " + millis);
        return millis;
    }

    static boolean shouldReconnectFromFailure(String exception) {
        String okhttpOpeningError = "Expected HTTP 101 response but was";
        if (exception != null) {
            if (exception.equals("closed")) {
                return false;
            }
            if (exception.startsWith(okhttpOpeningError)) {
                return exception.substring(okhttpOpeningError.length()).startsWith(" '5");
            }
        }
        return true;
    }

    private class ClosedSocket
    extends DummySocket {
        private ClosedSocket() {
        }
    }

    private class ConnectingSocket
    extends DummySocket {
        private ConnectingSocket() {
        }
    }

    private class DummySocket
    implements WebSocket {
        private DummySocket() {
        }

        public BufferedSink newMessageSink(WebSocket.PayloadType type) {
            return new Buffer();
        }

        public void sendMessage(WebSocket.PayloadType type, Buffer payload) throws IOException {
        }

        public void sendPing(Buffer payload) throws IOException {
        }

        public void close(int code, String reason) throws IOException {
        }
    }
}

