/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models.api.response;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.models.api.Participant;
import io.intercom.android.sdk.models.api.response.Part;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Conversation
implements Parcelable {
    private final Map<String, Participant> participants;
    private final List<Part> conversationParts;
    private String id;
    private boolean read;
    public static final Parcelable.Creator<Conversation> CREATOR = new Parcelable.Creator<Conversation>(){

        public Conversation createFromParcel(Parcel in) {
            return new Conversation(in);
        }

        public Conversation[] newArray(int size) {
            return new Conversation[size];
        }
    };

    public Conversation() {
        this(new Builder());
    }

    private Conversation(Builder builder) {
        this.id = builder.id == null ? "" : builder.id;
        this.read = builder.read;
        this.participants = new LinkedHashMap<String, Participant>();
        if (builder.participants != null) {
            for (Participant.Builder participantBuilder : builder.participants) {
                Participant participant = participantBuilder.build();
                this.participants.put(participant.getId(), participant);
            }
        }
        this.conversationParts = new ArrayList<Part>();
        if (builder.conversation_parts != null) {
            for (Part.Builder partBuilder : builder.conversation_parts) {
                Part part = partBuilder.build();
                part.setParticipant(this.getParticipant(part.getParticipantId()));
                this.conversationParts.add(part);
            }
        }
    }

    public List<Part> getParts() {
        return this.conversationParts;
    }

    public Part getLastPart() {
        return this.conversationParts.isEmpty() ? new Part.NullPart() : this.conversationParts.get(this.conversationParts.size() - 1);
    }

    public Part getLastAdminPart() {
        Part lastAdminPart = this.getLastPart();
        return lastAdminPart.isAdmin() ? lastAdminPart : new Part.NullPart();
    }

    public Participant getParticipant(String id2) {
        Participant participant = this.participants.get(id2);
        if (participant == null) {
            participant = new Participant.NullParticipant();
        }
        return participant;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public Participant getLastAdmin() {
        Participant lastAdmin = this.getParticipant(this.getLastAdminPart().getParticipantId());
        if (lastAdmin instanceof Participant.NullParticipant && this.participants.size() > 1) {
            ListIterator<Map.Entry<String, Participant>> iterator = new ArrayList<Map.Entry<String, Participant>>(this.participants.entrySet()).listIterator(this.participants.size());
            while (iterator.hasPrevious()) {
                Participant participant = this.participants.get(iterator.previous().getKey());
                if (!participant.isAdmin()) continue;
                lastAdmin = participant;
                break;
            }
        }
        return lastAdmin;
    }

    public Map<String, Participant> getParticipants() {
        return this.participants;
    }

    protected Conversation(Parcel in) {
        this.id = in.readString();
        this.read = in.readByte() != 0;
        this.conversationParts = new ArrayList<Part>();
        if (in.readByte() == 1) {
            in.readList(this.conversationParts, Part.class.getClassLoader());
        }
        this.participants = new LinkedHashMap<String, Participant>();
        if (in.readByte() == 1) {
            in.readHashMap(Participant.class.getClassLoader());
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeByte((byte)(this.read ? 1 : 0));
        if (this.conversationParts == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.conversationParts);
        }
        if (this.participants == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeMap(this.participants);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation that = (Conversation)o;
        if (this.read != that.read) {
            return false;
        }
        if (this.conversationParts != null ? !this.conversationParts.equals(that.conversationParts) : that.conversationParts != null) {
            return false;
        }
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.read ? 1 : 0);
        result = 31 * result + (this.conversationParts != null ? this.conversationParts.hashCode() : 0);
        return result;
    }

    public static final class Loading
    extends Conversation {
        public Loading() {
            super(new Builder());
        }
    }

    public static final class Builder {
        private String id;
        private boolean read;
        private List<Participant.Builder> participants;
        private List<Part.Builder> conversation_parts;

        public Builder withId(String id2) {
            this.id = id2;
            return this;
        }

        public Builder withRead(boolean read) {
            this.read = read;
            return this;
        }

        public Builder withParticipants(List<Participant.Builder> participants) {
            this.participants = participants;
            return this;
        }

        public Builder withParts(List<Part.Builder> parts) {
            this.conversation_parts = parts;
            return this;
        }

        public Conversation build() {
            return new Conversation(this);
        }
    }
}

