/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models.api;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.models.Message;
import io.intercom.android.sdk.models.api.LWROption;
import java.util.ArrayList;
import java.util.List;

public class LWR
implements Parcelable {
    private final String type;
    private final List<LWROption> options;
    private String option;
    public static final Parcelable.Creator<LWR> CREATOR = new Parcelable.Creator<LWR>(){

        public LWR createFromParcel(Parcel in) {
            return new LWR(in);
        }

        public LWR[] newArray(int size) {
            return new LWR[size];
        }
    };

    public LWR() {
        this(new Builder());
    }

    private LWR(Builder builder) {
        this.type = builder.type == null ? "" : builder.type;
        this.options = builder.options == null ? new ArrayList() : builder.options;
        this.option = builder.option == null ? "" : builder.option;
    }

    public String getType() {
        return this.type;
    }

    public List<LWROption> getOptions() {
        return this.options;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LWR lwr = (LWR)o;
        if (this.type != null ? !this.type.equals(lwr.type) : lwr.type != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(lwr.options) : lwr.options != null) {
            return false;
        }
        return !(this.option == null ? lwr.option != null : !this.option.equals(lwr.option));
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        result = 31 * result + (this.option != null ? this.option.hashCode() : 0);
        return result;
    }

    protected LWR(Parcel in) {
        this.type = in.readString();
        if (in.readByte() == 1) {
            this.options = new ArrayList<LWROption>();
            in.readList(this.options, Message.class.getClassLoader());
        } else {
            this.options = null;
        }
        this.option = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.type);
        if (this.options == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.options);
        }
        dest.writeString(this.option);
    }

    public static final class NullLWR
    extends LWR {
        public NullLWR() {
            super(new Builder());
        }
    }

    public static class Builder {
        private String type;
        private List<LWROption> options;
        private String option;

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withOptions(List<LWROption> options) {
            this.options = options;
            return this;
        }

        public Builder withOption(String option) {
            this.option = option;
            return this;
        }

        public LWR build() {
            return new LWR(this);
        }
    }
}

