/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.squareup.otto.Subscribe;
import io.intercom.android.blocks.BlockType;
import io.intercom.android.blocks.Blocks;
import io.intercom.android.blocks.models.Block;
import io.intercom.android.nexus.NexusEvent;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.BaseConversationFragment;
import io.intercom.android.sdk.conversation.ComposerTextWatcher;
import io.intercom.android.sdk.conversation.ConversationAdapter;
import io.intercom.android.sdk.conversation.SpoolWrapper;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.conversation.events.AdminTypingEndedEvent;
import io.intercom.android.sdk.conversation.events.CancelAdminTypingEvent;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Events.ConversationEvent;
import io.intercom.android.sdk.models.Events.Failure.ConversationFailedEvent;
import io.intercom.android.sdk.models.Events.Failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.Events.Failure.ReplyFailedEvent;
import io.intercom.android.sdk.models.Events.InboxEvent;
import io.intercom.android.sdk.models.Events.NewConversationEvent;
import io.intercom.android.sdk.models.Events.ReplyEvent;
import io.intercom.android.sdk.models.Events.UnreadConversationsEvent;
import io.intercom.android.sdk.models.Events.realtime.NewCommentEvent;
import io.intercom.android.sdk.models.api.Avatar;
import io.intercom.android.sdk.models.api.LWR;
import io.intercom.android.sdk.models.api.Participant;
import io.intercom.android.sdk.models.api.response.Conversation;
import io.intercom.android.sdk.models.api.response.Part;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.NameUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.ConversationListView;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

@TargetApi(value=15)
public class ConversationFragment
extends BaseConversationFragment
implements View.OnClickListener,
AdapterView.OnItemClickListener,
View.OnFocusChangeListener {
    public static final String ARG_UNREAD_COUNT = "intercomsdk-unreadCount";
    public static final String ARG_IS_READ = "intercomsdk-isRead";
    private static final String ARG_CONVERSATION_ID = "conversationId";
    private static final int DELIVERED_TIMER = 10000;
    private final Set<String> currentTypers = new HashSet<String>();
    private final List<Part> sendingFailures = new ArrayList<Part>();
    protected LinearLayout inputView;
    protected View rootView;
    protected EditText messageTextBox;
    protected ComposerTextWatcher textWatcher;
    private ConversationListView conversationList;
    private ImageButton sendButton;
    private TextView conversationTitleText;
    private LinearLayout loadingLayout;
    private Button unreadText;
    private Conversation conversation;
    private TextView pill;
    private ImageButton inboxButton;
    private int unreadCount = 0;
    private SpoolWrapper spool;

    public static ConversationFragment newInstance(String conversationId, int unreadCount, boolean isRead) {
        ConversationFragment frag = new ConversationFragment();
        Bundle args = new Bundle();
        args.putString(ARG_CONVERSATION_ID, conversationId);
        args.putInt(ARG_UNREAD_COUNT, unreadCount);
        args.putBoolean(ARG_IS_READ, isRead);
        frag.setArguments(args);
        return frag;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.conversationId = args.getString(ARG_CONVERSATION_ID, "");
            this.unreadCount = args.getInt(ARG_UNREAD_COUNT, 0);
            boolean isRead = args.getBoolean(ARG_IS_READ, false);
            if (!isRead) {
                --this.unreadCount;
            }
        }
        this.conversationParts = new ArrayList();
        this.conversation = new Conversation();
        this.spool = new SpoolWrapper((Context)this.getActivity());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercomsdk_fragment_conversation, container, false);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.unreadText = (Button)this.rootView.findViewById(R.id.unread_text);
        this.inputView = (LinearLayout)this.rootView.findViewById(R.id.composer_input_view);
        this.loadingLayout = (LinearLayout)this.rootView.findViewById(R.id.loading_layout);
        this.conversationTitleText = (TextView)this.rootView.findViewById(R.id.conversation_title_text);
        this.pill = (TextView)this.rootView.findViewById(R.id.pill);
        this.pill.setOnClickListener((View.OnClickListener)this);
        this.conversationList = (ConversationListView)this.rootView.findViewById(R.id.conversation_list);
        this.conversationList.setOnBottomReachedListener(new ConversationListView.OnBottomReachedListener(){

            @Override
            public void onBottomReached() {
                ConversationFragment.this.pill.setVisibility(8);
            }
        });
        this.sendButton = (ImageButton)this.inputView.findViewById(R.id.send_button);
        this.messageTextBox = (EditText)this.inputView.findViewById(R.id.input_text);
        this.messageTextBox.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        GradientDrawable background = (GradientDrawable)this.unreadText.getBackground();
        background.setColor(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
        this.blocks = new Blocks((Context)this.getActivity());
        this.sendButton.setAlpha(0.6f);
        ImageButton closeButton = (ImageButton)this.rootView.findViewById(R.id.close_composer_button);
        this.inboxButton = (ImageButton)this.rootView.findViewById(R.id.inbox_button);
        this.sendButton.setOnClickListener((View.OnClickListener)this);
        closeButton.setOnClickListener((View.OnClickListener)this);
        this.inboxButton.setOnClickListener((View.OnClickListener)this);
        this.conversationList.setOnItemClickListener(this);
        this.conversationTitleText.setTypeface(FontUtils.getTypeface("Roboto-Medium.ttf", (Context)this.getActivity()));
        this.adapter = new ConversationAdapter((Context)this.getActivity(), R.layout.intercomsdk_row_user_part, this.conversationParts);
        this.conversationList.setAdapter((ListAdapter)this.adapter);
        Bridge.getBus().register((Object)this);
        this.setupComposer();
        this.updateUnreadCount(this.unreadCount);
        this.textWatcher = new ComposerTextWatcher(this.sendButton, this.conversationId, Bridge.getIdentityStore().getIntercomId());
        this.messageTextBox.addTextChangedListener((TextWatcher)this.textWatcher);
        return this.rootView;
    }

    public void onStart() {
        super.onStart();
        if (!this.conversationId.isEmpty()) {
            Bridge.getPoller().startConversationPolling(this.conversationId);
        }
    }

    public void onStop() {
        super.onStop();
        if (!this.conversationId.isEmpty()) {
            Bridge.getPoller().endConversationPolling();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        Bridge.getBus().unregister((Object)this);
        this.textWatcher.cleanup();
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.inbox_button) {
            view.setEnabled(false);
            this.inboxTapped();
        } else if (id2 == R.id.send_button) {
            this.sendTapped();
        } else if (id2 == R.id.close_composer_button) {
            this.closeTapped();
        } else if (id2 == R.id.pill) {
            this.conversationList.smoothScrollToPosition(this.conversationList.getBottom());
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Part part = (Part)this.conversationParts.get(position);
        if ("intercom_powered_by".equals(part.getMessageStyle())) {
            String poweredByUrl = "http://www.intercom.io/?utm_source=android-sdk&utm_medium=outbound&utm_campaign=powered-by-intercom";
            Part firstPart = (Part)this.conversationParts.get(0);
            if ("intercom_welcome_message".equals(firstPart.getMessageStyle()) || !firstPart.isAdmin()) {
                poweredByUrl = "http://www.intercom.io/?utm_source=android-sdk&utm_medium=inbound&utm_campaign=powered-by-intercom";
            }
            Uri uri = Uri.parse((String)poweredByUrl);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.setFlags(0x10000000);
            this.startActivity(intent);
        } else {
            part.setLayout(this.blocks.createBlocks(part.getBlocks(), this.generator.getUserHolder()));
            part.setMessageStyle("intercom_sending_message_style");
            part.setFooter(this.getString(R.string.intercomsdk_sending));
            this.conversationParts.remove(this.conversationParts.indexOf(part));
            this.conversationParts.add(this.conversationParts.size(), part);
            this.adapter.notifyDataSetChanged();
            String partText = part.getBlocks().get(0).getText();
            if (this.conversationId == null || this.conversationId.isEmpty()) {
                this.startConversation(partText, part.getId());
            } else {
                this.replyToConversation(partText, part);
            }
        }
    }

    @Override
    protected void closeTapped() {
        this.hideKeyboard();
        super.closeTapped();
    }

    private void inboxTapped() {
        this.hideKeyboard();
        this.listener.loadInbox();
    }

    private void sendTapped() {
        String text = this.messageTextBox.getText().toString().trim();
        if (!text.isEmpty()) {
            Part message = this.createSendingUI(text);
            this.spool.playReplySendingSound();
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.sendButton.setEnabled(false);
                this.startConversation(text, message.getId());
                this.messageTextBox.setText((CharSequence)"");
            } else {
                this.replyToConversation(text, message);
                this.messageTextBox.setText((CharSequence)"");
            }
            this.conversationList.smoothScrollToPosition(this.conversationList.getBottom());
        }
    }

    private void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.messageTextBox.getWindowToken(), 0);
    }

    private void setupComposer() {
        this.messageTextBox.requestFocus();
        this.configureInputView(this.conversation);
        if (this.conversationId.isEmpty()) {
            this.sanitizeConversationParts(this.conversationParts);
            this.addWelcomeMessage();
            if (!this.hasPoweredBy(this.conversationParts) && Bridge.getIdentityStore().getAppConfig().isShowPoweredBy()) {
                this.addPoweredBy(false);
            }
            this.conversationList.setVisibility(0);
            this.conversationTitleText.setText(R.string.intercomsdk_new_conversation_title);
            this.messageTextBox.setHint(R.string.intercomsdk_start_new_conversation);
        } else {
            Bridge.getApi().getConversation(this.conversationId);
            this.loadingLayout.setVisibility(0);
            ((ProgressBar)this.loadingLayout.findViewById(R.id.progressBar)).getIndeterminateDrawable().setColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()), PorterDuff.Mode.SRC_IN);
            this.conversationList.setVisibility(0);
            this.inputView.setVisibility(8);
            this.rootView.findViewById(R.id.bottom_shadow).setVisibility(8);
            this.adapter.notifyDataSetChanged();
        }
    }

    private void updateUnreadCount(int count) {
        if (count <= 0) {
            this.unreadText.setVisibility(8);
            this.inboxButton.setImageResource(R.drawable.intercomsdk_inbox_button_selector);
        } else {
            this.unreadText.setVisibility(0);
            this.unreadText.setText((CharSequence)String.valueOf(count));
            this.inboxButton.setImageResource(R.drawable.intercomsdk_inbox_button_badge_selector);
        }
    }

    private void startConversation(String text, String partId) {
        Bridge.getApi().startNewConversation(text, this.conversationParts.size() - 1, partId);
    }

    private void replyToConversation(String text, Part part) {
        Bridge.getApi().replyToConversation(this.conversationId, text, this.conversationParts.size() - 1, part.getId());
    }

    @Subscribe
    public void conversationSuccess(ConversationEvent event) {
        int conversationSize = this.conversation.getParts().size();
        List<Part> eventParts = event.getResponse().getParts();
        if (!eventParts.isEmpty() && eventParts.get(0).isAdmin()) {
            eventParts.get(0).setFirstChatPart(true);
        }
        if (event.getResponse().getId().equals(this.conversationId) && eventParts.size() > conversationSize) {
            this.conversation = event.getResponse();
            if (this.isAdded()) {
                this.setupWithConversation();
            }
            if (!this.conversation.getRead().booleanValue()) {
                this.markAsRead();
                Bridge.getNexusClient().fire(NexusEvent.getConversationSeenEvent((String)this.conversationId, (String)Bridge.getIdentityStore().getIntercomId()));
            }
            if (!this.conversationList.isAtBottom()) {
                if (conversationSize != 0) {
                    this.pill.setVisibility(0);
                }
            } else {
                this.conversationList.smoothScrollToPosition(this.conversationList.getBottom());
            }
            if (conversationSize != 0) {
                List<Part> newParts = eventParts.subList(conversationSize, eventParts.size());
                for (Part p : newParts) {
                    if (!p.isAdmin()) continue;
                    this.spool.playAdminReplySound();
                    break;
                }
                Bridge.getBus().post((Object)new CancelAdminTypingEvent());
                this.currentTypers.clear();
            }
            this.adapter.sort(new Comparator<Part>(){

                @Override
                public int compare(Part lhs, Part rhs) {
                    return (int)(lhs.getCreatedAt() - rhs.getCreatedAt());
                }
            });
        }
    }

    @Subscribe
    public void conversationFailure(ConversationFailedEvent event) {
    }

    @Subscribe
    public void newConversationSuccess(NewConversationEvent event) {
        if (!this.conversationParts.isEmpty() && ((Part)this.conversationParts.get(this.conversationParts.size() - 1)).getId().equals(event.getIdentifier())) {
            this.conversation = event.getResponse();
            this.conversationId = this.conversation.getId();
            this.sendButton.setEnabled(true);
            this.conversationParts.remove(this.conversationParts.size() - 1);
            Part newPart = this.createMessageUI(event.getResponse().getParts().get(0));
            this.conversationParts.add(newPart);
            this.textWatcher.setConversationId(this.conversationId);
            Bridge.getPoller().startConversationPolling(this.conversationId);
            Bridge.getNexusClient().fire(NexusEvent.getCreateConversationEvent((String)this.conversationId, (String)Bridge.getIdentityStore().getIntercomId()));
            if (!this.hasPoweredBy(this.conversationParts) && Bridge.getIdentityStore().getAppConfig().isShowPoweredBy()) {
                this.addPoweredBy(true);
            }
            this.spool.playReplySuccessSound();
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void newConversationFailure(NewConversationFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId());
    }

    @Subscribe
    public void replySuccess(ReplyEvent event) {
        if (event.getConversationId().equals(this.conversationId)) {
            Bridge.getNexusClient().fire(NexusEvent.getNewCommentEvent((String)this.conversationId, (String)Bridge.getIdentityStore().getIntercomId()));
            Part response = event.getResponse();
            Participant participant = this.conversation.getParticipant(response.getParticipantId());
            if (participant instanceof Participant.NullParticipant) {
                participant = new Participant.Builder().withId(response.getParticipantId()).build();
                this.conversation.getParticipants().put(response.getParticipantId(), participant);
            }
            response.setParticipant(participant);
            this.sendButton.setEnabled(true);
            int position = this.positionOfTempPart(event.getPosition(), event.getPartId());
            if (position >= 0) {
                this.sendingFailures.remove(this.conversationParts.remove(position));
            }
            final Part newPart = this.createMessageUI(response);
            newPart.setDisplayDelivered(true);
            this.conversationParts.add(this.conversationParts.size(), newPart);
            this.adapter.notifyDataSetChanged();
            this.spool.playReplySuccessSound();
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    newPart.setDisplayDelivered(false);
                    ConversationFragment.this.adapter.notifyDataSetChanged();
                }
            }, 10000L);
        }
    }

    @Subscribe
    public void replyFailure(ReplyFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId());
        this.spool.playReplyFailSound();
    }

    private void markAsFailed(int position, String partId) {
        int partPosition = this.positionOfTempPart(position, partId);
        if (partPosition >= 0) {
            Part failedPart = (Part)this.conversationParts.get(partPosition);
            failedPart.setLayout(this.blocks.createBlocks(failedPart.getBlocks(), this.generator.getUserHolder()));
            failedPart.setMessageStyle("intercom_failed_message_style");
            failedPart.setFooter(this.getString(R.string.intercomsdk_sending_failure));
            this.adapter.notifyDataSetChanged();
        }
    }

    private int positionOfTempPart(int position, String partId) {
        if (position >= 0 && position < this.conversationParts.size()) {
            Part sendingPart = (Part)this.conversationParts.get(position);
            if (sendingPart.getId().equals(partId)) {
                return position;
            }
            for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
                if (!((Part)this.conversationParts.get(i)).getId().equals(partId)) continue;
                return i;
            }
        }
        return -1;
    }

    private void setupWithConversation() {
        this.messageTextBox.setHint((CharSequence)this.getString(R.string.intercomsdk_write_a_reply));
        this.conversationList.setVisibility(0);
        this.loadingLayout.setVisibility(8);
        this.createConversationUI(this.conversation.getParts());
        this.updateTimeStampScheduler();
    }

    private void sanitizeConversationParts(List<Part> messageList) {
        for (int i = messageList.size() - 1; i >= 0; --i) {
            Part message = messageList.get(i);
            if (message.getMessageStyle().equals("intercom_welcome_message")) {
                messageList.remove(message);
                continue;
            }
            this.sanitizeMessage(message);
        }
    }

    private void addWelcomeMessage() {
        List<Block> welcomeBlocks = Bridge.getIdentityStore().getAppConfig().getWelcomeMessage();
        if (!welcomeBlocks.isEmpty()) {
            LinearLayout layout2 = this.blocks.createBlocks(welcomeBlocks, this.generator.getWelcomeHolder());
            ImageView infoImage = (ImageView)LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.intercomsdk_welcome_message_icon, (ViewGroup)layout2, false);
            layout2.addView((View)infoImage, 0);
            ImageView divider = (ImageView)LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.intercomsdk_rowdivider, (ViewGroup)layout2, false);
            layout2.addView((View)divider);
            Participant user = new Participant.Builder().build();
            Part part = new Part();
            part.setMessageStyle("intercom_welcome_message");
            part.setParticipant(user);
            part.setBlocks(welcomeBlocks);
            part.setLayout(layout2);
            part.setAttachments(new ArrayList<Attachments>());
            part.setId(UUID.randomUUID().toString());
            this.conversationParts.add(0, part);
            this.adapter.notifyDataSetChanged();
        }
    }

    protected void configureInputView(Conversation conversation) {
        if (!conversation.getParts().isEmpty() && conversation.getParts().size() == 1 && !(conversation.getParts().get(0).getLightweightReply() instanceof LWR.NullLWR)) {
            this.inputView.setVisibility(8);
            this.rootView.findViewById(R.id.bottom_shadow).setVisibility(8);
        } else {
            this.inputView.setVisibility(0);
            this.messageTextBox.requestFocus();
            this.rootView.findViewById(R.id.bottom_shadow).setVisibility(0);
        }
    }

    private void createConversationUI(List<Part> parts) {
        ArrayList<Participant> admins = new ArrayList<Participant>();
        this.conversationParts.clear();
        for (Part part : parts) {
            if (part.getLayout() == null) {
                part = this.createMessageUI(part);
            }
            this.conversationParts.add(this.conversationParts.size(), part);
            if (!"admin".equals(part.getParticipant().getType()) || part.getParticipantId().equals(Bridge.getIdentityStore().getIntercomId())) continue;
            admins.add(part.getParticipant());
        }
        if (!parts.isEmpty() && "user".equals(parts.get(0).getParticipant().getType()) && !parts.get(0).getMessageStyle().equals("intercom_welcome_message")) {
            this.addWelcomeMessage();
        }
        if (!this.hasPoweredBy(parts) && Bridge.getIdentityStore().getAppConfig().isShowPoweredBy()) {
            this.addPoweredBy(false);
        }
        this.conversationParts.addAll(this.sendingFailures);
        if (parts.get(parts.size() - 1).isFirstChatPart()) {
            this.conversationList.setSelection(0);
        } else {
            this.conversationList.setSelection(this.conversationParts.size() - 1);
        }
        this.configureInputView(this.conversation);
        this.adapter.notifyDataSetChanged();
        this.conversationList.setVisibility(0);
        this.updateTitle(admins);
    }

    private Part createSendingUI(String text) {
        ArrayList<Block> blockParts = new ArrayList<Block>();
        Block block = new Block.Builder().withText(text).withType(BlockType.paragraph.name()).build();
        blockParts.add(block);
        Participant user = this.conversation.getParticipant(Bridge.getIdentityStore().getIntercomId());
        Part message = new Part();
        message.setMessageStyle("intercom_sending_message_style");
        message.setParticipant(user);
        message.setBlocks(blockParts);
        message.setFooter(this.getString(R.string.intercomsdk_sending));
        message.setCreatedAt(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        message.setLayout(this.blocks.createBlocks(blockParts, this.generator.getPreviewHolder()));
        message.setAttachments(new ArrayList<Attachments>());
        message.setId(UUID.randomUUID().toString());
        message.setEntranceAnimation(true);
        message.setShowCreatedAt(true);
        if (this.conversationParts.size() == 1 && ((Part)this.conversationParts.get(0)).getMessageStyle().equals("intercom_powered_by")) {
            this.conversationParts.add(0, message);
        } else {
            this.conversationParts.add(this.conversationParts.size(), message);
        }
        this.sendingFailures.add(message);
        this.adapter.notifyDataSetChanged();
        return message;
    }

    private void updateTitle(List<Participant> admins) {
        LinkedHashSet<String> uniqueAdminIds = new LinkedHashSet<String>();
        ArrayList<String> adminNames = new ArrayList<String>();
        for (int i = admins.size() - 1; i >= 0; --i) {
            Participant user = admins.get(i);
            if (uniqueAdminIds.contains(user.getId())) continue;
            adminNames.add(user.getDisplayName());
            uniqueAdminIds.add(user.getId());
        }
        this.conversationTitleText.setText((CharSequence)NameUtils.getFormattedAdmins(adminNames, (Context)this.getActivity()));
    }

    protected int getInputViewVisibility() {
        return this.inputView.getVisibility();
    }

    @Subscribe
    public void inboxCallback(InboxEvent event) {
        int newUnreadCount = this.filterCurrentConversation(event.getResponse().getTotalUnreadCount(), event.getResponse().getConversations());
        this.updateUnreadCount(newUnreadCount);
    }

    @Subscribe
    public void previewServiceCallback(UnreadConversationsEvent event) {
        int newUnreadCount = this.filterCurrentConversation(event.getResponse().getTotalUnreadCount(), event.getResponse().getConversations());
        this.updateUnreadCount(newUnreadCount);
    }

    private int filterCurrentConversation(int newUnreadCount, List<Conversation> conversations) {
        for (Conversation c : conversations) {
            if (!c.getId().equals(this.conversationId) || c.getRead().booleanValue()) continue;
            --newUnreadCount;
            break;
        }
        return newUnreadCount;
    }

    private boolean hasPoweredBy(List<Part> parts) {
        for (Part part : parts) {
            if (!part.getMessageStyle().equals("intercom_powered_by")) continue;
            return true;
        }
        return false;
    }

    private void addPoweredBy(boolean shouldAnimate) {
        if (!this.conversationParts.isEmpty()) {
            Part poweredBy = new Part();
            poweredBy.setEntranceAnimation(shouldAnimate);
            poweredBy.setMessageStyle("intercom_powered_by");
            poweredBy.setCreatedAt(((Part)this.conversationParts.get(0)).getCreatedAt() + 1L);
            this.conversationParts.add(1, poweredBy);
        }
    }

    private void updateTimeStampScheduler() {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ConversationFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ConversationFragment.this.adapter.notifyDataSetChanged();
                    }
                });
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        if (event.getConversationId().equals(this.conversationId) && event.getUserId().equals(Bridge.getIdentityStore().getIntercomId())) {
            Bridge.getApi().getConversation(this.conversationId);
            Bridge.getPoller().resetConversationPoll();
        }
    }

    @Subscribe
    public void adminIsTyping(AdminIsTypingEvent event) {
        if (this.conversationId.equals(event.getConversationId())) {
            Bridge.getPoller().resetConversationPoll();
            if (!this.currentTypers.contains(event.getAdminId())) {
                Part isTypingPart = new Part();
                Participant participant = this.conversation.getParticipant(event.getAdminId());
                if (participant instanceof Participant.NullParticipant) {
                    participant = new Participant.Builder().withId(event.getAdminId()).withName(event.getAdminName()).withAvatar(new Avatar.Builder().withImageUrl(event.getAdminAvatarUrl())).withType("admin").build();
                }
                isTypingPart.setParticipant(participant);
                isTypingPart.setMessageStyle("admin_is_typing_style");
                isTypingPart.setId(UUID.randomUUID().toString());
                isTypingPart.setEntranceAnimation(true);
                LinearLayout contentLayout = (LinearLayout)View.inflate((Context)this.getActivity().getApplicationContext(), (int)R.layout.intercomsdk_blocks_admin_layout, null);
                AdminIsTypingView adminIsTypingView = new AdminIsTypingView(this.getActivity().getApplicationContext(), event.getAdminId(), this.conversationId, isTypingPart.getId());
                contentLayout.addView((View)adminIsTypingView);
                isTypingPart.setLayout(contentLayout);
                int index = this.conversationParts.isEmpty() ? 0 : this.conversationParts.size();
                this.conversationParts.add(index, isTypingPart);
                this.adapter.notifyDataSetChanged();
                this.currentTypers.add(event.getAdminId());
                if (this.conversationList.isAtBottom()) {
                    this.conversationList.smoothScrollToPosition(this.conversationList.getBottom());
                }
            }
        }
    }

    @Subscribe
    public void adminIsntTyping(AdminTypingEndedEvent event) {
        int position = this.positionOfTempPart(this.conversationParts.size() - 1, event.getPartId());
        if (position >= 0) {
            this.currentTypers.remove(event.getAdminId());
            this.conversationParts.remove(position);
            this.adapter.notifyDataSetChanged();
        }
    }

    public void onFocusChange(View view, boolean hasFocus) {
        if (view.getId() == R.id.input_text && !hasFocus) {
            InputMethodManager inputMethodManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }
}

