/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.logger.Logger;

public class Migrations {
    private static final String MIGRATION_PREFS = "INTERCOM_MIGRATION_PREFS";
    private static final String MIGRATION_090 = "migration to 0.9.0!";

    public static void runAll(Context context) {
        Migrations.runInitialMigrations(context);
    }

    private static void runInitialMigrations(Context context) {
        SharedPreferences migrationPrefs = context.getSharedPreferences(MIGRATION_PREFS, 0);
        if (!migrationPrefs.getBoolean(MIGRATION_090, false)) {
            Logger.DEBUG("starting migration from 0.8.x to 0.9.0");
            SharedPreferences dataPrefs = context.getSharedPreferences("INTERCOM_SDK_DATA", 0);
            SharedPreferences oldIntercomPrefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
            String intercomUserId = oldIntercomPrefs.getString("intercomsdk-session-IntercomUserId", "");
            if (!TextUtils.isEmpty((CharSequence)intercomUserId)) {
                Bridge.getIdentityStore().getUserIdentity().register("", "", intercomUserId);
            }
            String data = dataPrefs.getString("intercomsdk-session-SecureMode_Data", "");
            String hmac = dataPrefs.getString("intercomsdk-session-SecureMode_HMAC", "");
            if (!data.isEmpty() && !hmac.isEmpty()) {
                Bridge.getIdentityStore().setSecureMode(hmac, data);
            }
            migrationPrefs.edit().putBoolean(MIGRATION_090, true).apply();
        }
    }
}

