/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Application;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.IntDef;
import io.intercom.android.sdk.DummyIntercom;
import io.intercom.android.sdk.RealIntercom;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.preview.IntercomPreviewPosition;
import io.intercom.android.sdk.utilities.DeviceUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public abstract class Intercom {
    public static final String GCM_RECEIVER = "intercom_sdk";
    public static final int VISIBLE = 0;
    public static final int GONE = 1;
    private static Intercom instance;

    public static synchronized void initialize(Application application, String apiKey, String appId) {
        if (instance == null) {
            if (DeviceUtils.isMessagingSDKSupported(Build.VERSION.SDK_INT)) {
                instance = new RealIntercom(application, apiKey, appId);
            } else {
                instance = new DummyIntercom();
                Logger.INFO("Intercom has no functionality " + Build.VERSION.CODENAME + " devices");
            }
        } else {
            Logger.INFO("Intercom has already been initialized");
        }
    }

    public static synchronized Intercom client() {
        if (instance == null) {
            throw new IllegalStateException("Please call Intercom.initialize() before requesting the client.");
        }
        return instance;
    }

    public abstract void registerUnidentifiedUser();

    public abstract void registerIdentifiedUser(Registration var1);

    public abstract void setSecureMode(String var1, String var2);

    public abstract void updateUser(Map<String, Object> var1);

    public abstract void logEvent(String var1);

    public abstract void logEvent(String var1, Map<String, Object> var2);

    public abstract void displayMessageComposer();

    public abstract void displayConversationsList();

    public abstract void setPreviewPosition(IntercomPreviewPosition var1);

    public abstract void setVisibility(int var1);

    @Deprecated
    public abstract void setMessagesHidden(boolean var1);

    public abstract void setupGCM(String var1, int var2);

    public abstract boolean openGCMMessage(Uri var1);

    public abstract void reset();

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    public static @interface Visibility {
    }
}

