/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;

public class Avatar
implements Parcelable {
    private final String imageUrl;
    private final String initials;
    private final String color;
    public static final Parcelable.Creator<Avatar> CREATOR = new Parcelable.Creator<Avatar>(){

        public Avatar createFromParcel(Parcel in) {
            return new Avatar(in);
        }

        public Avatar[] newArray(int size) {
            return new Avatar[size];
        }
    };

    private Avatar(Builder builder) {
        this.imageUrl = builder.image_url == null ? "" : builder.image_url;
        this.initials = builder.initials == null ? "" : builder.initials;
        this.color = builder.color == null ? "#ff1d78ae" : builder.color;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getColor() {
        return this.color;
    }

    public String getInitials() {
        return this.initials;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.imageUrl);
        dest.writeString(this.initials);
        dest.writeString(this.color);
    }

    private Avatar(Parcel in) {
        this.imageUrl = in.readString();
        this.initials = in.readString();
        this.color = in.readString();
    }

    public static final class Builder {
        private String image_url;
        private String initials;
        private String color;

        public Builder withImageUrl(String imageUrl) {
            this.image_url = imageUrl;
            return this;
        }

        public Builder withInitials(String initials) {
            this.initials = initials;
            return this;
        }

        public Avatar build() {
            return new Avatar(this);
        }
    }
}

