/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.intercom.android.blocks.models.Block;
import io.intercom.android.nexus.NexusConfig;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Config;
import java.util.ArrayList;
import java.util.List;

public class AppConfig {
    private static final String APP_COLOR = "app_color";
    private static final String APP_POWERED_BY = "app_powered_by";
    private static final String APP_FIRST_REQUEST = "app_is_first_request";
    private static final String APP_INBOUND_MESSAGES = "app_inbound_messages";
    private static final String APP_WELCOME_MESSAGE = "app_welcome_message";
    private static final String APP_POLLING_INTERVAL = "app_polling_interval";
    private static final String APP_REAL_TIME = "app_real_time";
    private static final String APP_MESSAGE_RESPONSE = "app_message_response";
    private static final String APP_AUDIO_ENABLED = "app_audio_enabled";
    private final SharedPreferences prefs;
    private NexusConfig realTimeConfig = new NexusConfig();
    private List<Block> welcomeMessage = new ArrayList<Block>();
    private BaseColorObjects baseColorObjects;
    private String baseColor = "";
    private String messageResponse = "";
    private int pollingInterval;
    private boolean isFirstRequest;
    private boolean inboundMessages;
    private boolean showPoweredBy;
    private boolean realTime;
    private boolean audioEnabled;

    public AppConfig(Context context) {
        this.prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        this.welcomeMessage = this.setUpWelcomeMessage();
        this.baseColor = this.prefs.getString(APP_COLOR, String.format("#%06X", 0xFFFFFF & context.getResources().getColor(R.color.intercomsdk_main_blue)));
        this.baseColorObjects = new BaseColorObjects(context, this.baseColor);
        this.showPoweredBy = this.prefs.getBoolean(APP_POWERED_BY, false);
        this.isFirstRequest = this.prefs.getBoolean(APP_FIRST_REQUEST, false);
        this.inboundMessages = this.prefs.getBoolean(APP_INBOUND_MESSAGES, false);
        this.pollingInterval = this.prefs.getInt(APP_POLLING_INTERVAL, 60);
        this.realTime = this.prefs.getBoolean(APP_REAL_TIME, false);
        this.messageResponse = this.prefs.getString(APP_MESSAGE_RESPONSE, "");
        this.audioEnabled = this.prefs.getBoolean(APP_AUDIO_ENABLED, true);
    }

    protected void update(Config config) {
        if (this.isNewConfig(config)) {
            boolean nexusConfigChanged = !config.getRealTimeConfig().equals((Object)this.realTimeConfig);
            this.welcomeMessage = config.getWelcomeMessage();
            this.baseColor = config.getBaseColor();
            this.isFirstRequest = config.isFirstRequest();
            this.inboundMessages = config.isInboundMessages();
            this.showPoweredBy = config.isShowPoweredBy();
            this.audioEnabled = config.isAudioEnabled();
            this.realTime = config.isRealTime();
            this.pollingInterval = config.getPollingInterval();
            this.messageResponse = config.getMessageResponse();
            this.realTimeConfig = config.getRealTimeConfig();
            SharedPreferences.Editor editor = this.prefs.edit();
            editor.putString(APP_WELCOME_MESSAGE, new Gson().toJson(this.welcomeMessage));
            editor.putString(APP_COLOR, this.baseColor);
            editor.putString(APP_MESSAGE_RESPONSE, this.messageResponse);
            editor.putInt(APP_POLLING_INTERVAL, this.pollingInterval);
            editor.putBoolean(APP_POWERED_BY, this.showPoweredBy);
            editor.putBoolean(APP_FIRST_REQUEST, this.isFirstRequest);
            editor.putBoolean(APP_INBOUND_MESSAGES, this.inboundMessages);
            editor.putBoolean(APP_AUDIO_ENABLED, this.audioEnabled);
            editor.putBoolean(APP_REAL_TIME, this.realTime);
            editor.apply();
            if (this.isFirstRequest) {
                LayoutInflater inflater = LayoutInflater.from((Context)Bridge.getContext());
                View view = inflater.inflate(R.layout.intercomsdk_onboarding_layout, null);
                Toast toast = new Toast(Bridge.getContext());
                toast.setGravity(17, 0, 0);
                toast.setDuration(1);
                toast.setView(view);
                toast.show();
            }
            if (nexusConfigChanged) {
                Bridge.getNexusClient().cycle(this.realTimeConfig, true);
            }
        }
    }

    private List<Block> setUpWelcomeMessage() {
        String json = this.prefs.getString(APP_WELCOME_MESSAGE, "");
        List blocks = (List)new Gson().fromJson(json, new TypeToken<List<Block>>(){}.getType());
        return blocks == null ? new ArrayList() : blocks;
    }

    public List<Block> getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public String getBaseColor() {
        return this.baseColor;
    }

    public Drawable getBaseColorAvatar() {
        return this.baseColorObjects.getAvatar();
    }

    public boolean isShowPoweredBy() {
        return this.showPoweredBy;
    }

    public boolean isInboundMessages() {
        return this.inboundMessages;
    }

    public boolean isFirstRequest() {
        return this.isFirstRequest;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean isRealTime() {
        return this.realTime && !this.realTimeConfig.getEndpoints().isEmpty();
    }

    public NexusConfig getRealTimeConfig() {
        return this.realTimeConfig;
    }

    public String getMessageResponse() {
        return this.messageResponse;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    private boolean isNewConfig(Config config) {
        return !config.getMessageResponse().equals(this.messageResponse) || !config.getWelcomeMessage().equals(this.welcomeMessage) || !config.getRealTimeConfig().equals((Object)this.realTimeConfig) || !config.getBaseColor().equals(this.baseColor) || config.getPollingInterval() != this.pollingInterval || config.isAudioEnabled() != this.audioEnabled || config.isRealTime() != this.realTime || config.isShowPoweredBy() != this.showPoweredBy || config.isInboundMessages() != this.inboundMessages || config.isFirstRequest() != this.isFirstRequest;
    }

    static class BaseColorObjects {
        private final Drawable avatar;

        private BaseColorObjects(Context context, String baseColor) {
            this.avatar = this.replaceColor(context, Color.parseColor((String)baseColor));
        }

        private Drawable replaceColor(Context context, int baseColor) {
            Bitmap originalAvatar;
            Bitmap newAvatar = originalAvatar = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.intercomsdk_avatar);
            int originalColor = context.getResources().getColor(R.color.intercomsdk_main_blue);
            if (originalColor != baseColor) {
                int width = originalAvatar.getWidth();
                int height = originalAvatar.getHeight();
                int[] pixelArray = new int[width * height];
                originalAvatar.getPixels(pixelArray, 0, width, 0, 0, width, height);
                for (int pixel = 0; pixel < pixelArray.length; ++pixel) {
                    pixelArray[pixel] = pixelArray[pixel] == originalColor ? baseColor : pixelArray[pixel];
                }
                newAvatar = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)originalAvatar.getConfig());
                newAvatar.setPixels(pixelArray, 0, width, 0, 0, width, height);
            }
            return new BitmapDrawable(context.getResources(), newAvatar);
        }

        private Drawable getAvatar() {
            return this.avatar;
        }
    }
}

