/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.widget.LinearLayout;
import io.intercom.android.sdk.blocks.Attachment;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.LWR;
import io.intercom.android.sdk.models.User;
import io.intercom.blocks.models.Block;
import java.util.ArrayList;
import java.util.List;

public class Message
implements Parcelable {
    private String type;
    private long id;
    private long created_at;
    private User author;
    private List<Block> body;
    private List<Attachments> attachments;
    private LWR lightweight_reply;
    private String text;
    private boolean currentlyDisplayedSmallAnnouncement = true;
    private transient LinearLayout blockLayout;
    private String message_style;
    public static final Parcelable.Creator<Message> CREATOR = new Parcelable.Creator<Message>(){

        public Message createFromParcel(Parcel in) {
            return new Message(in);
        }

        public Message[] newArray(int size) {
            return new Message[size];
        }
    };

    private Message(Builder builder) {
        this.type = builder.type == null ? "" : builder.type;
        this.id = builder.id;
        this.created_at = builder.created_at;
        this.author = builder.author == null ? new User.Builder().build() : builder.author.build();
        this.body = new ArrayList<Block>();
        if (builder.body != null) {
            for (Block.Builder blockBuilder : builder.body) {
                this.body.add(blockBuilder.build());
            }
        }
        this.attachments = builder.attachments == null ? new ArrayList() : builder.attachments;
        this.lightweight_reply = builder.lightweight_reply == null ? new LWR.NullLWR() : builder.lightweight_reply.build();
        this.text = builder.text == null ? "" : builder.text;
        this.currentlyDisplayedSmallAnnouncement = true;
        this.message_style = builder.message_style == null ? "" : builder.message_style;
    }

    public boolean isCurrentlyDisplayedSmallAnnouncement() {
        return this.currentlyDisplayedSmallAnnouncement;
    }

    public void setCurrentlyDisplayedSmallAnnouncement(boolean currentlyDisplayedSmallAnnouncement) {
        this.currentlyDisplayedSmallAnnouncement = currentlyDisplayedSmallAnnouncement;
    }

    public Message() {
    }

    public LinearLayout getBlockLayout() {
        return this.blockLayout;
    }

    public void setBlockLayout(LinearLayout blockLayout) {
        this.blockLayout = blockLayout;
    }

    public LWR getLightweight_reply() {
        return this.lightweight_reply;
    }

    public void setLightweight_reply(LWR lightweight_reply) {
        this.lightweight_reply = lightweight_reply;
    }

    public String getMessage_style() {
        if (this.message_style == null) {
            this.message_style = "";
        }
        return this.message_style;
    }

    public void setMessage_style(String message_style) {
        this.message_style = message_style;
    }

    public List<Block> getBody() {
        return this.body;
    }

    public void setBody(List<Block> body) {
        this.body = body;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id2) {
        this.id = id2;
    }

    public long getCreated_at() {
        return this.created_at;
    }

    public void setCreated_at(long created_at) {
        this.created_at = created_at;
    }

    public User getAuthor() {
        return this.author;
    }

    public void setAuthor(User author) {
        this.author = author;
    }

    public List<Attachments> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachments> attachments) {
        this.attachments = attachments;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    protected Message(Parcel in) {
        this.type = in.readString();
        this.message_style = in.readString();
        this.id = in.readLong();
        this.created_at = in.readLong();
        this.author = (User)in.readValue(User.class.getClassLoader());
        if (in.readByte() == 1) {
            this.body = new ArrayList<Block>();
            in.readList(this.body, Block.class.getClassLoader());
        } else {
            this.body = null;
        }
        if (in.readByte() == 1) {
            this.attachments = new ArrayList<Attachments>();
            in.readList(this.attachments, Attachment.class.getClassLoader());
        } else {
            this.attachments = null;
        }
        this.lightweight_reply = (LWR)in.readValue(LWR.class.getClassLoader());
        if (this.lightweight_reply.getType().isEmpty()) {
            this.lightweight_reply = new LWR.NullLWR();
        }
        this.message_style = in.readString();
        this.currentlyDisplayedSmallAnnouncement = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.type);
        dest.writeString(this.message_style);
        dest.writeLong(this.id);
        dest.writeLong(this.created_at);
        dest.writeValue((Object)this.author);
        if (this.body == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.body);
        }
        if (this.attachments == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.attachments);
        }
        dest.writeValue((Object)this.lightweight_reply);
        dest.writeString(this.message_style);
        dest.writeByte((byte)(this.currentlyDisplayedSmallAnnouncement ? 1 : 0));
    }

    public static final class Builder {
        private String type;
        private long id;
        private long created_at;
        private User.Builder author;
        private List<Block.Builder> body;
        private List<Attachments> attachments;
        private LWR.Builder lightweight_reply;
        private String text;
        private boolean currentlyDisplayedSmallAnnouncement;
        private String message_style;

        public Message build() {
            return new Message(this);
        }
    }
}

