/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import com.google.gson.annotations.SerializedName;
import io.intercom.android.nexus.NexusConfig;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.blocks.models.Block;
import java.util.ArrayList;
import java.util.List;

public class Config {
    private final String baseColor;
    private final boolean isFirstRequest;
    private final boolean inboundMessages;
    private final boolean showPoweredBy;
    private final List<Block> welcomeMessage = new ArrayList<Block>();
    private int pollingInterval;
    private boolean realTime;
    private NexusConfig realTimeConfig;
    private String messageResponse;
    private boolean audioEnabled;

    public Config() {
        this(new Builder());
    }

    public Config(Builder builder) {
        if (builder.welcomeMessage != null) {
            for (Block.Builder blockBuilder : builder.welcomeMessage) {
                this.welcomeMessage.add(blockBuilder.build());
            }
        }
        this.isFirstRequest = builder.isFirstRequest;
        this.inboundMessages = builder.inboundMessages;
        this.showPoweredBy = builder.showPoweredBy;
        this.baseColor = builder.baseColor == null ? String.format("#%06X", 0xFFFFFF & Bridge.getContext().getResources().getColor(R.color.intercomsdk_main_blue)) : builder.baseColor;
        this.pollingInterval = builder.pollingInterval == 0 ? 60 : builder.pollingInterval;
        this.realTime = builder.realTime;
        this.realTimeConfig = builder.realTimeConfig == null ? new NexusConfig() : builder.realTimeConfig.build();
        this.messageResponse = builder.messageResponse == null ? "" : builder.messageResponse;
        this.audioEnabled = builder.audioEnabled;
    }

    public String getBaseColor() {
        return this.baseColor;
    }

    public boolean isFirstRequest() {
        return this.isFirstRequest;
    }

    public boolean isInboundMessages() {
        return this.inboundMessages;
    }

    public boolean isShowPoweredBy() {
        return this.showPoweredBy;
    }

    public List<Block> getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean isRealTime() {
        return this.realTime;
    }

    public NexusConfig getRealTimeConfig() {
        return this.realTimeConfig;
    }

    public String getMessageResponse() {
        return this.messageResponse;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public static final class Builder {
        @SerializedName(value="base_color")
        private String baseColor;
        @SerializedName(value="is_first_request")
        private boolean isFirstRequest;
        @SerializedName(value="inbound_messages")
        private boolean inboundMessages;
        @SerializedName(value="show_powered_by")
        private boolean showPoweredBy;
        @SerializedName(value="welcome_message")
        private List<Block.Builder> welcomeMessage;
        @SerializedName(value="polling_interval")
        private int pollingInterval;
        @SerializedName(value="real_time")
        private boolean realTime;
        @SerializedName(value="real_time_config")
        private NexusConfig.Builder realTimeConfig;
        @SerializedName(value="auto_response")
        private String messageResponse;
        @SerializedName(value="audio_enabled")
        private boolean audioEnabled;

        public Config build() {
            return new Config(this);
        }
    }
}

