/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public String getFormattedTime(long time, boolean shortened) {
        if (time <= 0L) {
            return "Never";
        }
        Date now = new Date();
        Date date = new Date(time * 1000L);
        long diffInMin = TimeUnit.MILLISECONDS.toMinutes(now.getTime() - date.getTime());
        long diffInHours = TimeUnit.MILLISECONDS.toHours(now.getTime() - date.getTime());
        long diffInDays = TimeUnit.MILLISECONDS.toDays(now.getTime() - date.getTime());
        long diffInWeeks = diffInDays / 7L;
        long diffInYears = diffInWeeks / 52L;
        String displayDate = diffInYears > 0L ? diffInYears + (shortened ? "y ago" : " years ago") : (diffInWeeks > 0L ? diffInWeeks + (shortened ? "w ago" : " weeks ago") : (diffInDays > 0L ? diffInDays + (shortened ? "d ago" : " days ago") : (diffInHours > 0L ? diffInHours + (shortened ? "h ago" : " hours ago") : (diffInMin >= 1L ? diffInMin + (shortened ? "m ago" : " mins ago") : (shortened ? "Just now" : " Just now")))));
        return displayDate;
    }
}

