/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.TargetApi;
import android.graphics.Color;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.ImageButton;
import io.intercom.android.nexus.NexusEvent;
import io.intercom.android.sdk.Bridge;

@TargetApi(value=14)
class ComposerTextWatcher
implements TextWatcher {
    private static final long IS_TYPING_DELAY = 1000L;
    private final ImageButton sendButton;
    private final String userId;
    private final Handler handler;
    private String conversationId;
    private boolean shouldSendIsTyping = true;

    public ComposerTextWatcher(ImageButton sendButton, String conversationId, String userId) {
        this.sendButton = sendButton;
        this.conversationId = conversationId;
        this.userId = userId;
        HandlerThread bgThread = new HandlerThread("composer-background-handler");
        bgThread.start();
        this.handler = new Handler(bgThread.getLooper());
    }

    protected void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    protected void cleanup() {
        this.handler.removeCallbacksAndMessages(null);
        this.handler.getLooper().quit();
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable editable) {
        if (this.shouldSendIsTyping) {
            this.shouldSendIsTyping = false;
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ComposerTextWatcher.this.shouldSendIsTyping = true;
                }
            }, 1000L);
            Bridge.getNexusClient().fire(NexusEvent.getUserIsTypingEvent((String)this.conversationId, (String)this.userId));
        }
        if (ComposerTextWatcher.containsText(editable.toString())) {
            this.sendButton.setColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
            this.sendButton.setAlpha(1.0f);
        } else {
            this.sendButton.clearColorFilter();
            this.sendButton.setAlpha(0.6f);
        }
    }

    protected static boolean containsText(String text) {
        return !text.trim().isEmpty();
    }
}

