/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.LinkUtil;
import io.intercom.android.sdk.views.ButtonSelector;
import io.intercom.blocks.blockInterfaces.ButtonBlock;

public class Button
implements ButtonBlock {
    private final Context context;
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Typeface font;

    public Button(Context context, StyleType style) {
        this.context = context;
        this.style = style;
        this.inflater = LayoutInflater.from((Context)context);
        this.font = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Roboto-Medium.ttf");
    }

    public View addButton(String text, final String buttonUrl, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        View.OnClickListener clickListener = new View.OnClickListener(){

            public void onClick(View view) {
                LinkUtil.openUrl(buttonUrl, Button.this.context);
            }
        };
        switch (this.style) {
            case announcement: {
                android.widget.Button button = (android.widget.Button)this.inflater.inflate(R.layout.intercomsdk_blocks_button, parent, false);
                button.setTypeface(this.font);
                button.setText((CharSequence)text);
                button.setOnClickListener(clickListener);
                BackgroundUtils.setBackground((View)button, (Drawable)new ButtonSelector(this.context, R.drawable.intercomsdk_button_shape));
                return button;
            }
        }
        TextView textview = StyleType.welcome == this.style ? (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_welcome_button, parent, false) : (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_paragraph, parent, false);
        textview.setText((CharSequence)text);
        textview.setTextColor(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
        textview.setOnClickListener(clickListener);
        textview.setPaintFlags(textview.getPaintFlags() | 8);
        return textview;
    }
}

