/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.adapters;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.APIModels.Part;
import io.intercom.android.sdk.models.APIModels.Participant;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.ScreenUtils;
import io.intercom.android.sdk.utilities.TimeUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.xmlpull.v1.XmlPullParser;

public class ConversationAdapter
extends ArrayAdapter<Part> {
    private static final int USER_MESSAGE = 0;
    private static final int ADMIN_MESSAGE = 1;
    private static final int LOADING_TYPE = 2;
    private static final int ANNOUNCEMENT_TYPE = 3;
    private static final int SENDING = 4;
    private static final int SENDING_FAILURE = 5;
    private static final int POWERED_BY = 6;
    private static final int WELCOME = 7;
    private static final int ALT_USER_MESSAGE = 8;
    private static final int USER_MESSAGE_CONCAT = 9;
    private static final int ADMIN_MESSAGE_CONCAT = 10;
    private static final int MAX_TYPE = 11;

    public ConversationAdapter(Context context, int layoutResourceId, List<Part> conversationParts) {
        super(context, layoutResourceId, conversationParts);
    }

    @TargetApi(value=11)
    public View getBlockView(int position, View row, ViewGroup parent) {
        int type = this.getItemViewType(position);
        Part conversationPart = (Part)this.getItem(position);
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        if (type == 2) {
            return inflater.inflate((XmlPullParser)this.getContext().getResources().getLayout(R.layout.intercomsdk_row_loading_fullscreen), parent, false);
        }
        if (type == 6) {
            return inflater.inflate((XmlPullParser)this.getContext().getResources().getLayout(R.layout.intercomsdk_row_poweredby), parent, false);
        }
        if (type == 7) {
            row = inflater.inflate((XmlPullParser)this.getContext().getResources().getLayout(R.layout.intercomsdk_row_welcome), parent, false);
            this.setUpWelcomeRow(row, conversationPart);
        } else {
            ConversationHolder holder = new ConversationHolder();
            if (row == null || !(row.getTag() instanceof ConversationHolder)) {
                row = this.setUpRow(inflater, parent, type);
                holder.time = (TextView)row.findViewById(R.id.rowTime);
                holder.networkAvatar = (ImageView)row.findViewById(R.id.avatarView);
                holder.cellLayout = (LinearLayout)row.findViewById(R.id.cellLayout);
                holder.blocks = conversationPart.getLayout();
                if (holder.blocks.getParent() != null) {
                    ((LinearLayout)holder.blocks.getParent()).removeView((View)holder.blocks);
                }
                holder.cellLayout.addView((View)holder.blocks, 0);
                row.setFocusable(false);
                row.setTag((Object)holder);
            } else {
                holder = (ConversationHolder)row.getTag();
            }
            this.setUpHolderBlocks(holder, type, row, conversationPart);
            int pLeft = holder.blocks.getPaddingLeft();
            int pRight = holder.blocks.getPaddingRight();
            int pTop = holder.blocks.getPaddingTop();
            int pBottom = holder.blocks.getPaddingBottom();
            if (type == 9) {
                BackgroundUtils.setBackground((View)holder.blocks, this.getContext().getResources().getDrawable(R.drawable.intercomsdk_chat_bubble_right_aligned_notail));
                this.setCellRowColor(holder);
            } else if (type == 10) {
                BackgroundUtils.setBackground((View)holder.blocks, this.getContext().getResources().getDrawable(R.drawable.intercomsdk_chat_bubble_left_aligned_notail));
                holder.networkAvatar.setVisibility(4);
            } else {
                Participant user = conversationPart.getParticipant();
                if (conversationPart.getParticipant().getType().equals("admin") || type == 8) {
                    holder.networkAvatar.setTag((Object)position);
                    holder.networkAvatar.setVisibility(0);
                    AvatarUtils.createAvatar(user.getAvatar(), holder.networkAvatar, this.getContext());
                } else {
                    this.setCellRowColor(holder);
                }
            }
            holder.blocks.setPadding(pLeft, pTop, pRight, pBottom);
        }
        return row;
    }

    public View getView(int position, View row, ViewGroup parent) {
        return this.getBlockView(position, row, parent);
    }

    public int getViewTypeCount() {
        return 11;
    }

    public int getItemViewType(int position) {
        Part conversationPart = (Part)this.getItem(position);
        boolean shouldConcatenate = this.shouldConcatenate(conversationPart, position);
        int type = 0;
        if ("LoadingCell".equals(conversationPart.getMessageStyle())) {
            return 2;
        }
        if ("intercom_failed_message_style".equals(conversationPart.getMessageStyle())) {
            return 5;
        }
        if ("intercom_sending_message_style".equals(conversationPart.getMessageStyle())) {
            return 4;
        }
        if ("intercom_powered_by".equals(conversationPart.getMessageStyle())) {
            return 6;
        }
        if ("intercom_welcome_message".equals(conversationPart.getMessageStyle())) {
            return 7;
        }
        Participant user = conversationPart.getParticipant();
        if ("admin".equals(user.getType())) {
            type = "announcement".equals(conversationPart.getMessageStyle()) || "small-announcement".equals(conversationPart.getMessageStyle()) ? 3 : (shouldConcatenate ? 1 : 1);
        }
        return type;
    }

    public boolean isEnabled(int position) {
        int type = this.getItemViewType(position);
        return type == 5 || type == 6;
    }

    private boolean shouldConcatenate(Part conversationPart, int position) {
        Part prevPart;
        long diff;
        boolean concatenate = false;
        if (position + 1 < this.getCount() && (diff = Math.abs((prevPart = (Part)this.getItem(position + 1)).getCreatedAt() - conversationPart.getCreatedAt())) < TimeUnit.MINUTES.toSeconds(1L) && prevPart.getParticipant().getType().equals(conversationPart.getParticipant().getType()) && prevPart.getCreatedAt() != 0L) {
            concatenate = true;
        }
        return concatenate;
    }

    private View setUpRow(LayoutInflater inflater, ViewGroup parent, int type) {
        View row = type == 1 || type == 8 ? inflater.inflate((XmlPullParser)this.getContext().getResources().getLayout(R.layout.intercomsdk_row_admin_part), parent, false) : (type == 3 ? inflater.inflate((XmlPullParser)this.getContext().getResources().getLayout(R.layout.intercomsdk_row_big_announcement), parent, false) : (type == 9 ? inflater.inflate(R.layout.intercomsdk_row_user_part_concat, parent, false) : (type == 10 ? inflater.inflate(R.layout.intercomsdk_row_admin_part_concat, parent, false) : inflater.inflate(R.layout.intercomsdk_row_user_part, parent, false))));
        return row;
    }

    private boolean shouldDisplayTime(int type) {
        return type != 7 && type != 3 && type != 9 && type != 10;
    }

    private void setUpHolderBlocks(ConversationHolder holder, int type, View row, Part conversationPart) {
        holder.cellLayout.setVisibility(0);
        holder.blocks = conversationPart.getLayout();
        if (holder.blocks.getParent() != null) {
            ((LinearLayout)holder.blocks.getParent()).removeView((View)holder.blocks);
        }
        if (holder.cellLayout.getChildCount() > 0) {
            holder.cellLayout.removeAllViews();
        }
        holder.cellLayout.addView((View)holder.blocks, 0);
        if (holder.time != null) {
            if (this.shouldDisplayTime(type)) {
                holder.time.setVisibility(0);
                holder.time.setPadding(0, 0, 0, (int)ScreenUtils.convertDpToPixel(10.0f, this.getContext()));
                if (type == 4 || type == 5) {
                    ((ViewGroup)row).setDescendantFocusability(393216);
                    holder.time.setText((CharSequence)conversationPart.getFooter());
                    holder.blocks.setAlpha(0.5f);
                } else {
                    ((ViewGroup)row).setDescendantFocusability(262144);
                    this.displayDelivered(holder, conversationPart);
                    holder.blocks.setAlpha(1.0f);
                }
            } else {
                holder.time.setVisibility(8);
            }
        }
    }

    private void displayDelivered(ConversationHolder holder, Part conversationPart) {
        if (conversationPart.isDisplayDelivered()) {
            holder.time.setText((CharSequence)this.getContext().getString(R.string.intercomsdk_delivered));
            holder.time.setTypeface(null, 1);
        } else {
            holder.time.setTypeface(null, 0);
            holder.time.setText((CharSequence)new TimeUtils().getFormattedTime(conversationPart.getCreatedAt(), true));
        }
    }

    private void setUpWelcomeRow(View row, Part conversationPart) {
        LinearLayout cellLayout = (LinearLayout)row.findViewById(R.id.cellLayout);
        LinearLayout blocks = conversationPart.getLayout();
        if (blocks.getParent() != null) {
            ((LinearLayout)blocks.getParent()).removeView((View)blocks);
        }
        cellLayout.addView((View)blocks, 0);
        row.setFocusable(false);
    }

    private void setCellRowColor(ConversationHolder holder) {
        Drawable bg = holder.blocks.getBackground();
        PorterDuffColorFilter filter = new PorterDuffColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()), PorterDuff.Mode.MULTIPLY);
        bg.setColorFilter((ColorFilter)filter);
        BackgroundUtils.setBackground((View)holder.blocks, bg);
    }

    static class ConversationHolder {
        TextView time;
        ImageView networkAvatar;
        LinearLayout cellLayout;
        LinearLayout blocks;

        ConversationHolder() {
        }
    }
}

