/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import com.google.gson.annotations.SerializedName;
import io.intercom.android.sdk.models.APIModels.Conversation;
import java.util.ArrayList;
import java.util.List;

public class ConversationPage {
    private boolean morePagesAvailable;
    private int totalUnreadCount;
    private List<Conversation> conversations;

    public ConversationPage() {
        this(new Builder());
    }

    public ConversationPage(Builder builder) {
        this.morePagesAvailable = builder.morePagesAvailable;
        this.totalUnreadCount = builder.totalUnreadCount;
        this.conversations = new ArrayList<Conversation>();
        if (builder.conversations != null) {
            for (Conversation.Builder conversationBuilder : builder.conversations) {
                this.conversations.add(conversationBuilder.build());
            }
        }
    }

    public List<Conversation> getConversations() {
        return this.conversations;
    }

    public boolean isMorePagesAvailable() {
        return this.morePagesAvailable;
    }

    public int getTotalUnreadCount() {
        return this.totalUnreadCount;
    }

    public static final class Builder {
        @SerializedName(value="more_pages_available")
        private boolean morePagesAvailable;
        @SerializedName(value="total_unread_count")
        private int totalUnreadCount;
        private List<Conversation.Builder> conversations;

        public ConversationPage build() {
            return new ConversationPage(this);
        }
    }
}

