/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.PushNotification;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.NameUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public class GcmNotificationBuilder {
    private static final String CONVERSATION_URI = "intercom_sdk/conversation_id=%s";

    protected void createSingleNotification(PushNotification notification, NotificationManager notificationManager, int NOTIFICATION_ID, Context context) {
        Uri destination = Uri.parse((String)String.format(CONVERSATION_URI, notification.getConversationId()));
        NotificationCompat.Builder builder = this.getBaseNotificationBuilder(notification.getTitle(), notification.getMessage(), destination, context);
        builder.setLargeIcon(this.getAppIcon(notification, context));
        builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)notification.getMessage()));
        notificationManager.notify(NOTIFICATION_ID, builder.build());
    }

    protected void createGroupedNotification(List<PushNotification> notifications, NotificationManager notificationManager, int NOTIFICATION_ID, Context context) {
        Uri destination = Uri.parse((String)String.format("intercom_sdk/multiple_notifications", new Object[0]));
        NotificationCompat.Builder builder = this.getBaseNotificationBuilder(context.getString(R.string.intercomsdk_groupTitle), String.format(context.getString(R.string.intercomsdk_groupMessage), notifications.size()), destination, context);
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.setBigContentTitle((CharSequence)context.getString(R.string.intercomsdk_groupExpandedTitle));
        for (PushNotification notification : notifications) {
            SpannableString sb = new SpannableString((CharSequence)(notification.getName() + ": " + notification.getMessage()));
            sb.setSpan((Object)new StyleSpan(1), 0, notification.getName().length(), 33);
            inboxStyle.addLine((CharSequence)sb);
        }
        builder.setStyle((NotificationCompat.Style)inboxStyle);
        notificationManager.notify(NOTIFICATION_ID, builder.build());
    }

    private NotificationCompat.Builder getBaseNotificationBuilder(String title, String content, Uri destination, Context context) {
        Intent newIntent;
        PackageManager pm = context.getPackageManager();
        try {
            newIntent = pm.getLaunchIntentForPackage(context.getPackageName());
            if (newIntent == null) {
                throw new PackageManager.NameNotFoundException();
            }
            newIntent.addCategory("android.intent.category.LAUNCHER");
            newIntent.setData(destination);
        }
        catch (PackageManager.NameNotFoundException e) {
            newIntent = new Intent();
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)newIntent, (int)0);
        return new NotificationCompat.Builder(context).setSmallIcon(this.getAppIconResId(context)).setContentTitle((CharSequence)title).setContentText((CharSequence)content).setAutoCancel(true).setDefaults(3).setContentIntent(pendingIntent);
    }

    private Bitmap getBitmapFromURL(String strURL, String initials, String color2, Context context) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap networkBitmap = BitmapFactory.decodeStream((InputStream)input);
            networkBitmap = AvatarUtils.getRoundedBitmap(networkBitmap);
            return networkBitmap;
        }
        catch (IOException e) {
            return AvatarUtils.getTextBitmap(initials, color2, context.getApplicationContext());
        }
    }

    private Bitmap generateAvatar(String imageUrl, String userName, String color2, int defaultAvatar, Context context) {
        Bitmap bm = null;
        if (!imageUrl.isEmpty()) {
            bm = this.getBitmapFromURL(imageUrl, NameUtils.getInitials(userName), color2, context);
        } else if (!userName.isEmpty()) {
            bm = AvatarUtils.getTextBitmap(NameUtils.getInitials(userName), color2, context.getApplicationContext());
        }
        if (bm == null) {
            bm = BitmapFactory.decodeResource((Resources)context.getResources(), (int)defaultAvatar);
        }
        return bm;
    }

    private Bitmap getAppIcon(PushNotification notification, Context context) {
        return this.generateAvatar(notification.getImageUrl(), notification.getName(), notification.getColor(), this.getAppIconResId(context), context);
    }

    private int getAppIconResId(Context context) {
        int appResId = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0).getInt("INTERCOM_SDK_PUSH_LOGO", -1);
        if (appResId == -1) {
            appResId = R.drawable.intercomsdk_default_push;
        }
        return appResId;
    }
}

