/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.text.TextUtils;
import io.intercom.android.sdk.logger.Logger;
import java.util.HashMap;
import java.util.Map;

public class Registration {
    private String email = "";
    private String userId = "";
    private String registrationId = "";
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean isValidRegistration = true;

    public Registration withEmail(String email) {
        if (TextUtils.isEmpty((CharSequence)email)) {
            Logger.ERROR("Email cannot be null or empty");
            this.isValidRegistration = false;
        } else {
            this.email = email;
        }
        return this;
    }

    public Registration withUserId(String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            Logger.ERROR("UserId cannot be null or empty");
            this.isValidRegistration = false;
        } else {
            this.userId = userId;
        }
        return this;
    }

    public Registration withGCMRegistrationId(String registrationId) {
        if (TextUtils.isEmpty((CharSequence)registrationId)) {
            Logger.ERROR("GCM registration id should not be null or empty");
        } else {
            this.registrationId = registrationId;
        }
        return this;
    }

    public Registration withUserAttributes(Map<String, Object> attributes) {
        if (attributes == null) {
            Logger.ERROR("User Attributes cannot be null or empty");
            this.isValidRegistration = false;
        } else {
            this.attributes = attributes;
        }
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected boolean isValidRegistration() {
        return this.isValidRegistration;
    }
}

