/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Transformation;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.transforms.VideoTransform;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.blocks.VideoProvider;
import io.intercom.blocks.blockInterfaces.VideoBlock;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Video
implements VideoBlock {
    private final LayoutInflater inflater;
    private final Context context;

    public Video(Context context, StyleType style) {
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addVideo(String videoUrl, VideoProvider provider, final String id2, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        final ImageView imageView = (ImageView)this.inflater.inflate(R.layout.intercomsdk_blocks_video, parent, false);
        switch (provider) {
            case wistia: {
                Bridge.getApi().getVideo("http://fast.wistia.com/oembed?url=http://home.wistia.com/medias/" + id2, new Callback(){

                    public void onFailure(Request request, IOException e) {
                        Video.this.setFailedImage(imageView);
                    }

                    public void onResponse(Response response) throws IOException {
                        final String wistiaVideoUrl = "http://fast.wistia.net/embed/iframe/" + id2;
                        JSONObject video = new JSONObject();
                        try {
                            video = new JSONObject(response.body().string());
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        String wistiaThumbnailUrl = video.optString("thumbnail_url");
                        int end = wistiaThumbnailUrl.indexOf("?image_crop_resized");
                        if (end > 0) {
                            wistiaThumbnailUrl = wistiaThumbnailUrl.substring(0, end);
                        }
                        Handler mainHandler = new Handler(Video.this.context.getMainLooper());
                        final String finalWistiaThumbnailUrl = wistiaThumbnailUrl;
                        Runnable myRunnable = new Runnable(){

                            @Override
                            public void run() {
                                Video.this.createThumbnail(imageView, wistiaVideoUrl, finalWistiaThumbnailUrl);
                            }
                        };
                        mainHandler.post(myRunnable);
                    }
                });
                break;
            }
            case youtube: {
                this.createThumbnail(imageView, "http://www.youtube.com/watch?v=" + id2, "http://img.youtube.com/vi/" + id2 + "/default.jpg");
                break;
            }
            case vimeo: {
                String vimeoVideoUrl = "http://vimeo.com/api/v2/video/" + id2 + ".json";
                Bridge.getApi().getVideo(vimeoVideoUrl, new Callback(){

                    public void onFailure(Request request, IOException e) {
                        Video.this.setFailedImage(imageView);
                    }

                    public void onResponse(Response response) throws IOException {
                        if (response.isSuccessful()) {
                            JSONObject video = new JSONObject();
                            try {
                                JSONArray jArray = new JSONArray(response.body().string());
                                video = jArray.optJSONObject(0);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            final String vimeoThumbnailUrl = video.optString("thumbnail_large");
                            Handler mainHandler = new Handler(Video.this.context.getMainLooper());
                            Runnable myRunnable = new Runnable(){

                                @Override
                                public void run() {
                                    Video.this.createThumbnail(imageView, "http://player.vimeo.com/video/" + id2, vimeoThumbnailUrl);
                                }
                            };
                            mainHandler.post(myRunnable);
                        }
                    }
                });
                break;
            }
        }
        if (isLastObject) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(imageView.getLayoutParams());
            params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, 0);
            params.gravity = 17;
            imageView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        return imageView;
    }

    private void createThumbnail(ImageView imageView, final String videoUrl, String thumbnailUrl) {
        Picasso.with((Context)this.context).load(thumbnailUrl).placeholder(R.drawable.intercomsdk_video_thumbnail_fallback).error(R.drawable.intercomsdk_video_thumbnail_fallback).transform((Transformation)new VideoTransform()).fit().into(imageView);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Uri uri = Uri.parse((String)videoUrl);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.setFlags(0x10000000);
                Video.this.context.startActivity(intent);
            }
        });
    }

    private void setFailedImage(ImageView imageView) {
        BackgroundUtils.setBackground((View)imageView, this.context.getResources().getDrawable(R.drawable.intercomsdk_video_thumbnail_fallback));
    }
}

