/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Lifecycles;
import io.intercom.android.sdk.activities.MainActivity;
import io.intercom.android.sdk.chathead.NotificationsService;
import io.intercom.android.sdk.enums.IntercomPreviewPosition;
import io.intercom.android.sdk.gcm.GcmIntentService;
import io.intercom.android.sdk.identity.Migrations;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.APIModels.Conversation;
import io.intercom.android.sdk.models.Events.CloseIAMEvent;
import io.intercom.android.sdk.utilities.DeviceUtils;
import io.intercom.android.sdk.utilities.Prefs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Intercom {
    public static final String GCM_RECEIVER = "intercom_sdk";
    private static Intercom instance;
    private boolean applicationSetup = false;

    private Intercom(Application application, String apiKey, String appId) {
        if (application != null) {
            if (TextUtils.isEmpty((CharSequence)apiKey)) {
                Logger.ERROR("The apiKey you provided is either null or empty. We require a correct apiKey to enable the Intercom SDK");
                apiKey = "";
            }
            if (TextUtils.isEmpty((CharSequence)appId)) {
                Logger.ERROR("The appId you provided is either null or empty. We require a correct appId to enable the Intercom SDK");
                appId = "";
            }
            Bridge.init((Context)application);
            Migrations.runAll((Context)application);
            Bridge.getIdentityStore().setAppIdentity(apiKey, appId);
            if (DeviceUtils.isMessagingSDKSupported(Build.VERSION.SDK_INT)) {
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new Lifecycles());
            }
            this.applicationSetup = true;
        } else {
            Logger.ERROR("Intercom setup requires an Application, it appears the Application we received was null");
        }
    }

    public static synchronized void initialize(Application application, String apiKey, String appId) {
        if (instance == null) {
            instance = new Intercom(application, apiKey, appId);
        } else {
            Logger.INFO("Intercom has already been initialized");
        }
    }

    public static synchronized Intercom client() {
        if (instance == null) {
            throw new IllegalStateException("Please call Intercom.initialize() before requesting the client.");
        }
        return instance;
    }

    public void registerUnidentifiedUser() {
        if (this.applicationSetup) {
            if (Bridge.getIdentityStore().registerUnidentifiedUser()) {
                Bridge.getApi().registerUnidentifiedUser();
                this.updateNotificationsService();
            } else {
                Logger.INFO("Failed to register user. We already have a registered user. If you are attempting to register a new user, call reset before this. If you are attempting to register an identified user call: registerIdentifiedUser(Registration)");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    public void registerIdentifiedUser(Registration userRegistration) {
        if (this.applicationSetup) {
            if (userRegistration != null) {
                if (Bridge.getIdentityStore().registerIdentifiedUser(userRegistration)) {
                    Bridge.getApi().registerIdentifiedUser(userRegistration);
                    this.updateNotificationsService();
                } else {
                    Logger.INFO("Failed to register user. We already have a registered user. If you are attempting to register a new user, call reset before this. If you are attempting to change the user call update instead.");
                }
            } else {
                Logger.ERROR("The registration object you passed to is null. An example successful call is registerIdentifiedUser(new Registration().withEmail(email));");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    public void setSecureMode(String secureHash, String secureData) {
        if (this.applicationSetup) {
            if (TextUtils.isEmpty((CharSequence)secureHash)) {
                Logger.WARNING("The hmac you sent us for secure mode was either null or empty, we will not be able to authenticate your requests without a valid hmac.");
            } else if (TextUtils.isEmpty((CharSequence)secureData)) {
                Logger.WARNING("The data you sent us for secure mode was either null or empty, we will not be able to authenticate your requests without valid data.");
            } else {
                Bridge.getIdentityStore().setSecureMode(secureHash, secureData);
            }
        }
    }

    public void updateUser(Map<String, Object> attributes) {
        if (this.applicationSetup) {
            if (attributes != null && !attributes.isEmpty()) {
                Bridge.getApi().updateUser(attributes);
            } else {
                Logger.ERROR("The attributes Map provided is null or empty. We can't update your user with this Map.");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    public void logEvent(String name) {
        if (this.applicationSetup) {
            if (!TextUtils.isEmpty((CharSequence)name)) {
                Bridge.getApi().logEvent(name, new HashMap<String, Object>());
            } else {
                Logger.ERROR("The event name is null or empty. We can't log an event with this string.");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    public void logEvent(String name, Map<String, Object> metaData) {
        if (this.applicationSetup) {
            if (TextUtils.isEmpty((CharSequence)name)) {
                Logger.ERROR("The event name is null or empty. We can't log an event with this string.");
            } else if (metaData == null || metaData.isEmpty()) {
                Logger.ERROR("The metaData Map is null or empty. We can't log an event with this Map.");
            } else {
                Bridge.getApi().logEvent(name, metaData);
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    public void displayMessageComposer() {
        if (this.applicationSetup) {
            if (Bridge.getIdentityStore().getAppConfig().isInboundMessages()) {
                this.openIAM(false, "");
            } else {
                Logger.ERROR("It appears your app is not on a plan that allows message composing As a fallback we are calling displayConversationsList()");
                this.displayConversationsList();
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    public void displayConversationsList() {
        if (this.applicationSetup) {
            this.openIAM(true, "");
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    private void openIAM(boolean asConversationsList, String conversationId) {
        if (this.applicationSetup) {
            if (DeviceUtils.isMessagingSDKSupported(Build.VERSION.SDK_INT)) {
                Context context = Bridge.getContext();
                Intent intent = new Intent(context, MainActivity.class);
                if (asConversationsList) {
                    intent.putExtra("showInbox", true);
                } else {
                    Conversation conversation = new Conversation();
                    conversation.setId(conversationId);
                    intent.putExtra("CreateConversation", (Parcelable)conversation);
                }
                intent.addFlags(0x10000000);
                context.startActivity(intent);
            } else {
                Logger.WARNING("This device is on a version of Android below Icecream Sandwich (API level 15), We require API level 15 or above to display messages");
            }
        }
    }

    private void updateNotificationsService() {
        Context context = Bridge.getContext();
        Intent intent = new Intent(context, NotificationsService.class);
        context.startService(intent);
    }

    public void setPreviewPosition(IntercomPreviewPosition previewPosition) {
        if (this.applicationSetup) {
            if (DeviceUtils.isMessagingSDKSupported(Build.VERSION.SDK_INT)) {
                if (previewPosition == null) {
                    Logger.WARNING("The previewPosition provided is null. An example successful call is: setPreviewPosition(IntercomPreviewPosition.BOTTOM_LEFT);");
                    previewPosition = IntercomPreviewPosition.BOTTOM_LEFT;
                }
                Prefs.setPresentationMode(previewPosition, Bridge.getContext());
            } else {
                Logger.WARNING("This device is on a version of Android below Icecream Sandwich (API level 15), We require API level 15 or above to display messages");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    public void setMessagesHidden(boolean visibility) {
        if (this.applicationSetup) {
            if (DeviceUtils.isMessagingSDKSupported(Build.VERSION.SDK_INT)) {
                Context context = Bridge.getContext();
                Intent intent = new Intent(context, NotificationsService.class);
                intent.putExtra("chatehadVisibility", !visibility);
                context.startService(intent);
            } else {
                Logger.ERROR("This device is on a version of Android below Icecream Sandwich (API level 15), We require API level 15 or above to display messages");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    public void setupGCM(String regId, int appLogo) {
        if (this.applicationSetup) {
            if (TextUtils.isEmpty((CharSequence)regId)) {
                Logger.ERROR("It looks like the GCM registrationId you passed in is null or empty, we require a valid GCM registrationId to enable push");
            } else if (DeviceUtils.isMessagingSDKSupported(Build.VERSION.SDK_INT)) {
                Bridge.getApi().setGCMPushKey(regId);
                SharedPreferences settings = Bridge.getContext().getSharedPreferences("INTERCOM_SDK_PREFS", 0);
                SharedPreferences.Editor editor = settings.edit();
                editor.putInt("INTERCOM_SDK_PUSH_LOGO", appLogo);
                editor.apply();
            } else {
                Logger.ERROR("This device is on a version of Android below Icecream Sandwich (API level 15), We require API level 15 or above to display messages");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }

    public boolean openGCMMessage(Uri data) {
        boolean wasSdkPush = false;
        if (this.applicationSetup) {
            if (DeviceUtils.isMessagingSDKSupported(Build.VERSION.SDK_INT)) {
                if (data != null) {
                    List pathParts = data.getPathSegments();
                    if (pathParts.size() > 1 && ((String)pathParts.get(0)).equals(GCM_RECEIVER)) {
                        wasSdkPush = true;
                        if (((String)pathParts.get(1)).equals("multiple_notifications")) {
                            this.openIAM(true, "");
                        } else {
                            this.openIAM(false, ((String)pathParts.get(1)).substring(((String)pathParts.get(1)).lastIndexOf(61) + 1));
                        }
                        Context context = Bridge.getContext();
                        Intent intent = new Intent(context, GcmIntentService.class);
                        intent.setAction("intercom_sdk_remove_notification");
                        context.startService(intent);
                    } else {
                        Logger.INFO("The Uri passed into the method openGCMMessage was not an Intercom GCM message");
                    }
                } else {
                    Logger.INFO("The Uri passed into the method openGCMMessage was null.");
                }
            } else {
                Logger.ERROR("This device is on a version of Android below Icecream Sandwich (API level 15), We require API level 15 or above to display messages");
            }
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
        return wasSdkPush;
    }

    public void reset() {
        if (this.applicationSetup) {
            Bridge.getIdentityStore().resetUserIdentity();
            Bridge.getBus().post((Object)new CloseIAMEvent());
            Context context = Bridge.getContext();
            Intent intent = new Intent(context, NotificationsService.class);
            context.stopService(intent);
            Logger.INFO("Successfully reset user. To resume communicating with Intercom, you can register a user");
        } else {
            Logger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize");
        }
    }
}

