/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.Inbox;

import com.squareup.otto.Subscribe;
import intercom.intercomsdk.models.Events.ConversationsListDataChanged;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.models.APIModels.Conversation;
import io.intercom.android.sdk.models.ConversationList;
import io.intercom.android.sdk.models.Events.NewConversationEvent;
import io.intercom.android.sdk.models.Events.ReadEvent;
import java.util.ArrayList;
import java.util.List;

public class ConversationsHolder {
    private List<Conversation> conversations = new ArrayList<Conversation>();

    protected void syncInbox(ConversationList response) {
        ArrayList<Conversation> newConversations = new ArrayList<Conversation>();
        ArrayList<Conversation> removeConversations = new ArrayList<Conversation>();
        List<Conversation> tempConversations = response.getConversations();
        for (int i = 0; i < tempConversations.size(); ++i) {
            Conversation tempConversation = tempConversations.get(i);
            boolean found = false;
            for (int j = 0; j < this.conversations.size(); ++j) {
                Conversation currentConversation = this.conversations.get(j);
                if (currentConversation instanceof Conversation.Loading || !tempConversation.getId().equals(currentConversation.getId())) continue;
                if (tempConversation.getLastPart().getCreatedAt() > currentConversation.getLastPart().getCreatedAt()) {
                    removeConversations.add(currentConversation);
                    newConversations.add(tempConversation);
                }
                found = true;
            }
            if (found) continue;
            newConversations.add(tempConversation);
        }
        this.conversations.removeAll(removeConversations);
        if (!newConversations.isEmpty() && !this.conversations.isEmpty()) {
            Conversation newConversation = (Conversation)newConversations.get(0);
            Conversation oldConversation = this.conversations.get(this.conversations.size() - 1);
            int pos = 0;
            if (newConversation.getLastPart().getCreatedAt() <= oldConversation.getLastPart().getCreatedAt()) {
                pos = this.conversations.size();
            }
            this.addAll(pos, newConversations);
        } else {
            this.addAll(0, newConversations);
        }
    }

    @Subscribe
    public void markedAsRead(ReadEvent event) {
        for (Conversation conversation : this.conversations) {
            if (!conversation.getId().equals(event.getConversationId())) continue;
            conversation.setRead(true);
            this.notifyDataSetChanged();
            break;
        }
    }

    @Subscribe
    public void newConversationEvent(NewConversationEvent event) {
        Conversation newConversation = event.getResponse();
        if (!this.conversations.contains(newConversation)) {
            this.add(0, newConversation);
        }
    }

    private void notifyDataSetChanged() {
        Bridge.getBus().post((Object)new ConversationsListDataChanged());
    }

    protected boolean isEmpty() {
        return this.conversations.isEmpty();
    }

    protected int size() {
        return this.conversations.size();
    }

    protected Conversation get(int position) {
        return this.conversations.get(position);
    }

    protected Conversation remove(int position) {
        Conversation removedConversation = this.conversations.remove(position);
        this.notifyDataSetChanged();
        return removedConversation;
    }

    protected void add(Conversation conversation) {
        this.conversations.add(conversation);
        this.notifyDataSetChanged();
    }

    protected void add(int position, Conversation conversation) {
        this.conversations.add(position, conversation);
        this.notifyDataSetChanged();
    }

    protected void addAll(int position, List<Conversation> newConversations) {
        this.conversations.addAll(position, newConversations);
        this.notifyDataSetChanged();
    }

    protected boolean contains(Conversation conversation) {
        return this.conversations.contains(conversation);
    }

    protected List<Conversation> getConversations() {
        return this.conversations;
    }
}

