/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.ui.preview.viewmodel;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.widget.Toast;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.exifinterface.media.ExifInterface;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import io.intercom.android.sdk.ui.preview.data.DeleteType;
import io.intercom.android.sdk.ui.preview.data.IntercomPreviewArgs;
import io.intercom.android.sdk.ui.preview.data.IntercomPreviewFile;
import io.intercom.android.sdk.ui.preview.model.PreviewUiState;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001d\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010 \u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0013H\u0002J\u0010\u0010&\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010'\u001a\u00020\u0016*\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006+"}, d2={"Lio/intercom/android/sdk/ui/preview/viewmodel/PreviewViewModel;", "Landroidx/lifecycle/ViewModel;", "previewArgs", "Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewArgs;", "(Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewArgs;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/ui/preview/model/PreviewUiState;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState$intercom_sdk_ui_release", "()Lkotlinx/coroutines/flow/StateFlow;", "onDeleteClicked", "", "file", "Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewFile;", "onDeleteClicked$intercom_sdk_ui_release", "onPageNavigated", "pageNo", "", "onPageNavigated$intercom_sdk_ui_release", "prepareBitmap", "Landroid/graphics/Bitmap;", "url", "", "saveImage", "context", "Landroid/content/Context;", "saveImage$intercom_sdk_ui_release", "saveImageLegacy", "bitmap", "saveImageOnApi29Above", "saveImageToStream", "outputStream", "Ljava/io/OutputStream;", "showDeleteAction", "", "size", "showImageSaveSuccess", "rotate", "degrees", "", "Companion", "intercom-sdk-ui_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPreviewViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewViewModel.kt\nio/intercom/android/sdk/ui/preview/viewmodel/PreviewViewModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n230#2,5:178\n230#2,5:184\n1#3:183\n*S KotlinDebug\n*F\n+ 1 PreviewViewModel.kt\nio/intercom/android/sdk/ui/preview/viewmodel/PreviewViewModel\n*L\n55#1:178,5\n146#1:184,5\n*E\n"})
public final class PreviewViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntercomPreviewArgs previewArgs;
    @NotNull
    private final MutableStateFlow<PreviewUiState> _state;
    @NotNull
    private final StateFlow<PreviewUiState> state;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PreviewViewModel(@NotNull IntercomPreviewArgs previewArgs) {
        void $this$_init__u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)previewArgs, (String)"previewArgs");
        this.previewArgs = previewArgs;
        this._state = StateFlowKt.MutableStateFlow((Object)new PreviewUiState(null, 0, false, false, null, false, null, 127, null));
        this.state = (StateFlow)this._state;
        IntercomPreviewArgs intercomPreviewArgs = this.previewArgs;
        MutableStateFlow<PreviewUiState> mutableStateFlow = this._state;
        boolean bl = false;
        mutableStateFlow.setValue((Object)new PreviewUiState($this$_init__u24lambda_u240.getUris(), 0, this.showDeleteAction($this$_init__u24lambda_u240.getUris().size()), this.previewArgs.getShowSendCTA(), $this$_init__u24lambda_u240.getCtaText(), $this$_init__u24lambda_u240.getDownloadState().getShowDownloadAction(), $this$_init__u24lambda_u240.getDownloadState().getFileSavedText(), 2, null));
    }

    @NotNull
    public final StateFlow<PreviewUiState> getState$intercom_sdk_ui_release() {
        return this.state;
    }

    public final void onDeleteClicked$intercom_sdk_ui_release(@NotNull IntercomPreviewFile file) {
        List newUris;
        PreviewUiState uiState;
        PreviewUiState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MutableStateFlow<PreviewUiState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            uiState = (PreviewUiState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = PreviewUiState.copy$default(uiState, newUris = CollectionsKt.minus((Iterable)uiState.getFiles(), (Object)file), 0, this.showDeleteAction(newUris.size()), false, null, false, null, 122, null))));
    }

    public final void saveImage$intercom_sdk_ui_release(@NotNull IntercomPreviewFile file, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (file instanceof IntercomPreviewFile.NetworkFile) {
            Toast.makeText((Context)context, (CharSequence)"Saving...", (int)0).show();
            BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, context, null){
                int label;
                final /* synthetic */ PreviewViewModel this$0;
                final /* synthetic */ IntercomPreviewFile $file;
                final /* synthetic */ Context $context;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$context = $context;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Bitmap bitmap = PreviewViewModel.access$prepareBitmap(this.this$0, ((IntercomPreviewFile.NetworkFile)this.$file).getUrl());
                            if (Build.VERSION.SDK_INT >= 29) {
                                PreviewViewModel.access$saveImageOnApi29Above(this.this$0, bitmap, this.$context);
                            } else {
                                PreviewViewModel.access$saveImageLegacy(this.this$0, bitmap, this.$context);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private final void saveImageLegacy(Bitmap bitmap, Context context) {
        File imagesDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String fileName = string;
        File image = new File(imagesDir, fileName + ".jpg");
        FileOutputStream stream = new FileOutputStream(image);
        this.saveImageToStream(bitmap, stream);
        this.showImageSaveSuccess(context);
    }

    private final void saveImageOnApi29Above(Bitmap bitmap, Context context) {
        block1: {
            OutputStream stream;
            Uri uri;
            ContentValues contentValues;
            ContentValues $this$saveImageOnApi29Above_u24lambda_u242 = contentValues = new ContentValues();
            boolean bl = false;
            $this$saveImageOnApi29Above_u24lambda_u242.put("_display_name", UUID.randomUUID().toString());
            $this$saveImageOnApi29Above_u24lambda_u242.put("mime_type", "image/jpeg");
            $this$saveImageOnApi29Above_u24lambda_u242.put("relative_path", "DCIM");
            $this$saveImageOnApi29Above_u24lambda_u242.put("is_pending", Integer.valueOf(1));
            ContentValues contentValues2 = contentValues;
            Uri uri2 = uri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues2);
            if (uri2 == null) break block1;
            Uri it = uri2;
            boolean bl2 = false;
            OutputStream outputStream = stream = context.getContentResolver().openOutputStream(uri);
            if (outputStream != null) {
                OutputStream it2 = outputStream;
                boolean bl3 = false;
                this.saveImageToStream(bitmap, stream);
                contentValues2.put("is_pending", Boolean.valueOf(false));
                context.getContentResolver().update(uri, contentValues2, null, null);
                this.showImageSaveSuccess(context);
            }
        }
    }

    private final Bitmap prepareBitmap(String url) {
        int rotation = 0;
        ExifInterface exifInterface = new ExifInterface(new URL(url).openConnection().getInputStream());
        int orientation = exifInterface.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                rotation = 90;
                break;
            }
            case 3: {
                rotation = 180;
                break;
            }
            case 8: {
                rotation = 270;
            }
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new URL(url).openConnection().getInputStream());
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return this.rotate(bitmap, rotation);
    }

    private final Bitmap rotate(Bitmap $this$rotate, float degrees) {
        Matrix matrix;
        Matrix $this$rotate_u24lambda_u245 = matrix = new Matrix();
        boolean bl = false;
        $this$rotate_u24lambda_u245.postRotate(degrees);
        Matrix matrix2 = matrix;
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)$this$rotate, (int)0, (int)0, (int)$this$rotate.getWidth(), (int)$this$rotate.getHeight(), (Matrix)matrix2, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(this, 0, 0,\u2026th, height, matrix, true)");
        return bitmap;
    }

    private final void saveImageToStream(Bitmap bitmap, OutputStream outputStream) {
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, outputStream);
        outputStream.close();
    }

    private final void showImageSaveSuccess(Context context) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, this, null){
            int label;
            final /* synthetic */ Context $context;
            final /* synthetic */ PreviewViewModel this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Toast.makeText((Context)this.$context, (CharSequence)((PreviewUiState)PreviewViewModel.access$get_state$p(this.this$0).getValue()).getFileSavedText(), (int)0).show();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void onPageNavigated$intercom_sdk_ui_release(int pageNo) {
        PreviewUiState it;
        PreviewUiState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<PreviewUiState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (PreviewUiState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = PreviewUiState.copy$default(it, null, pageNo, false, false, null, false, null, 125, null))));
    }

    private final boolean showDeleteAction(int size) {
        boolean bl;
        DeleteType deleteType = this.previewArgs.getDeleteType();
        if (Intrinsics.areEqual((Object)deleteType, (Object)DeleteType.None.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)deleteType, (Object)DeleteType.Delete.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)deleteType, (Object)DeleteType.Remove.INSTANCE)) {
            bl = size > 1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final /* synthetic */ Bitmap access$prepareBitmap(PreviewViewModel $this, String url) {
        return $this.prepareBitmap(url);
    }

    public static final /* synthetic */ void access$saveImageOnApi29Above(PreviewViewModel $this, Bitmap bitmap, Context context) {
        $this.saveImageOnApi29Above(bitmap, context);
    }

    public static final /* synthetic */ void access$saveImageLegacy(PreviewViewModel $this, Bitmap bitmap, Context context) {
        $this.saveImageLegacy(bitmap, context);
    }

    public static final /* synthetic */ MutableStateFlow access$get_state$p(PreviewViewModel $this) {
        return $this._state;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lio/intercom/android/sdk/ui/preview/viewmodel/PreviewViewModel$Companion;", "", "()V", "create", "Lio/intercom/android/sdk/ui/preview/viewmodel/PreviewViewModel;", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "previewArgs", "Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewArgs;", "create$intercom_sdk_ui_release", "factory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "factory$intercom_sdk_ui_release", "intercom-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PreviewViewModel create$intercom_sdk_ui_release(@NotNull ViewModelStoreOwner owner, @NotNull IntercomPreviewArgs previewArgs) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)previewArgs, (String)"previewArgs");
            return (PreviewViewModel)new ViewModelProvider(owner, this.factory$intercom_sdk_ui_release(previewArgs)).get(PreviewViewModel.class);
        }

        @NotNull
        public final ViewModelProvider.Factory factory$intercom_sdk_ui_release(@NotNull IntercomPreviewArgs previewArgs) {
            Intrinsics.checkNotNullParameter((Object)previewArgs, (String)"previewArgs");
            return new ViewModelProvider.Factory(previewArgs){
                final /* synthetic */ IntercomPreviewArgs $previewArgs;
                {
                    this.$previewArgs = $previewArgs;
                }

                @NotNull
                public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
                    Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
                    return (T)((Object)new PreviewViewModel(this.$previewArgs));
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

