/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.lightcompressor.video;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.view.Surface;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/intercom/android/sdk/lightcompressor/video/InputSurface;", "", "surface", "Landroid/view/Surface;", "(Landroid/view/Surface;)V", "eglOpenGlES2Bit", "", "eglRecordableAndroid", "mEGLContext", "Landroid/opengl/EGLContext;", "mEGLDisplay", "Landroid/opengl/EGLDisplay;", "mEGLSurface", "Landroid/opengl/EGLSurface;", "mSurface", "checkEglError", "", "eglSetup", "makeCurrent", "release", "setPresentationTime", "nsecs", "", "swapBuffers", "", "intercom-sdk-lightcompressor_release"})
public final class InputSurface {
    private final int eglRecordableAndroid;
    private final int eglOpenGlES2Bit;
    @Nullable
    private EGLDisplay mEGLDisplay;
    @Nullable
    private EGLContext mEGLContext;
    @Nullable
    private EGLSurface mEGLSurface;
    @Nullable
    private Surface mSurface;

    public InputSurface(@Nullable Surface surface) {
        this.eglRecordableAndroid = 12610;
        this.eglOpenGlES2Bit = 4;
        if (surface == null) {
            throw new NullPointerException();
        }
        this.mSurface = surface;
        this.eglSetup();
    }

    private final void eglSetup() {
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.mEGLDisplay = null;
            throw new RuntimeException("unable to initialize EGL14");
        }
        int[] nArray = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, this.eglOpenGlES2Bit, this.eglRecordableAndroid, 1, 12344};
        int[] attribList = nArray;
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])attribList, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0)) {
            throw new RuntimeException("unable to find RGB888+recordable ES2 EGL config");
        }
        int[] nArray2 = new int[]{12440, 2, 12344};
        int[] attrs = nArray2;
        this.mEGLContext = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)configs[0], (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])attrs, (int)0);
        this.checkEglError();
        if (this.mEGLContext == null) {
            throw new RuntimeException("null context");
        }
        int[] nArray3 = new int[]{12344};
        int[] surfaceAttrs = nArray3;
        this.mEGLSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)configs[0], (Object)this.mSurface, (int[])surfaceAttrs, (int)0);
        this.checkEglError();
        if (this.mEGLSurface == null) {
            throw new RuntimeException("surface was null");
        }
    }

    public final void release() {
        if (Intrinsics.areEqual((Object)EGL14.eglGetCurrentContext(), (Object)this.mEGLContext)) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
        }
        EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface);
        EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
        Surface surface = this.mSurface;
        if (surface != null) {
            surface.release();
        }
        this.mEGLDisplay = null;
        this.mEGLContext = null;
        this.mEGLSurface = null;
        this.mSurface = null;
    }

    public final void makeCurrent() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (EGLSurface)this.mEGLSurface, (EGLContext)this.mEGLContext)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    public final boolean swapBuffers() {
        return EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface);
    }

    public final void setPresentationTime(long nsecs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (long)nsecs);
    }

    private final void checkEglError() {
        boolean failed = false;
        while (EGL14.eglGetError() != 12288) {
            failed = true;
        }
        if (failed) {
            throw new RuntimeException("EGL error encountered (see log)");
        }
    }
}

