/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.lightcompressor.video;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import io.intercom.android.sdk.lightcompressor.video.TextureRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0016J\u0006\u0010\u0013\u001a\u00020\u000eJ\b\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/intercom/android/sdk/lightcompressor/video/OutputSurface;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "()V", "mFrameAvailable", "", "mFrameSyncObject", "Ljava/lang/Object;", "mSurface", "Landroid/view/Surface;", "mSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "mTextureRender", "Lio/intercom/android/sdk/lightcompressor/video/TextureRenderer;", "awaitNewImage", "", "drawImage", "getSurface", "onFrameAvailable", "p0", "release", "setup", "intercom-sdk-lightcompressor_release"})
public final class OutputSurface
implements SurfaceTexture.OnFrameAvailableListener {
    @Nullable
    private SurfaceTexture mSurfaceTexture;
    @Nullable
    private Surface mSurface;
    @NotNull
    private final Object mFrameSyncObject = new Object();
    private boolean mFrameAvailable;
    @Nullable
    private TextureRenderer mTextureRender;

    public OutputSurface() {
        this.setup();
    }

    private final void setup() {
        block1: {
            TextureRenderer textureRenderer = this.mTextureRender = new TextureRenderer();
            if (textureRenderer == null) break block1;
            TextureRenderer it = textureRenderer;
            boolean bl = false;
            it.surfaceCreated();
            SurfaceTexture surfaceTexture = this.mSurfaceTexture = new SurfaceTexture(it.getTextureId());
            if (surfaceTexture != null) {
                SurfaceTexture surfaceTexture2 = surfaceTexture;
                boolean bl2 = false;
                surfaceTexture2.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
                this.mSurface = new Surface(this.mSurfaceTexture);
            }
        }
    }

    public final void release() {
        Surface surface = this.mSurface;
        if (surface != null) {
            surface.release();
        }
        this.mTextureRender = null;
        this.mSurface = null;
        this.mSurfaceTexture = null;
    }

    @Nullable
    public final Surface getSurface() {
        return this.mSurface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitNewImage() {
        block7: {
            int timeOutMS = 100;
            Object object = this.mFrameSyncObject;
            synchronized (object) {
                boolean bl = false;
                while (!this.mFrameAvailable) {
                    try {
                        this.mFrameSyncObject.wait(timeOutMS);
                        if (this.mFrameAvailable) continue;
                        throw new RuntimeException("Surface frame wait timed out");
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                }
                this.mFrameAvailable = false;
                Unit unit = Unit.INSTANCE;
            }
            TextureRenderer textureRenderer = this.mTextureRender;
            if (textureRenderer != null) {
                textureRenderer.checkGlError("before updateTexImage");
            }
            SurfaceTexture surfaceTexture = this.mSurfaceTexture;
            if (surfaceTexture == null) break block7;
            surfaceTexture.updateTexImage();
        }
    }

    public final void drawImage() {
        block0: {
            TextureRenderer textureRenderer = this.mTextureRender;
            if (textureRenderer == null) break block0;
            SurfaceTexture surfaceTexture = this.mSurfaceTexture;
            Intrinsics.checkNotNull((Object)surfaceTexture);
            textureRenderer.drawFrame(surfaceTexture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(@Nullable SurfaceTexture p0) {
        Object object = this.mFrameSyncObject;
        synchronized (object) {
            boolean bl = false;
            if (this.mFrameAvailable) {
                throw new RuntimeException("mFrameAvailable already set, frame could be dropped");
            }
            this.mFrameAvailable = true;
            this.mFrameSyncObject.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }
}

