/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Bundle;
import com.google.android.gms.gcm.GcmListenerService;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.gcm.GcmNotificationManager;
import io.intercom.android.sdk.gcm.PushNotification;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.utilities.ContextLocaliser;

public class IntercomGcmListenerService
extends GcmListenerService {
    private static final String TAG = "GcmIntentService";
    private GcmNotificationManager gcmNotificationManager;

    public void onCreate() {
        super.onCreate();
        this.gcmNotificationManager = new GcmNotificationManager((NotificationManager)this.getSystemService("notification"));
    }

    public void onMessageReceived(String from, Bundle message) {
        Injector.init((Application)this.getApplication());
        if (Injector.get().getUserIdentity().identityExists()) {
            this.sendNotification(message);
        } else {
            this.removeAllNotifications();
            IntercomLogger.i((String)"Can't create GCM message we have no user identity. This can be caused by messages being sent to a logged out user.");
        }
    }

    private void sendNotification(Bundle message) {
        if (message != null && !message.isEmpty()) {
            IntercomLogger.internal((String)TAG, (String)("Notification Data Json :" + message.getString("message")));
            PushNotification notification = new PushNotification(message);
            if (notification.isIntercomPush()) {
                Context localisedContext = ContextLocaliser.create().createLocalisedContext((Context)this);
                if (notification.isPushOnly()) {
                    Injector.get().getMetricsStore().track(MetricFactory.receivedPushOnlyNotification((String)notification.getPushOnlyConversationId()));
                    this.gcmNotificationManager.createPushOnlyNotification(notification, localisedContext);
                } else if (Injector.get().getLifecycleTracker().isAppBackgrounded()) {
                    Injector.get().getMetricsStore().track(MetricFactory.receivedPushNotification((String)notification.getConversationId()));
                    this.gcmNotificationManager.createNotification(notification, localisedContext);
                } else {
                    IntercomLogger.i((String)"Intercom message received but not displayed in notification bar. This happened because the host app was in the foreground.");
                }
            } else {
                IntercomLogger.i((String)"This is not a Intercom GCM message");
            }
        } else {
            IntercomLogger.e((String)"The GCM intent contained no data");
        }
    }

    private void removeAllNotifications() {
        this.gcmNotificationManager.killNotifications();
    }
}

