/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.WakefulBroadcastReceiver;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.gcm.IntercomGcmIntentService;
import io.intercom.android.sdk.logger.IntercomLogger;

public class IntercomGcmBroadcastReceiver
extends WakefulBroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        if (this.isFromGoogle(intent)) {
            IntercomLogger.internal((String)"gcm_broadcast", (String)"is from google");
        } else {
            IntercomLogger.internal((String)"gcm_broadcast", (String)"not from google");
            if (DeviceUtils.hasPermission((Context)context, (String)"android.permission.WAKE_LOCK")) {
                ComponentName comp = new ComponentName(context, IntercomGcmIntentService.class);
                IntercomGcmBroadcastReceiver.startWakefulService((Context)context, (Intent)intent.setComponent(comp));
                this.setResultCode(-1);
            }
        }
    }

    @VisibleForTesting
    boolean isFromGoogle(Intent intent) {
        return intent != null && "google.com/iid".equals(intent.getStringExtra("from"));
    }
}

