/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import io.intercom.android.sdk.gcm.GcmNotificationBuilder;
import io.intercom.android.sdk.gcm.models.PushNotification;
import io.intercom.android.sdk.logger.IntercomLogger;
import java.util.ArrayList;
import java.util.List;

public class GcmNotificationManager {
    private static final int NOTIFICATION_ID = 9999997;
    private static final List<PushNotification> notifications = new ArrayList<PushNotification>();
    private final GcmNotificationBuilder gcmNotificationBuilder = new GcmNotificationBuilder();
    private final NotificationManager notificationManager;

    protected GcmNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    protected void killNotifications() {
        this.notificationManager.cancel(9999997);
        notifications.clear();
    }

    protected List<PushNotification> getNotifications() {
        return notifications;
    }

    protected void addNotification(PushNotification notification) {
        notifications.add(notification);
    }

    protected void createPushOnlyNotification(PushNotification notification, Context context) {
        Notification gcmNotification = this.gcmNotificationBuilder.createPushOnlyNotification(notification, context);
        String pushOnlyConversationId = notification.getPushOnlyConversationId();
        this.notificationManager.notify(pushOnlyConversationId, pushOnlyConversationId.hashCode(), gcmNotification);
    }

    protected void createNotification(String messageType, Context context) {
        if ("gcm".equals(messageType)) {
            Notification notification = null;
            if (notifications.size() == 1) {
                notification = this.gcmNotificationBuilder.createSingleNotification(notifications.get(0), context);
            } else if (notifications.size() > 1) {
                notification = this.gcmNotificationBuilder.createGroupedNotification(notifications, context);
            }
            if (notification != null) {
                this.notificationManager.notify(9999997, notification);
            } else {
                IntercomLogger.ERROR((String)"Failed to create push notification");
            }
        }
    }
}

