/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.fcm;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.NameUtils;

class NotificationAvatarUtils {
    private static final int LARGE_ICON_SIZE_DP = 48;

    NotificationAvatarUtils() {
    }

    public static Bitmap getNotificationInitialsBitmap(Context context, String name) {
        return NotificationAvatarUtils.drawableToBitmap(context, (Drawable)AvatarUtils.getInitialsDrawable((String)NameUtils.getInitial((String)name)));
    }

    public static Bitmap getNotificationDefaultBitmap(Context context) {
        return NotificationAvatarUtils.drawableToBitmap(context, (Drawable)AvatarUtils.getDefaultDrawable((Context)context));
    }

    private static Bitmap drawableToBitmap(Context context, Drawable drawable) {
        Bitmap bitmap;
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        if (drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
            int iconSize = ScreenUtils.convertDpToPixel((float)48.0f, (Context)context);
            bitmap = Bitmap.createBitmap((int)iconSize, (int)iconSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }
}

