/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.fcm;

import android.app.Application;
import android.text.TextUtils;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.push.IntercomPushClient;

public class IntercomFcmMessengerService
extends FirebaseMessagingService {
    private static final IntercomPushClient pushClient = new IntercomPushClient();
    private static final Twig twig = LumberMill.getLogger();

    public void onMessageReceived(RemoteMessage remoteMessage) {
        twig.d("Intercom push received: " + remoteMessage.getData(), new Object[0]);
        pushClient.handlePush(this.getApplication(), remoteMessage.getData());
    }

    public void onNewToken(String refreshedToken) {
        if (TextUtils.isEmpty((CharSequence)refreshedToken)) {
            twig.e("Intercom push registration failed. Please make sure you have added a google-services.json file", new Object[0]);
        } else {
            pushClient.sendTokenToIntercom(this.getApplication(), refreshedToken);
        }
    }

    public static void initialize(Application application) {
        FirebaseMessaging.getInstance().getToken().addOnCompleteListener(task -> {
            if (!task.isSuccessful()) {
                twig.w("Fetching FCM registration token failed", new Object[]{task.getException()});
                return;
            }
            String token = (String)task.getResult();
            twig.internal("FCM registration token fetched: " + token);
            pushClient.sendTokenToIntercom(application, token);
        });
    }
}

