/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DimenRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.RequestManager;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.GroupConversationTextFormatter;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.AuthorAvatarView;

public class InboxRowLayout
extends RelativeLayout {
    private final TextView authorName;
    private final TextView timeStamp;
    private final TextView summary;
    private final AuthorAvatarView authorAvatar;
    private final ImageView unreadDot;
    private final FrameLayout frameLayout;

    public InboxRowLayout(Context context) {
        this(context, null);
    }

    public InboxRowLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        InboxRowLayout.inflate((Context)this.getContext(), (int)R.layout.intercom_row_inbox, (ViewGroup)this);
        this.authorAvatar = (AuthorAvatarView)this.findViewById(R.id.intercom_author_avatar);
        this.authorName = (TextView)this.findViewById(R.id.intercom_user_name);
        this.timeStamp = (TextView)this.findViewById(R.id.intercom_time_stamp);
        this.summary = (TextView)this.findViewById(R.id.intercom_message_summary);
        this.unreadDot = (ImageView)this.findViewById(R.id.intercom_unread_dot);
        this.frameLayout = (FrameLayout)this.findViewById(R.id.intercom_inbox_row_layout);
    }

    public void updateVerticalPadding(@DimenRes int paddingRes) {
        int paddingPx = this.getResources().getDimensionPixelSize(paddingRes);
        this.frameLayout.setPadding(this.frameLayout.getPaddingLeft(), paddingPx, this.frameLayout.getPaddingRight(), paddingPx);
    }

    public void updateConversation(Conversation conversation, UserIdentity userIdentity, AppConfig appConfig, TeamPresence teamPresence, RequestManager requestManager, TimeFormatter timeFormatter) {
        Part lastNonEventPart = conversation.getLastNonEventPart();
        Part lastPart = conversation.getLastPart();
        Context context = this.getContext();
        if (lastNonEventPart.getParticipant().isUserWithId(userIdentity.getIntercomId())) {
            this.summary.setText((CharSequence)(context.getString(R.string.intercom_you) + ": " + lastNonEventPart.getSummary()));
        } else {
            this.summary.setText((CharSequence)lastNonEventPart.getSummary());
        }
        this.timeStamp.setText(timeFormatter.getFormattedTime(lastPart.getCreatedAt()));
        this.setRowParticipantDetails(conversation, appConfig.getName(), requestManager, teamPresence, appConfig);
        if (!conversation.isRead()) {
            this.authorName.setTypeface(Typeface.SANS_SERIF, 1);
            this.summary.setTypeface(Typeface.SANS_SERIF, 1);
            this.authorName.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_black));
            this.unreadDot.setVisibility(0);
        } else {
            this.authorName.setTypeface(Typeface.SANS_SERIF, 0);
            this.summary.setTypeface(Typeface.SANS_SERIF, 0);
            this.authorName.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_text_grey));
            this.unreadDot.setVisibility(8);
        }
    }

    private void setRowParticipantDetails(Conversation conversation, String appName, RequestManager requestManager, TeamPresence teamPresence, AppConfig appConfig) {
        LastParticipatingAdmin admin = conversation.getLastParticipatingAdmin();
        if (!TextUtils.isEmpty((CharSequence)admin.getFirstName())) {
            this.authorAvatar.loadAvatarWithActiveState(admin.getAvatar(), admin.isActive(), appConfig, requestManager);
            this.authorName.setText(GroupConversationTextFormatter.groupConversationTitle(admin.getFirstName(), conversation.getGroupConversationParticipants().size(), this.authorName.getContext()));
        } else if (teamPresence.isEmpty()) {
            this.authorAvatar.loadAvatar(admin.getAvatar(), appConfig, requestManager);
            this.authorName.setText((CharSequence)appName);
        } else {
            this.authorAvatar.loadAvatars(teamPresence.getActiveAdmins(), appConfig, requestManager);
            this.authorName.setText((CharSequence)appName);
        }
    }
}

