/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.Px;
import com.bumptech.glide.RequestManager;
import com.intercom.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.views.ActiveStatePresenter;
import java.util.List;

public class AuthorAvatarView
extends FrameLayout {
    private final ImageView leftImageView;
    private final ImageView rightImageView;
    private final ImageView topImageView;
    private final View activeStateView;
    private final ActiveStatePresenter activeStatePresenter = new ActiveStatePresenter();
    @Px
    private final int activeStateSize;
    @Px
    private final int imageViewSize;
    @Px
    private final int teamAvatarPadding;

    public AuthorAvatarView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorAvatarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.rightImageView = new ImageView(context);
        this.topImageView = new ImageView(context);
        this.leftImageView = new ImageView(context);
        this.activeStateView = new View(context);
        this.addView((View)this.rightImageView);
        this.addView((View)this.topImageView);
        this.addView((View)this.leftImageView);
        this.addView(this.activeStateView);
        this.leftImageView.setBackgroundResource(R.drawable.intercom_solid_circle);
        this.rightImageView.setBackgroundResource(R.drawable.intercom_solid_circle);
        this.topImageView.setBackgroundResource(R.drawable.intercom_solid_circle);
        this.activeStateView.setVisibility(8);
        this.teamAvatarPadding = ScreenUtils.dpToPx((float)1.0f, (Context)context);
        this.leftImageView.setPadding(this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding);
        this.rightImageView.setPadding(this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding);
        this.topImageView.setPadding(this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AuthorAvatarView, 0, 0);
        try {
            this.imageViewSize = a.getDimensionPixelSize(R.styleable.AuthorAvatarView_avatarSize, 0);
            this.activeStateSize = a.getDimensionPixelSize(R.styleable.AuthorAvatarView_activeStateSize, 0);
        }
        finally {
            a.recycle();
        }
        this.activeStateView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.activeStateSize, this.activeStateSize, 0x800055));
    }

    public void loadAvatars(List<Participant> participants, AppConfig appConfig, RequestManager requestManager) {
        switch (participants.size()) {
            case 0: {
                this.loadDefaultDrawable(appConfig);
                break;
            }
            case 1: {
                this.loadAvatar(participants.get(0).getAvatar(), appConfig, requestManager);
                break;
            }
            case 2: {
                this.loadTwoAvatars(participants.get(0), participants.get(1), appConfig, requestManager);
                break;
            }
            default: {
                this.loadThreeAvatars(participants.get(0), participants.get(1), participants.get(2), appConfig, requestManager);
            }
        }
    }

    private void loadDefaultDrawable(AppConfig appConfig) {
        this.leftImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.leftImageView.setPadding(0, 0, 0, 0);
        this.setNumberOfVisibleAvatars(1);
        this.activeStateView.setVisibility(8);
        this.requestLayout();
        this.leftImageView.setImageDrawable((Drawable)AvatarUtils.getDefaultDrawable(this.leftImageView.getContext(), appConfig));
    }

    public void loadAvatar(Avatar avatar, AppConfig appConfig, RequestManager requestManager) {
        this.leftImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.leftImageView.setPadding(0, 0, 0, 0);
        this.setNumberOfVisibleAvatars(1);
        this.activeStateView.setVisibility(8);
        this.requestLayout();
        AvatarUtils.loadAvatarIntoView(avatar, this.leftImageView, appConfig, requestManager);
    }

    public void loadAvatarWithActiveState(Avatar avatar, boolean isActive, AppConfig appConfig, RequestManager requestManager) {
        this.leftImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.leftImageView.setPadding(0, 0, 0, 0);
        this.setNumberOfVisibleAvatars(1);
        this.activeStatePresenter.presentStateDot(isActive, this.activeStateView, appConfig);
        this.activeStateView.setVisibility(0);
        this.requestLayout();
        AvatarUtils.loadAvatarIntoView(avatar, this.leftImageView, appConfig, requestManager);
    }

    private void loadTwoAvatars(Participant leftParticipant, Participant rightParticipant, AppConfig appConfig, RequestManager requestManager) {
        this.leftImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.imageViewSize, this.imageViewSize, 8388627));
        this.leftImageView.setPadding(this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding);
        this.rightImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.imageViewSize, this.imageViewSize, 8388629));
        this.setNumberOfVisibleAvatars(2);
        this.activeStateView.setVisibility(8);
        this.requestLayout();
        AvatarUtils.loadAvatarIntoView(leftParticipant.getAvatar(), this.leftImageView, appConfig, requestManager);
        AvatarUtils.loadAvatarIntoView(rightParticipant.getAvatar(), this.rightImageView, appConfig, requestManager);
    }

    private void loadThreeAvatars(Participant leftParticipant, Participant rightParticipant, Participant topParticipant, AppConfig appConfig, RequestManager requestManager) {
        this.leftImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.imageViewSize, this.imageViewSize, 8388691));
        this.leftImageView.setPadding(this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding, this.teamAvatarPadding);
        this.rightImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.imageViewSize, this.imageViewSize, 0x800055));
        this.topImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.imageViewSize, this.imageViewSize, 49));
        this.activeStateView.setVisibility(8);
        this.setNumberOfVisibleAvatars(3);
        this.requestLayout();
        AvatarUtils.loadAvatarIntoView(leftParticipant.getAvatar(), this.leftImageView, appConfig, requestManager);
        AvatarUtils.loadAvatarIntoView(rightParticipant.getAvatar(), this.rightImageView, appConfig, requestManager);
        AvatarUtils.loadAvatarIntoView(topParticipant.getAvatar(), this.topImageView, appConfig, requestManager);
    }

    private void setNumberOfVisibleAvatars(int visibleCount) {
        this.leftImageView.setVisibility(visibleCount >= 1 ? 0 : 8);
        this.rightImageView.setVisibility(visibleCount >= 2 ? 0 : 8);
        this.topImageView.setVisibility(visibleCount >= 3 ? 0 : 8);
    }
}

