/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.utilities.IntentUtils;
import java.util.Locale;

public class LinkOpener {
    private static final Twig twig = LumberMill.getLogger();

    public static void handleUrl(String url, Context context, Api api) {
        Uri uri;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (LinkOpener.isTrackingUrl(url)) {
            api.hitTrackingUrl(url);
            uri = LinkOpener.getTargetUriFromTrackingUrl(url);
        } else {
            uri = LinkOpener.parseUrl(url);
        }
        LinkOpener.openUrl(uri, context);
    }

    @VisibleForTesting
    static Uri getTargetUriFromTrackingUrl(String trackingUrl) {
        Uri uri = Uri.parse((String)trackingUrl);
        String queryUrl = uri.isHierarchical() ? uri.getQueryParameter("url") : trackingUrl;
        String targetUrl = queryUrl == null ? trackingUrl : queryUrl;
        return LinkOpener.parseUrl(targetUrl);
    }

    private static Uri parseUrl(String url) {
        Uri uri = Uri.parse((String)url);
        if (uri.getScheme() == null) {
            uri = Uri.parse((String)("http://" + url));
        }
        if (uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https")) {
            uri = LinkOpener.normalizeScheme(uri);
        }
        return uri;
    }

    private static Uri normalizeScheme(Uri uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return uri;
        }
        String lowerScheme = scheme.toLowerCase(Locale.ROOT);
        if (scheme.equals(lowerScheme)) {
            return uri;
        }
        return uri.buildUpon().scheme(lowerScheme).build();
    }

    private static boolean isTrackingUrl(String url) {
        return url.contains("via.intercom.io");
    }

    private static void openUrl(Uri uri, Context context) {
        String action = "mailto".equals(uri.getScheme()) ? "android.intent.action.SENDTO" : "android.intent.action.VIEW";
        Intent intent = new Intent(action, uri);
        intent.addFlags(0x10000000);
        try {
            IntentUtils.safelyOpenIntent(context, intent);
        }
        catch (ActivityNotFoundException e) {
            twig.e("No Activity found to handle the URL '" + uri.toString() + "'", new Object[0]);
        }
        catch (SecurityException e) {
            twig.e("Couldn't open link because of error: " + e.getMessage(), new Object[0]);
        }
    }
}

