/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models.carousel;

import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.intercom.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.carousel.AutoValue_Carousel;
import io.intercom.android.sdk.models.carousel.CarouselScreen;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.ArrayList;
import java.util.List;

@AutoValue
public abstract class Carousel {
    public static final Builder NULL_BUILDER = new Builder();
    public static final Carousel NULL = NULL_BUILDER.build();

    static Carousel create(List<CarouselScreen> screens, boolean isDismissible, String instanceId) {
        return new AutoValue_Carousel(screens, isDismissible, instanceId);
    }

    public abstract List<CarouselScreen> getScreens();

    public abstract boolean isDismissible();

    public abstract String getInstanceId();

    public static final class Builder {
        @Nullable
        List<CarouselScreen.Builder> screens;
        @Nullable
        Boolean dismissible;
        @Nullable
        String instance_id;

        public Builder withScreens(List<CarouselScreen.Builder> screens) {
            this.screens = screens;
            return this;
        }

        public Builder withDismissible(Boolean isDismissible) {
            this.dismissible = isDismissible;
            return this;
        }

        public Builder withInstanceId(String instanceId) {
            this.instance_id = instanceId;
            return this;
        }

        public Carousel build() {
            ArrayList<CarouselScreen> screens = new ArrayList<CarouselScreen>(CollectionUtils.capacityFor(this.screens));
            if (this.screens != null) {
                for (CarouselScreen.Builder builder : this.screens) {
                    if (builder == null) continue;
                    screens.add(builder.build());
                }
            }
            return Carousel.create(screens, NullSafety.valueOrDefault(this.dismissible, true), NullSafety.valueOrEmpty(this.instance_id));
        }
    }
}

