/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AlertDialog;
import androidx.collection.ArrayMap;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.bumptech.glide.RequestManager;
import com.intercom.commons.utilities.TimeProvider;
import com.intercom.input.gallery.GalleryImage;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.nexus.NexusEvent;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.LightboxOpeningImageClickListener;
import io.intercom.android.sdk.blocks.LinkOpeningButtonClickListener;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.blocks.function.TimestampAdder;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.Blocks;
import io.intercom.android.sdk.blocks.lib.BlocksViewHolder;
import io.intercom.android.sdk.blocks.lib.models.Author;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.lib.models.BlockAttachment;
import io.intercom.android.sdk.conversation.ConversationPartAdapter;
import io.intercom.android.sdk.conversation.IntercomLinkPresenter;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.conversation.SuggestionsClickListener;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.conversation.attribute.AttributeAnimateEndListener;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReplyOption;
import io.intercom.android.sdk.models.Suggestion;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.FormSubmitSuccessEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.NewTriggerConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.UploadEvent;
import io.intercom.android.sdk.models.events.failure.FormSubmitFailedEvent;
import io.intercom.android.sdk.models.events.failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.ReplyFailedEvent;
import io.intercom.android.sdk.models.events.failure.UploadFailedEvent;
import io.intercom.android.sdk.models.events.realtime.UserContentSeenByAdminEvent;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.KeyboardUtils;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.AttributeCollectorCardView;
import io.intercom.android.sdk.views.BaseAttributeView;
import io.intercom.android.sdk.views.IntercomLinkView;
import io.intercom.android.sdk.views.decoration.ConversationItemDecoration;
import io.intercom.android.sdk.views.holder.QuickReplyClickListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

class ConversationContentPresenter
implements IntercomLinkPresenter.IntercomLinkHost,
QuickReplyClickListener,
SuggestionsClickListener {
    private static final String IMAGE_MIME_TYPE = "image";
    private static final long PART_DISPLAY_DELIVERED_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    private final Part loadingPart = new Part.Builder().withStyle("loading_layout_style").build();
    private final TimestampAdder timestampAdder = TimestampAdder.create();
    final List<Part> sendingParts = new ArrayList<Part>();
    private final Map<String, AdminIsTypingView> isTypingViews = new ArrayMap();
    private final Host host;
    private final RecyclerView conversationList;
    private final ConversationPartAdapter adapter;
    private final LinearLayoutManager layoutManager;
    private final IntercomLinkPresenter intercomLinkPresenter;
    private final List<Part> parts;
    private final SoundPlayer soundPlayer;
    private final Blocks blocks;
    private final BlocksViewHolder blocksUserViewHolder;
    private final BlocksViewHolder blocksAnnouncementViewHolder;
    private final BlocksViewHolder blocksAdminViewHolder;
    private final BlocksViewHolder blocksLinkViewHolder;
    private final BlocksViewHolder blocksConversationRatingViewHolder;
    private final BlocksViewHolder blocksPreviewViewHolder;
    private final BlocksViewHolder blocksLinkListHolder;
    private Provider<AppConfig> appConfigProvider;
    private final MetricTracker metricTracker;
    private final UploadingImageCache uploadingImageCache;
    private final Api api;
    private final UserIdentity userIdentity;
    private final OpsMetricTracker opsMetricTracker;
    private final Context context;
    private final Bus bus;
    private final Store<State> store;
    private final NexusClient nexusClient;
    private String conversationId;
    private Runnable replyDeliveredUpdater;

    static ConversationContentPresenter create(Host host, RecyclerView conversationList, ConversationPartAdapter adapter, IntercomLinkView intercomLinkView, Provider<AppConfig> appConfigProvider, Api api, List<Part> parts, String conversationId, SoundPlayer soundPlayer, Blocks blocks, UserIdentity userIdentity, OpsMetricTracker opsMetricTracker, RequestManager requestManager, Activity activity, Store store, NexusClient nexusClient) {
        Injector injector = Injector.get();
        LinearLayoutManager layoutManager = new LinearLayoutManager(conversationList.getContext());
        IntercomLinkPresenter linkPresenter = new IntercomLinkPresenter(intercomLinkView, appConfigProvider, api, conversationId, injector.getAppIdentity().appId(), injector.getUserIdentity().getIntercomId(), false);
        UploadingImageCache uploadingImageCache = new UploadingImageCache();
        ViewHolderGenerator generator = new ViewHolderGenerator(uploadingImageCache, api, appConfigProvider, conversationId, new LightboxOpeningImageClickListener(api), new LinkOpeningButtonClickListener(api), requestManager, injector.getGson(), injector.getBus(), injector.getMetricTracker(), activity);
        return new ConversationContentPresenter(host, conversationList, adapter, layoutManager, linkPresenter, parts, soundPlayer, blocks, generator, userIdentity, api, opsMetricTracker, uploadingImageCache, (Context)activity, conversationId, injector.getMetricTracker(), injector.getBus(), store, nexusClient, appConfigProvider);
    }

    @VisibleForTesting
    ConversationContentPresenter(Host host, RecyclerView conversationList, ConversationPartAdapter adapter, LinearLayoutManager layoutManager, IntercomLinkPresenter intercomLinkPresenter, List<Part> parts, SoundPlayer soundPlayer, Blocks blocks, ViewHolderGenerator generator, UserIdentity userIdentity, Api api, OpsMetricTracker opsMetricTracker, UploadingImageCache uploadingImageCache, Context context, String conversationId, MetricTracker metricTracker, Bus bus, Store store, NexusClient nexusClient, Provider<AppConfig> appConfigProvider) {
        this.host = host;
        this.conversationList = conversationList;
        this.adapter = adapter;
        this.layoutManager = layoutManager;
        this.intercomLinkPresenter = intercomLinkPresenter;
        this.parts = parts;
        this.soundPlayer = soundPlayer;
        this.blocks = blocks;
        this.userIdentity = userIdentity;
        this.api = api;
        this.opsMetricTracker = opsMetricTracker;
        this.uploadingImageCache = uploadingImageCache;
        this.context = context;
        this.conversationId = conversationId;
        this.metricTracker = metricTracker;
        this.bus = bus;
        this.store = store;
        this.nexusClient = nexusClient;
        this.appConfigProvider = appConfigProvider;
        this.blocksUserViewHolder = generator.getUserHolder();
        this.blocksAnnouncementViewHolder = generator.getContainerCardHolder();
        this.blocksAdminViewHolder = generator.getAdminHolder();
        this.blocksLinkViewHolder = generator.getLinkHolder();
        this.blocksConversationRatingViewHolder = generator.getConversationRatingHolder();
        this.blocksPreviewViewHolder = generator.getPreviewHolder();
        this.blocksLinkListHolder = generator.getLinkListHolder();
        adapter.setQuickReplyClickListener(this);
        adapter.setSuggesstionsClickListener(this);
    }

    public void setup() {
        this.opsMetricTracker.trackEvent("finish", "time-to-process-action-load-conversation-ms");
        this.conversationList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.conversationList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.conversationList.addItemDecoration((RecyclerView.ItemDecoration)new ConversationItemDecoration(this.conversationList.getContext(), this.parts));
        ((SimpleItemAnimator)this.conversationList.getItemAnimator()).setSupportsChangeAnimations(false);
        this.conversationList.setNestedScrollingEnabled(true);
        this.conversationList.setVisibility(0);
        this.conversationList.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                ConversationContentPresenter.this.intercomLinkPresenter.updateIntercomLink(ConversationContentPresenter.this);
            }
        });
        this.intercomLinkPresenter.setup(this);
    }

    public void smoothScrollToTop() {
        this.conversationList.smoothScrollToPosition(0);
    }

    private void smoothScrollToBottom() {
        this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
    }

    public void scrollToTop() {
        this.conversationList.scrollToPosition(0);
    }

    public void scrollToBottom() {
        this.conversationList.scrollToPosition(this.adapter.getCount() - 1);
    }

    @Override
    public void addBottomPadding(int extraBottomPadding) {
        this.conversationList.setPadding(this.conversationList.getPaddingLeft(), this.conversationList.getPaddingTop(), this.conversationList.getPaddingRight(), this.conversationList.getPaddingBottom() + extraBottomPadding);
    }

    @Override
    public boolean isAtBottom() {
        return !this.conversationList.canScrollVertically(1);
    }

    public void onProfileScrolled() {
        int lastViewIndex = this.adapter.getCount() - 1;
        View lastChildView = lastViewIndex > 0 ? this.conversationList.getChildAt(lastViewIndex) : null;
        this.intercomLinkPresenter.onProfileScrolled(lastChildView);
    }

    public void onGlobalLayout() {
        this.intercomLinkPresenter.updateIntercomLink(this);
    }

    public void onNewPartReceived() {
        for (AdminIsTypingView isTypingView : this.isTypingViews.values()) {
            if (isTypingView == null) continue;
            isTypingView.cancelTypingAnimation();
        }
        this.smoothScrollToBottom();
    }

    public void showErrorView() {
        this.hideLoadingIndicator();
        this.conversationList.setVisibility(8);
    }

    public void showLoadingView() {
        this.showLoadingIndicator();
        this.conversationList.setVisibility(0);
    }

    public void showContentView() {
        this.hideLoadingIndicator();
        this.conversationList.setVisibility(0);
    }

    private void showLoadingIndicator() {
        this.parts.add(0, this.loadingPart);
        this.adapter.notifyItemInserted(0);
    }

    private void hideLoadingIndicator() {
        int index = this.parts.indexOf(this.loadingPart);
        if (index >= 0) {
            this.parts.remove(index);
            this.adapter.notifyItemRemoved(index);
        }
    }

    private int positionOfPart(int position, String partId) {
        if (position >= 0 && position < this.parts.size()) {
            Part sendingPart = this.parts.get(position);
            if (sendingPart.getId().equals(partId)) {
                return position;
            }
            return this.positionOfPartById(partId);
        }
        return -1;
    }

    private int positionOfPartById(String partId) {
        for (int i = this.parts.size() - 1; i >= 0; --i) {
            if (!this.parts.get(i).getId().equals(partId)) continue;
            return i;
        }
        return -1;
    }

    private void markAsFailed(int position, String partId, boolean uploadFailed) {
        int partPosition = this.positionOfPart(position, partId);
        if (partPosition >= 0) {
            Part failedPart = this.parts.get(partPosition);
            View partView = this.adapter.getViewForPart(failedPart).getChildAt(0);
            if (partView instanceof UploadProgressListener) {
                UploadProgressListener listener = (UploadProgressListener)partView;
                listener.uploadStopped();
            }
            failedPart.setMessageState(uploadFailed ? Part.MessageState.UPLOAD_FAILED : Part.MessageState.FAILED);
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void newConversationFailure(NewConversationFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), false);
    }

    @Subscribe
    public void replyFailure(ReplyFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), event.isUpload());
        this.soundPlayer.playReplyFailedSound();
    }

    @Subscribe
    public void uploadFailure(UploadFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), true);
        this.soundPlayer.playReplyFailedSound();
    }

    @Subscribe
    public void formSubmitFailed(FormSubmitFailedEvent event) {
        int partPosition = this.positionOfPartById(event.getPartId());
        if (partPosition < 0) {
            return;
        }
        ViewGroup partView = this.adapter.getViewForPart(this.parts.get(partPosition));
        if (partView != null && partView.getChildCount() > 0) {
            int count = partView.getChildCount();
            for (int index = 0; index < count; ++index) {
                View view = partView.getChildAt(index);
                String errorMessage = this.context.getResources().getString(R.string.intercom_something_went_wrong_try_again);
                BaseAttributeView attributeView = (BaseAttributeView)view;
                String identifier = attributeView.getAttribute().getIdentifier();
                if (!identifier.equals(event.getAttributeIdentifier())) continue;
                attributeView.displayEmptyState();
                attributeView.displayErrorState(errorMessage);
                break;
            }
        }
    }

    @Subscribe
    public void formSubmitSuccess(FormSubmitSuccessEvent event) {
        ViewParent parent;
        int partPosition = this.positionOfPartById(event.getPartId());
        if (partPosition < 0) {
            return;
        }
        ViewGroup partView = this.adapter.getViewForPart(this.parts.get(partPosition));
        if (partView != null && partView.getParent() != null && (parent = partView.getParent()) instanceof AttributeCollectorCardView) {
            AttributeCollectorCardView collectorView = (AttributeCollectorCardView)parent;
            if (collectorView.isExpanded()) {
                collectorView.animateBack(new AttributeAnimateEndListener(event.getConversation(), this.bus));
                KeyboardUtils.hideKeyboard((View)collectorView);
                this.host.onFormSubmitted();
            } else {
                ConversationEvent conversationEvent = new ConversationEvent.Builder(event.getConversation()).isAttributeUpdated(true).build();
                this.bus.post((Object)conversationEvent);
            }
        }
    }

    @VisibleForTesting
    void addViewForPart(Part part) {
        Participant author;
        if ("quick_reply".equals(part.getMessageStyle()) || "composer_suggestions_style".equals(part.getMessageStyle())) {
            return;
        }
        List<Block> blockParts = part.getBlocks();
        if (!part.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : part.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).withContentType(attachment.getContentType()).build());
            }
            blockParts.add(new Block.Builder().withType(BlockType.ATTACHMENTLIST.name()).withAttachments(blockAttachments).build());
        }
        if ((author = part.getParticipant()).isUserWithId(this.userIdentity.getIntercomId())) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksUserViewHolder));
        } else if ("post".equals(part.getMessageStyle()) || "note".equals(part.getMessageStyle())) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksAnnouncementViewHolder));
        } else if (part.isLinkCard()) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksLinkViewHolder));
        } else if (part.isSingleBlockPartOfType(BlockType.CONVERSATIONRATING)) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksConversationRatingViewHolder));
        } else if (part.isSingleBlockPartOfType(BlockType.LINKLIST)) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksLinkListHolder));
        } else if ("attribute_collector".equals(part.getMessageStyle())) {
            LinearLayout rootAttributeLayout = new LinearLayout(this.context);
            rootAttributeLayout.setOrientation(1);
            this.adapter.setViewForPart(part, (ViewGroup)rootAttributeLayout);
        } else {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksAdminViewHolder));
        }
    }

    private void displaySendingPart(Part part) {
        this.soundPlayer.playReplySentSound();
        this.parts.add(part);
        this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(part.getBlocks(), this.blocksPreviewViewHolder));
        this.adapter.notifyDataSetChanged();
        this.smoothScrollToBottom();
    }

    public synchronized void onAdminStartedTyping(AdminIsTypingEvent event) {
        final String adminId = event.getAdminId();
        if (this.isTypingViews.containsKey(adminId)) {
            this.isTypingViews.get(adminId).renewTypingAnimation();
            return;
        }
        final Part isTypingPart = new Part.Builder().withParticipantIsAdmin(true).withStyle("admin_is_typing_style").build();
        Participant participant = this.host.getConversation().getParticipant(adminId);
        if (participant == Participant.NULL) {
            participant = Participant.create(adminId, event.getAdminName(), "admin", "", Avatar.create(event.getAdminAvatarUrl(), ""), false);
        }
        isTypingPart.setParticipant(participant);
        isTypingPart.setEntranceAnimation(true);
        boolean wasAtBottom = this.isAtBottom();
        this.parts.add(isTypingPart);
        Context context = this.conversationList.getContext();
        LinearLayout container = (LinearLayout)View.inflate((Context)context, (int)R.layout.intercom_blocks_admin_layout, null);
        AdminIsTypingView view = new AdminIsTypingView(context);
        view.setListener(new AdminIsTypingView.Listener(){

            @Override
            public void onAdminTypingAnimationEnded(AdminIsTypingView view) {
                ConversationContentPresenter.this.onAdminStoppedTyping(adminId, isTypingPart.getId());
            }
        });
        container.addView((View)view);
        this.isTypingViews.put(adminId, view);
        this.adapter.setViewForPart(isTypingPart, (ViewGroup)container);
        this.adapter.notifyDataSetChanged();
        if (wasAtBottom) {
            this.smoothScrollToBottom();
        }
    }

    void onAdminStoppedTyping(String adminId, String partId) {
        this.isTypingViews.remove(adminId);
        int position = this.positionOfPart(this.parts.size() - 1, partId);
        if (position >= 0) {
            this.parts.remove(position);
            this.adapter.notifyDataSetChanged();
        }
    }

    public void fetchConversation(final String conversationId) {
        if (!conversationId.isEmpty()) {
            this.opsMetricTracker.trackEvent("start", "time-to-complete-request-load-conversation-ms");
            this.conversationId = conversationId;
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    ConversationContentPresenter.this.api.getConversation(conversationId, null);
                }
            });
        }
    }

    public void onPartClicked(Part part) {
        if (part.getMessageState() == Part.MessageState.FAILED) {
            this.showRetryDialog(part);
        } else if (part.getMessageState() == Part.MessageState.UPLOAD_FAILED) {
            this.retryFailedUpload(part);
        }
    }

    private void retryFailedUpload(Part part) {
        UploadProgressListener listener;
        int position = this.positionOfPart(this.parts.size() - 1, part.getId());
        if (position >= 0) {
            listener = (UploadProgressListener)this.adapter.getViewForPart(this.parts.get(position)).getChildAt(0);
            listener.uploadStarted();
        } else {
            listener = new UploadProgressListener(){

                @Override
                public void uploadStarted() {
                }

                @Override
                public void uploadNotice(byte percentUploaded) {
                }

                @Override
                public void uploadSmoothEnd() {
                }

                @Override
                public void uploadStopped() {
                }
            };
        }
        part.setMessageState(Part.MessageState.SENDING);
        this.parts.remove(this.parts.indexOf(part));
        this.parts.add(part);
        this.adapter.notifyDataSetChanged();
        this.api.uploadFile(part.getUpload(), position, part.getId(), this.uploadingImageCache, listener, this.context);
    }

    private void showRetryDialog(final Part part) {
        new AlertDialog.Builder(this.conversationList.getContext()).setTitle(R.string.intercom_inbox_error_state_title).setMessage(R.string.intercom_failed_delivery).setPositiveButton(R.string.intercom_retry, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConversationContentPresenter.this.retryTapped(part);
            }
        }).show();
    }

    void retryTapped(Part part) {
        part.setMessageState(Part.MessageState.SENDING);
        this.parts.remove(part);
        this.parts.add(part);
        this.adapter.notifyDataSetChanged();
        List<Block> partBlocks = part.getBlocks();
        int size = partBlocks.size();
        ArrayList<Block.Builder> blockBuilders = new ArrayList<Block.Builder>(partBlocks.size());
        for (int i = 0; i < size; ++i) {
            blockBuilders.add(partBlocks.get(i).toBuilder());
        }
        this.sendPart(blockBuilders);
    }

    private Part addSendingPart(List<Block.Builder> blocks) {
        Part part = this.createSendingPart(blocks);
        this.sendingParts.add(part);
        this.displaySendingPart(part);
        return part;
    }

    private Part createSendingPart(List<Block.Builder> blocks) {
        Part part = new Part.Builder().withCreatedAt(TimeUnit.MILLISECONDS.toSeconds(TimeProvider.SYSTEM.currentTimeMillis())).withStyle("chat").withBlocks(blocks).build();
        part.setMessageState(Part.MessageState.SENDING);
        part.setParticipant(this.getUserParticipant());
        part.setEntranceAnimation(true);
        return part;
    }

    void addComposerSuggestionsPart(ComposerSuggestions composerSuggestions) {
        Part lastPart;
        if (composerSuggestions.getSuggestions().isEmpty()) {
            return;
        }
        Part composerSuggestionsPart = this.createComposerSuggestionsPart(composerSuggestions);
        if (!this.parts.isEmpty() && "composer_suggestions_style".equals((lastPart = this.parts.get(this.parts.size() - 1)).getMessageStyle())) {
            this.parts.remove(lastPart);
        }
        this.parts.add(composerSuggestionsPart);
        this.adapter.notifyDataSetChanged();
    }

    private Part createComposerSuggestionsPart(ComposerSuggestions composerSuggestions) {
        Part composerSuggestionsPart = new Part.Builder().withCreatedAt(TimeUnit.MILLISECONDS.toSeconds(TimeProvider.SYSTEM.currentTimeMillis())).withStyle("composer_suggestions_style").build();
        composerSuggestionsPart.setComposerSuggestions(composerSuggestions);
        return composerSuggestionsPart;
    }

    Participant getUserParticipant() {
        String intercomId = this.userIdentity.getIntercomId();
        Participant user = this.host.getConversation().getParticipant(intercomId);
        if (user == Participant.NULL) {
            return new Participant.Builder().withId(intercomId).build();
        }
        return user;
    }

    public void sendPart(List<Block.Builder> blockBuilders) {
        this.opsMetricTracker.trackEvent("finish", "time-to-process-action-send-part-ms");
        this.opsMetricTracker.trackEvent("start", "time-to-complete-request-send-part-ms");
        Part part = this.addSendingPart(blockBuilders);
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.api.startNewConversation(blockBuilders, this.parts.size() - 1, part.getId(), this.store.select(Selectors.COMPOSER_SUGGESTIONS).getSuggestions());
        } else {
            this.api.replyToConversation(this.conversationId, blockBuilders, this.parts.size() - 1, part.getId(), false);
        }
    }

    @Subscribe
    public void uploadSuccess(UploadEvent event) {
        String tempPartId = event.getTempPartId();
        int partPosition = this.positionOfPart(event.getTempPartPosition(), tempPartId);
        if (partPosition < 0) {
            return;
        }
        Part part = this.parts.get(partPosition);
        if (part.getBlocks().isEmpty() || !tempPartId.equals(part.getId())) {
            return;
        }
        List<Block.Builder> blocks = this.createBlocksForUpload(event, part.getBlocks().get(0));
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.api.startNewConversation(blocks, this.parts.size() - 1, tempPartId, this.store.select(Selectors.COMPOSER_SUGGESTIONS).getSuggestions());
        } else {
            this.api.replyToConversation(this.conversationId, blocks, partPosition, part.getId(), true);
        }
    }

    private List<Block.Builder> createBlocksForUpload(UploadEvent event, Block localFileBlock) {
        if (event.getUpload().getContentType().contains(IMAGE_MIME_TYPE)) {
            return Collections.singletonList(localFileBlock.toBuilder().withType(BlockType.IMAGE.getSerializedName()).withUrl(event.getUpload().getPublicUrl()));
        }
        List<BlockAttachment> attachments = localFileBlock.getAttachments();
        if (attachments.isEmpty()) {
            return Collections.emptyList();
        }
        BlockAttachment tempAttachment = attachments.get(0);
        tempAttachment = tempAttachment.toBuilder().withSize(event.getSize()).withId(event.getUpload().getId()).build();
        Block.Builder builder = localFileBlock.toBuilder().withAttachments(Collections.singletonList(tempAttachment)).withType(BlockType.ATTACHMENTLIST.getSerializedName());
        return Collections.singletonList(builder);
    }

    public void uploadImage(List<Block.Builder> blocks, GalleryImage galleryImage) {
        Part part = this.addSendingPart(blocks);
        part.setUpload(galleryImage);
        this.api.uploadFile(galleryImage, this.parts.size() - 1, part.getId(), this.uploadingImageCache, (UploadProgressListener)this.adapter.getViewForPart(part).getChildAt(0), this.context);
    }

    public void onNewConversation(NewConversationEvent event) {
        this.updateSendPartOpsMetric();
        Conversation conversation = event.getConversation();
        Part part = event.getConversation().getParts().get(0);
        this.conversationId = conversation.getId();
        this.parts.remove(this.parts.size() - 1);
        this.sendingParts.clear();
        this.addViewForPart(part);
        this.parts.add(part);
        this.adapter.notifyDataSetChanged();
        this.intercomLinkPresenter.setSolution(conversation.getIntercomLinkSolution());
    }

    public void onReplyDelivered(ReplyEvent event) {
        this.updateSendPartOpsMetric();
        final Part part = event.getResponse();
        int position = this.positionOfPart(event.getPosition(), event.getPartId());
        if (position >= 0 && this.parts.get(position).isSendingPart()) {
            this.sendingParts.remove(this.parts.remove(position));
        }
        if (!this.parts.contains(part)) {
            this.addViewForPart(part);
            part.setDisplayDelivered(true);
            this.parts.add(part);
            this.adapter.notifyDataSetChanged();
        }
        this.conversationList.removeCallbacks(this.replyDeliveredUpdater);
        this.replyDeliveredUpdater = new Runnable(){

            @Override
            public void run() {
                part.setDisplayDelivered(false);
                ConversationContentPresenter.this.adapter.notifyDataSetChanged();
            }
        };
        this.conversationList.postDelayed(this.replyDeliveredUpdater, PART_DISPLAY_DELIVERED_TIMEOUT);
    }

    private void updateSendPartOpsMetric() {
        this.opsMetricTracker.trackEvent("finish", "time-to-complete-request-send-part-ms");
        this.opsMetricTracker.trackEvent("start", "time-to-render-result-send-part-ms");
        this.conversationList.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ConversationContentPresenter.this.opsMetricTracker.trackEvent("finish", "time-to-render-result-send-part-ms");
                ViewUtils.removeGlobalLayoutListener((View)ConversationContentPresenter.this.conversationList, this);
            }
        });
    }

    public void onConversationFetched(ConversationEvent event, boolean initialLoad) {
        this.opsMetricTracker.trackEvent("finish", "time-to-complete-request-load-conversation-ms");
        this.opsMetricTracker.trackEvent("start", "time-to-render-result-load-conversation-ms");
        Conversation conversation = event.getResponse();
        this.parts.clear();
        if (initialLoad) {
            this.conversationList.startAnimation(AnimationUtils.loadAnimation((Context)this.conversationList.getContext(), (int)R.anim.intercom_conversation_slide_in));
        }
        for (int i = 0; i < conversation.getParts().size(); ++i) {
            Part part = conversation.getParts().get(i);
            if (i < conversation.getParts().size() - 1 && "quick_reply".equals(part.getMessageStyle())) continue;
            if (this.adapter.getViewForPart(part) == null) {
                this.addViewForPart(part);
            }
            this.parts.add(part);
        }
        this.removeSendingPartsIfNeeded();
        this.addTemporaryExpectationsMessage();
        this.timestampAdder.addDayDividers(this.parts);
        this.adapter.notifyDataSetChanged();
        this.intercomLinkPresenter.setSolution(conversation.getIntercomLinkSolution());
        this.conversationList.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ConversationContentPresenter.this.opsMetricTracker.trackEvent("finish", "time-to-render-result-load-conversation-ms");
                ViewUtils.removeGlobalLayoutListener((View)ConversationContentPresenter.this.conversationList, this);
            }
        });
    }

    void addTemporaryExpectationsMessage() {
        String temporaryExpectationsMessage = this.appConfigProvider.get().getTemporaryExpectationsMessage();
        if (!temporaryExpectationsMessage.isEmpty()) {
            Block.Builder block = new Block.Builder().withText(temporaryExpectationsMessage);
            Part temporaryPart = new Part.Builder().withStyle("temporary_expectations_style").withBlocks(Collections.singletonList(block)).build();
            this.parts.add(0, temporaryPart);
            this.adapter.notifyItemInserted(0);
        }
    }

    private void removeSendingPartsIfNeeded() {
        Iterator<Part> iterator = this.sendingParts.iterator();
        while (iterator.hasNext()) {
            Part sendingPart = iterator.next();
            if (sendingPart.getUpload() == null) {
                iterator.remove();
                continue;
            }
            this.parts.add(sendingPart);
        }
    }

    @Subscribe
    public void onUserContentSeenByAdmin(UserContentSeenByAdminEvent event) {
        if (event.getConversationId().equals(this.conversationId) && !this.parts.isEmpty()) {
            boolean markedAsSeen = false;
            for (int i = this.parts.size() - 1; i >= 0; --i) {
                Part part = this.parts.get(i);
                if (!markedAsSeen && !part.isAdmin()) {
                    part.setSeenByAdmin("seen");
                    markedAsSeen = true;
                    continue;
                }
                part.setSeenByAdmin("hide");
            }
            this.adapter.notifyDataSetChanged();
        }
    }

    public void cleanup() {
        this.conversationList.removeCallbacks(this.replyDeliveredUpdater);
    }

    @Subscribe
    public void newConversationSuccess(NewConversationEvent event) {
        if (!this.parts.isEmpty() && this.parts.get(this.parts.size() - 1).getId().equals(event.getPartId())) {
            this.onNewConversation(event);
            this.host.onConversationCreated(event.getConversation());
        }
    }

    @Subscribe
    public void newTriggerConversationSuccess(NewTriggerConversationEvent event) {
        this.updateSendPartOpsMetric();
        Conversation conversation = event.getConversation();
        this.conversationId = conversation.getId();
        this.parts.clear();
        this.sendingParts.clear();
        for (int i = 0; i < conversation.getParts().size(); ++i) {
            this.addViewForPart(conversation.getParts().get(i));
            this.parts.add(conversation.getParts().get(i));
        }
        this.adapter.setConversationId(this.conversationId);
        this.adapter.notifyDataSetChanged();
        this.intercomLinkPresenter.setSolution(conversation.getIntercomLinkSolution());
        this.host.onConversationCreated(event.getConversation());
        this.store.dispatch(Actions.conversationMarkedAsRead(this.conversationId));
        this.nexusClient.fire(NexusEvent.getConversationSeenEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
    }

    @Override
    public void onQuickReplyClicked(Participant author, Part part, ReplyOption option) {
        Author.Builder authorBuilder = new Author.Builder();
        authorBuilder.withFirstName(author.getForename()).withName(author.getName()).withAvatar(author.getAvatar().getImageUrl());
        Block.Builder builder = new Block.Builder();
        builder.withText(option.text()).withAuthor(authorBuilder.build());
        Block.Builder fakePart = builder;
        ArrayList<Block.Builder> fakeParts = new ArrayList<Block.Builder>();
        fakeParts.add(fakePart);
        Part sendingPart = this.addSendingPart(fakeParts);
        int partPosition = this.positionOfPart(this.parts.size() - 1, sendingPart.getId());
        this.api.addConversationQuickReply(this.conversationId, part, option.uuid(), partPosition, sendingPart.getId());
        this.metricTracker.clickedQuickReply(option.uuid(), this.conversationId, part.getId());
    }

    void playSoundForNewAdminPart(List<Part> newParts) {
        for (Part part : newParts) {
            if (!part.isAdmin()) continue;
            if (part.getParticipant().isBot().booleanValue()) {
                this.soundPlayer.playOperatorReceivedSound();
                break;
            }
            this.soundPlayer.playMessageReceivedSound();
            break;
        }
    }

    @Override
    public void onSuggestionClicked(Part part, Suggestion suggestion) {
        Block.Builder builder = new Block.Builder();
        builder.withText(suggestion.getText());
        this.parts.clear();
        Block.Builder fakePart = builder;
        ArrayList<Block.Builder> fakeParts = new ArrayList<Block.Builder>();
        fakeParts.add(fakePart);
        Part sendingPart = this.addSendingPart(fakeParts);
        String uuid = UUID.randomUUID().toString();
        this.store.dispatch(Actions.composerSuggestionSelected(uuid));
        int partPosition = this.positionOfPart(this.parts.size() - 1, sendingPart.getId());
        this.api.triggerInboundCustomBot(sendingPart, suggestion.getUuid(), partPosition, uuid);
        this.metricTracker.clickedComposerSuggestion(suggestion.getUuid(), this.conversationId, part.getId());
    }

    static interface Host {
        public Conversation getConversation();

        public String getConversationId();

        public void onConversationCreated(Conversation var1);

        public void onFormSubmitted();
    }
}

