/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.RequestManager;
import com.google.android.flexbox.FlexboxLayout;
import com.intercom.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReplyOption;
import io.intercom.android.sdk.models.Suggestion;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.views.PartMetadataFormatter;
import io.intercom.android.sdk.views.holder.BlocksPartViewHolder;
import io.intercom.android.sdk.views.holder.ConversationListener;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PartViewHolder
extends BlocksPartViewHolder {
    private static final long TIMESTAMP_UPDATE_PERIOD = TimeUnit.MINUTES.toMillis(1L);
    private final int viewType;
    @VisibleForTesting
    final TextView metaData;
    private final TextView attribution;
    private final PartMetadataFormatter partMetadataFormatter;
    private final Provider<AppConfig> appConfigProvider;
    private final MetricTracker metricTracker;
    private final RequestManager requestManager;
    private ViewGroup blocks;

    public PartViewHolder(View itemView, int viewType, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager, PartMetadataFormatter partMetadataFormatter, Provider<AppConfig> appConfigProvider, RequestManager requestManager, MetricTracker metricTracker) {
        super(itemView, conversationListener, clipboardManager);
        this.viewType = viewType;
        this.partMetadataFormatter = partMetadataFormatter;
        this.appConfigProvider = appConfigProvider;
        this.requestManager = requestManager;
        this.metricTracker = metricTracker;
        this.metaData = (TextView)itemView.findViewById(R.id.metadata);
        this.attribution = (TextView)itemView.findViewById(R.id.attribution);
    }

    @Override
    public void bind(Part part, ViewGroup blocksLayout) {
        int position = this.getAdapterPosition();
        boolean shouldConcatenate = this.shouldConcatenate(part, position);
        this.blocks = this.setUpHolderBlocks(part, this.cellLayout, this.bubble, blocksLayout);
        this.setupHolderBackground(this.viewType, part, shouldConcatenate, this.requestManager, position);
        if (part.isAdmin()) {
            this.setAdminEndMargin(part);
            this.updateAvatarMarginForCard(part);
        }
        this.setupMetaData(this.viewType, part);
        this.setupAttribution(part);
        this.checkForEntranceAnimation(this.viewType, part, this.networkAvatar, (View)this.cellLayout, this.blocks);
        if (this.bubble != null) {
            this.bubble.setExpanded(this.shouldExpand(part), false);
        }
        if (this.isLastPart(part) && part.getReplyOptions().size() > 0) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.itemView.getContext());
            LinearLayout rootView = (LinearLayout)this.itemView.getRootView();
            FlexboxLayout replyOptionsLayout = (FlexboxLayout)rootView.findViewById(R.id.intercom_reply_options);
            if (replyOptionsLayout == null) {
                replyOptionsLayout = (FlexboxLayout)inflater.inflate(R.layout.intercom_quick_reply_layout, null);
                replyOptionsLayout.setId(R.id.intercom_reply_options);
                rootView.addView((View)replyOptionsLayout);
            }
            this.addReplyOptions(part, replyOptionsLayout);
        }
    }

    void addReplyOptions(final Part part, final FlexboxLayout replyOptionsLayout) {
        if (this.isLastPart(part)) {
            replyOptionsLayout.setVisibility(0);
        } else {
            replyOptionsLayout.setVisibility(8);
        }
        replyOptionsLayout.removeAllViews();
        Context context = replyOptionsLayout.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        List<ReplyOption> replyOptions = part.getReplyOptions();
        for (int i = 0; i < replyOptions.size(); ++i) {
            final ReplyOption option = replyOptions.get(i);
            TextView button = (TextView)inflater.inflate(R.layout.intercom_quick_reply_button, null);
            button.setText((CharSequence)option.text());
            AppConfig appConfig = this.appConfigProvider.get();
            BackgroundUtils.setButtonColor(button, this.appConfigProvider.get().getPrimaryColor());
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    replyOptionsLayout.setVisibility(8);
                    PartViewHolder.this.conversationListener.onQuickReplyClicked(part.getParticipant(), part, option);
                }
            });
            replyOptionsLayout.addView((View)button);
            this.metricTracker.receivedQuickReply(option.uuid(), this.conversationListener.getConversationId(), part.getId());
        }
    }

    void addComposerSuggestions(final Part part, final TextView prompt, final FlexboxLayout replyOptionsLayout) {
        if (this.isLastPart(part)) {
            replyOptionsLayout.setVisibility(0);
        } else {
            replyOptionsLayout.setVisibility(8);
            prompt.setVisibility(8);
        }
        replyOptionsLayout.removeAllViews();
        Context context = replyOptionsLayout.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        List<Suggestion> suggestions = part.getComposerSuggestions().getSuggestions();
        for (int i = 0; i < suggestions.size(); ++i) {
            final Suggestion suggestion = suggestions.get(i);
            TextView button = (TextView)inflater.inflate(R.layout.intercom_quick_reply_button, null);
            button.setText((CharSequence)suggestion.getText());
            AppConfig appConfig = this.appConfigProvider.get();
            BackgroundUtils.setButtonColor(button, this.appConfigProvider.get().getPrimaryColor());
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    replyOptionsLayout.setVisibility(8);
                    prompt.setVisibility(8);
                    PartViewHolder.this.conversationListener.onComposerSuggestionClicked(part, suggestion);
                }
            });
            replyOptionsLayout.addView((View)button);
            this.metricTracker.receivedComposerSuggestions(suggestion.getUuid(), this.conversationListener.getConversationId(), part.getId());
        }
    }

    private void setAdminEndMargin(Part part) {
        Context context = this.cellLayout.getContext();
        int endMargin = (int)(this.isSingleCardPart(part) ? context.getResources().getDimension(R.dimen.intercom_conversation_row_card_margin) : context.getResources().getDimension(R.dimen.intercom_conversation_row_margin));
        if (this.cellLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.cellLayout.getLayoutParams();
            params.setMargins(params.leftMargin, params.topMargin, endMargin, params.bottomMargin);
        }
    }

    private boolean shouldExpand(Part part) {
        return this.isSelectedPart(part) || this.isLastPart(part) || this.isNextPartTyping(this.getAdapterPosition());
    }

    @VisibleForTesting
    boolean isSelectedPart(Part part) {
        return part == this.conversationListener.getSelectedPart();
    }

    @VisibleForTesting
    boolean isLastPart(Part part) {
        return part == this.conversationListener.getPart(this.conversationListener.getCount() - 1) && !"admin_is_typing_style".equals(part.getMessageStyle());
    }

    @VisibleForTesting
    boolean isNextPartTyping(int adapterPosition) {
        if (adapterPosition == -1) {
            return false;
        }
        int nextPos = adapterPosition + 1;
        return nextPos <= this.conversationListener.getCount() - 1 && "admin_is_typing_style".equals(this.conversationListener.getPart(nextPos).getMessageStyle());
    }

    private void setupHolderBackground(int type, Part conversationPart, boolean shouldConcatenate, RequestManager requestManager, int position) {
        this.setBubbleBackground(conversationPart, (View)this.blocks, type, shouldConcatenate, position);
        if (this.networkAvatar != null) {
            if (shouldConcatenate) {
                this.networkAvatar.setVisibility(4);
            } else if (type == 1 || type == 5 || type == 4) {
                this.showAvatar(conversationPart.getParticipant(), this.networkAvatar, this.appConfigProvider.get(), requestManager);
            }
        }
    }

    public void onClick(View v) {
        int adapterPosition = this.getAdapterPosition();
        if (adapterPosition != -1) {
            this.conversationListener.onPartClicked(adapterPosition, this);
        }
    }

    public void setExpanded(boolean expanded) {
        if (this.bubble != null) {
            this.bubble.setExpanded(expanded, true);
        }
    }

    @VisibleForTesting
    void setupMetaData(int type, final Part conversationPart) {
        if (this.metaData == null) {
            return;
        }
        if (type == 2 || type == 3) {
            this.metaData.setVisibility(4);
            this.metaData.setHeight(ScreenUtils.dpToPx((float)10.0f, (Context)this.metaData.getContext()));
        } else {
            boolean isLastItem = conversationPart == this.conversationListener.getPart(this.conversationListener.getCount() - 1);
            final Resources resources = this.metaData.getResources();
            this.metaData.setText((CharSequence)this.partMetadataFormatter.getMetadataString(conversationPart, isLastItem, resources));
            if (isLastItem) {
                this.metaData.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PartViewHolder.this.metaData.setText((CharSequence)PartViewHolder.this.partMetadataFormatter.getMetadataString(conversationPart, true, resources));
                        PartViewHolder.this.metaData.postDelayed((Runnable)this, TIMESTAMP_UPDATE_PERIOD);
                    }
                }, TIMESTAMP_UPDATE_PERIOD);
            }
            if (Part.MessageState.UPLOAD_FAILED == conversationPart.getMessageState()) {
                this.metaData.setCompoundDrawablesWithIntrinsicBounds(R.drawable.intercom_message_error, 0, 0, 0);
            } else {
                this.metaData.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            }
        }
    }

    private void setupAttribution(Part conversationPart) {
        if (this.attribution == null) {
            return;
        }
        if (this.shouldShowAttribution(conversationPart)) {
            CharSequence attributionText = Phrase.from(this.metaData.getContext(), R.string.intercom_gif_attribution).put("providername", conversationPart.getBlocks().get(0).getAttribution()).format();
            this.attribution.setVisibility(0);
            this.attribution.setText(attributionText);
        } else {
            this.attribution.setVisibility(8);
        }
    }

    private boolean shouldShowAttribution(Part part) {
        return this.isSingleImagePart(part) && !TextUtils.isEmpty((CharSequence)part.getBlocks().get(0).getAttribution()) && part.getMessageState().equals((Object)Part.MessageState.NORMAL);
    }

    private boolean shouldConcatenate(Part conversationPart, int position) {
        if (position == -1) {
            return false;
        }
        if (position + 1 < this.conversationListener.getCount()) {
            Part nextPart = this.conversationListener.getPart(position + 1);
            return Part.shouldConcatenate(conversationPart, nextPart);
        }
        return false;
    }

    private void setBubbleBackground(Part conversationPart, View blocks, int type, boolean shouldConcatenate, int position) {
        int pLeft = blocks.getPaddingLeft();
        int pRight = blocks.getPaddingRight();
        int pTop = blocks.getPaddingTop();
        int pBottom = blocks.getPaddingBottom();
        if (this.isSingleImagePart(conversationPart) || this.isSingleCardPart(conversationPart)) {
            this.cellLayout.setBackgroundColor(0);
            this.cellLayout.setPadding(0, 0, 0, 0);
            pBottom = 0;
            pTop = 0;
        } else {
            Context context = this.cellLayout.getContext();
            int cellPadding = (int)context.getResources().getDimension(R.dimen.intercom_cell_horizontal_padding);
            this.cellLayout.setPadding(cellPadding, 0, cellPadding, 0);
            Drawable bubbleBackground = this.getBackgroundDrawable(context, type, shouldConcatenate, position, conversationPart);
            if (!conversationPart.isAdmin() && type != 4) {
                AppConfig appConfig = this.appConfigProvider.get();
                bubbleBackground.setColorFilter(appConfig.getPrimaryColor(), PorterDuff.Mode.SRC_IN);
            }
            BackgroundUtils.setBackground((View)this.cellLayout, bubbleBackground);
        }
        blocks.setPadding(pLeft, pTop, pRight, pBottom);
    }

    @Nullable
    private Drawable getBackgroundDrawable(Context context, int type, boolean shouldConcatenate, int position, Part conversationPart) {
        boolean hasPreviousConcatPart = this.hasPreviousConcatPart(conversationPart, position);
        if (shouldConcatenate) {
            int drawable2 = hasPreviousConcatPart ? this.getMiddleDrawable(type) : this.getTopDrawable(type);
            return ContextCompat.getDrawable((Context)context, (int)drawable2);
        }
        int drawable3 = hasPreviousConcatPart ? this.getBottomDrawable(type) : R.drawable.intercom_bubble_background;
        return ContextCompat.getDrawable((Context)context, (int)drawable3);
    }

    @DrawableRes
    private int getTopDrawable(int type) {
        return type == 0 ? R.drawable.intercom_bubble_background_user_top : R.drawable.intercom_bubble_background_admin_top;
    }

    @DrawableRes
    private int getMiddleDrawable(int type) {
        return type == 0 ? R.drawable.intercom_bubble_background_user_middle : R.drawable.intercom_bubble_background_admin_middle;
    }

    @DrawableRes
    private int getBottomDrawable(int type) {
        return type == 0 ? R.drawable.intercom_bubble_background_user_bottom : R.drawable.intercom_bubble_background_admin_bottom;
    }

    private boolean hasPreviousConcatPart(Part conversationPart, int position) {
        if (position > 0) {
            Part previousPart = this.conversationListener.getPart(position - 1);
            return Part.shouldConcatenate(conversationPart, previousPart);
        }
        return false;
    }

    private boolean isSingleImagePart(Part part) {
        List<Block> blocks = part.getBlocks();
        if (blocks.size() != 1) {
            return false;
        }
        BlockType blockType = blocks.get(0).getType();
        return blockType == BlockType.LOCALIMAGE || blockType == BlockType.IMAGE;
    }
}

