/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class PushBroadcast {
    private final Uri pushData;
    private final String pushOnlyId;
    private final Twig twig = LumberMill.getLogger();
    private int pushOnlyIdType;

    PushBroadcast() {
        this.pushData = Uri.EMPTY;
        this.pushOnlyId = "";
        this.pushOnlyIdType = -1;
    }

    PushBroadcast(Intent intent) {
        String pushOnlyInstanceId = intent.getStringExtra("push_only_instance_id");
        String pushOnlyConvoId = intent.getStringExtra("push_only_convo_id");
        if (!TextUtils.isEmpty((CharSequence)pushOnlyInstanceId)) {
            this.pushOnlyId = pushOnlyInstanceId;
            this.pushOnlyIdType = 1;
        } else if (!TextUtils.isEmpty((CharSequence)pushOnlyConvoId)) {
            this.pushOnlyId = pushOnlyConvoId;
            this.pushOnlyIdType = 0;
        } else {
            this.twig.internal("The uri had no push only id");
            this.pushOnlyId = "";
            this.pushOnlyIdType = -1;
        }
        Uri data = intent.getData();
        if (data == null) {
            this.twig.internal("The uri had no push data");
            this.pushData = Uri.EMPTY;
        } else {
            this.pushData = data;
        }
    }

    Uri getPushData() {
        return this.pushData;
    }

    String getPushOnlyId() {
        return this.pushOnlyId;
    }

    int getPushOnlyIdType() {
        return this.pushOnlyIdType;
    }

    boolean isEmpty() {
        return Uri.EMPTY.equals((Object)this.pushData) && this.pushOnlyId.isEmpty();
    }

    boolean hasPushOnlyId() {
        return !TextUtils.isEmpty((CharSequence)this.pushOnlyId);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PushOnlyIdType {
        public static final int CONVERSATION_ID = 0;
        public static final int INSTANCE_ID = 1;
        public static final int INVALID = -1;
    }
}

