/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics.ops;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.metrics.ops.OpsEvent;
import io.intercom.android.sdk.metrics.ops.OpsMetricObject;
import io.intercom.android.sdk.utilities.UuidStringProvider;
import java.util.ArrayList;
import java.util.List;

public class OpsMetricTracker {
    public static final String SEND_PART_TIME_TO_PROCESS_ACTION = "time-to-process-action-send-part-ms";
    public static final String SEND_PART_TIME_TO_COMPLETE_REQUEST = "time-to-complete-request-send-part-ms";
    public static final String SEND_PART_TIME_TO_RENDER_RESULT = "time-to-render-result-send-part-ms";
    public static final String LOAD_CONVERSATION_TIME_TO_PROCESS_ACTION = "time-to-process-action-load-conversation-ms";
    public static final String LOAD_CONVERSATION_TIME_TO_COMPLETE_REQUEST = "time-to-complete-request-load-conversation-ms";
    public static final String LOAD_CONVERSATION_TIME_TO_RENDER_RESULT = "time-to-render-result-load-conversation-ms";
    public static final String TIME_TO_COMPLETE_PING = "time-to-complete-ping-ms";
    public static final String TIMING_TYPE = "timing";
    public static final String START = "start";
    public static final String FINISH = "finish";
    private final MetricsStore store;
    private final TimeProvider timeProvider;
    private final UuidStringProvider uuidStringProvider;
    @VisibleForTesting
    final List<OpsEvent> events = new ArrayList<OpsEvent>();

    public OpsMetricTracker(MetricsStore store, TimeProvider timeProvider, UuidStringProvider uuidStringProvider) {
        this.store = store;
        this.timeProvider = timeProvider;
        this.uuidStringProvider = uuidStringProvider;
    }

    public void trackEvent(String eventType, String event) {
        OpsEvent opsEvent = new OpsEvent(eventType, event, this.timeProvider.currentTimeMillis());
        if (FINISH.equals(eventType)) {
            this.trackOpsEvent(opsEvent);
        } else {
            this.events.add(opsEvent);
        }
    }

    private void trackOpsEvent(OpsEvent endEvent) {
        OpsEvent startEvent = this.findStartEvent(endEvent.getName());
        if (startEvent == null) {
            return;
        }
        this.events.remove(startEvent);
        this.store.track(new OpsMetricObject(TIMING_TYPE, startEvent.getName(), endEvent.getTimestamp() - startEvent.getTimestamp(), this.uuidStringProvider.newUuidString()));
    }

    @Nullable
    private OpsEvent findStartEvent(String eventName) {
        for (int i = this.events.size() - 1; i >= 0; --i) {
            OpsEvent event = this.events.get(i);
            if (!START.equals(event.getEventType()) || !eventName.equals(event.getName())) continue;
            return event;
        }
        return null;
    }

    public void clear() {
        this.events.clear();
    }
}

