/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import io.intercom.android.sdk.imageloader.LongTermImageDiskCache;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.target.SimpleTarget;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.com.bumptech.glide.request.transition.Transition;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class LongTermImageLoader
implements Closeable {
    private static final Twig twig = LumberMill.getLogger();
    private static final int CACHE_SIZE = 0x1900000;
    private final LongTermImageDiskCache diskCache;
    private final Fetcher imageFetcher;

    public static LongTermImageLoader newInstance(Context context) {
        boolean directoryMade;
        File cacheDir = context.getCacheDir();
        File intercomCacheDirectory = new File(cacheDir, "intercom-glide");
        if (!intercomCacheDirectory.exists() && !(directoryMade = intercomCacheDirectory.mkdir())) {
            twig.e("Could not create directory: " + intercomCacheDirectory.getAbsolutePath(), new Object[0]);
        }
        LongTermImageDiskCache diskCache = new LongTermImageDiskCache(intercomCacheDirectory, 0x1900000);
        return new LongTermImageLoader(diskCache, new Fetcher(diskCache));
    }

    LongTermImageLoader(LongTermImageDiskCache diskCache, Fetcher imageFetcher) {
        this.diskCache = diskCache;
        this.imageFetcher = imageFetcher;
    }

    public void loadImage(String url, OnImageReadyListener onImageReadyListener, RequestManager requestManager) {
        OnImageReadyListener listener;
        File imageFile = this.diskCache.get(url);
        OnImageReadyListener onImageReadyListener2 = listener = onImageReadyListener == null ? OnImageReadyListener.NULL : onImageReadyListener;
        if (imageFile != null && imageFile.exists()) {
            this.imageFetcher.loadImageFromFile(url, imageFile, listener, requestManager);
        } else {
            this.imageFetcher.fetchImageFromWeb(url, listener, requestManager);
        }
    }

    @Override
    public void close() throws IOException {
        this.diskCache.close();
    }

    static class Fetcher {
        final LongTermImageDiskCache diskCache;

        Fetcher(LongTermImageDiskCache diskCache) {
            this.diskCache = diskCache;
        }

        void loadImageFromFile(final String url, File imageFile, final OnImageReadyListener onImageReadyListener, final RequestManager requestManager) {
            requestManager.asBitmap().load(imageFile).apply(new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE)).into((Target)new SimpleTarget<Bitmap>(Integer.MIN_VALUE, Integer.MIN_VALUE){

                public void onLoadFailed(@Nullable Drawable errorDrawable) {
                    this.fetchImageFromWeb(url, onImageReadyListener, requestManager);
                }

                public void onResourceReady(Bitmap bitmap, Transition<? super Bitmap> transition) {
                    onImageReadyListener.onImageReady(bitmap);
                }
            });
        }

        void fetchImageFromWeb(final String url, final OnImageReadyListener onImageReadyListener, RequestManager requestManager) {
            requestManager.asBitmap().load(url).apply(new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE)).into((Target)new SimpleTarget<Bitmap>(Integer.MIN_VALUE, Integer.MIN_VALUE){

                public void onResourceReady(Bitmap bitmap, Transition<? super Bitmap> transition) {
                    onImageReadyListener.onImageReady(bitmap);
                    if (!diskCache.isClosed()) {
                        diskCache.put(url, bitmap);
                    }
                }
            });
        }
    }

    public static interface OnImageReadyListener {
        public static final OnImageReadyListener NULL = new OnImageReadyListener(){

            @Override
            public void onImageReady(Bitmap bitmap) {
            }
        };

        public void onImageReady(Bitmap var1);
    }
}

