/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.ContentResolver;
import android.net.Uri;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.okhttp3.MediaType;
import io.intercom.okhttp3.RequestBody;
import io.intercom.okhttp3.internal.Util;
import io.intercom.okio.BufferedSink;
import io.intercom.okio.Okio;
import io.intercom.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

class ProgressRequestBody
extends RequestBody {
    private static final int SEGMENT_SIZE = 2048;
    private static final int SMOOTH_END_MIN_VALUE = 90;
    private final MediaType contentType;
    private final GalleryImage image;
    private final ContentResolver contentResolver;
    private final UploadProgressListener listener;

    public ProgressRequestBody(MediaType contentType, GalleryImage image, ContentResolver contentResolver, UploadProgressListener listener) {
        this.contentType = contentType;
        this.image = image;
        this.contentResolver = contentResolver;
        this.listener = listener;
    }

    public long contentLength() {
        return this.image.getFileSize();
    }

    public MediaType contentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        Uri uri = this.image.getUri();
        if (uri != Uri.EMPTY) {
            boolean uploadSmoothEnded = false;
            int fileSize = this.image.getFileSize();
            Source source = null;
            try {
                long read;
                InputStream in = this.contentResolver.openInputStream(uri);
                source = Okio.source((InputStream)in);
                long total = 0L;
                while ((read = source.read(sink.buffer(), 2048L)) != -1L) {
                    sink.flush();
                    byte progress = this.calculateProgress(total += read, fileSize);
                    if (progress >= 90) {
                        if (uploadSmoothEnded) continue;
                        uploadSmoothEnded = true;
                        this.listener.uploadSmoothEnd();
                        continue;
                    }
                    this.listener.uploadNotice(progress);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(source);
                throw throwable;
            }
            Util.closeQuietly((Closeable)source);
        }
    }

    private byte calculateProgress(long total, int fileSize) {
        if (fileSize <= 0) {
            return 100;
        }
        return (byte)(total * 100L / (long)fileSize);
    }
}

