/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.request;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.CheckResult;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.load.DecodeFormat;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.MultiTransformation;
import io.intercom.com.bumptech.glide.load.Option;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.model.stream.HttpGlideUrlLoader;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapEncoder;
import io.intercom.com.bumptech.glide.load.resource.bitmap.CenterCrop;
import io.intercom.com.bumptech.glide.load.resource.bitmap.CenterInside;
import io.intercom.com.bumptech.glide.load.resource.bitmap.CircleCrop;
import io.intercom.com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import io.intercom.com.bumptech.glide.load.resource.bitmap.Downsampler;
import io.intercom.com.bumptech.glide.load.resource.bitmap.DrawableTransformation;
import io.intercom.com.bumptech.glide.load.resource.bitmap.FitCenter;
import io.intercom.com.bumptech.glide.load.resource.bitmap.VideoBitmapDecoder;
import io.intercom.com.bumptech.glide.load.resource.gif.GifDrawable;
import io.intercom.com.bumptech.glide.load.resource.gif.GifDrawableTransformation;
import io.intercom.com.bumptech.glide.load.resource.gif.GifOptions;
import io.intercom.com.bumptech.glide.signature.EmptySignature;
import io.intercom.com.bumptech.glide.util.Preconditions;
import io.intercom.com.bumptech.glide.util.Util;
import java.util.HashMap;
import java.util.Map;

public class RequestOptions
implements Cloneable {
    private static final int UNSET = -1;
    private static final int SIZE_MULTIPLIER = 2;
    private static final int DISK_CACHE_STRATEGY = 4;
    private static final int PRIORITY = 8;
    private static final int ERROR_PLACEHOLDER = 16;
    private static final int ERROR_ID = 32;
    private static final int PLACEHOLDER = 64;
    private static final int PLACEHOLDER_ID = 128;
    private static final int IS_CACHEABLE = 256;
    private static final int OVERRIDE = 512;
    private static final int SIGNATURE = 1024;
    private static final int TRANSFORMATION = 2048;
    private static final int RESOURCE_CLASS = 4096;
    private static final int FALLBACK = 8192;
    private static final int FALLBACK_ID = 16384;
    private static final int THEME = 32768;
    private static final int TRANSFORMATION_ALLOWED = 65536;
    private static final int TRANSFORMATION_REQUIRED = 131072;
    private static final int USE_UNLIMITED_SOURCE_GENERATORS_POOL = 262144;
    private static final int ONLY_RETRIEVE_FROM_CACHE = 524288;
    private static final int USE_ANIMATION_POOL = 0x100000;
    @Nullable
    private static RequestOptions skipMemoryCacheTrueOptions;
    @Nullable
    private static RequestOptions skipMemoryCacheFalseOptions;
    @Nullable
    private static RequestOptions fitCenterOptions;
    @Nullable
    private static RequestOptions centerInsideOptions;
    @Nullable
    private static RequestOptions centerCropOptions;
    @Nullable
    private static RequestOptions circleCropOptions;
    @Nullable
    private static RequestOptions noTransformOptions;
    @Nullable
    private static RequestOptions noAnimationOptions;
    private int fields;
    private float sizeMultiplier = 1.0f;
    @NonNull
    private DiskCacheStrategy diskCacheStrategy = DiskCacheStrategy.AUTOMATIC;
    @NonNull
    private Priority priority = Priority.NORMAL;
    @Nullable
    private Drawable errorPlaceholder;
    private int errorId;
    @Nullable
    private Drawable placeholderDrawable;
    private int placeholderId;
    private boolean isCacheable = true;
    private int overrideHeight = -1;
    private int overrideWidth = -1;
    @NonNull
    private Key signature = EmptySignature.obtain();
    private boolean isTransformationRequired;
    private boolean isTransformationAllowed = true;
    @Nullable
    private Drawable fallbackDrawable;
    private int fallbackId;
    @NonNull
    private Options options = new Options();
    @NonNull
    private Map<Class<?>, Transformation<?>> transformations = new HashMap();
    @NonNull
    private Class<?> resourceClass = Object.class;
    private boolean isLocked;
    @Nullable
    private Resources.Theme theme;
    private boolean isAutoCloneEnabled;
    private boolean useUnlimitedSourceGeneratorsPool;
    private boolean onlyRetrieveFromCache;
    private boolean isScaleOnlyOrNoTransform = true;
    private boolean useAnimationPool;

    @CheckResult
    public static RequestOptions sizeMultiplierOf(@FloatRange(from=0.0, to=1.0) float sizeMultiplier) {
        return new RequestOptions().sizeMultiplier(sizeMultiplier);
    }

    @CheckResult
    public static RequestOptions diskCacheStrategyOf(@NonNull DiskCacheStrategy diskCacheStrategy) {
        return new RequestOptions().diskCacheStrategy(diskCacheStrategy);
    }

    @CheckResult
    public static RequestOptions priorityOf(@NonNull Priority priority) {
        return new RequestOptions().priority(priority);
    }

    @CheckResult
    public static RequestOptions placeholderOf(@Nullable Drawable placeholder) {
        return new RequestOptions().placeholder(placeholder);
    }

    @CheckResult
    public static RequestOptions placeholderOf(@DrawableRes int placeholderId) {
        return new RequestOptions().placeholder(placeholderId);
    }

    @CheckResult
    public static RequestOptions errorOf(@Nullable Drawable errorDrawable) {
        return new RequestOptions().error(errorDrawable);
    }

    @CheckResult
    public static RequestOptions errorOf(@DrawableRes int errorId) {
        return new RequestOptions().error(errorId);
    }

    @CheckResult
    public static RequestOptions skipMemoryCacheOf(boolean skipMemoryCache) {
        if (skipMemoryCache) {
            if (skipMemoryCacheTrueOptions == null) {
                skipMemoryCacheTrueOptions = new RequestOptions().skipMemoryCache(true).autoClone();
            }
            return skipMemoryCacheTrueOptions;
        }
        if (skipMemoryCacheFalseOptions == null) {
            skipMemoryCacheFalseOptions = new RequestOptions().skipMemoryCache(false).autoClone();
        }
        return skipMemoryCacheFalseOptions;
    }

    @CheckResult
    public static RequestOptions overrideOf(@IntRange(from=0L) int width, @IntRange(from=0L) int height) {
        return new RequestOptions().override(width, height);
    }

    @CheckResult
    public static RequestOptions overrideOf(@IntRange(from=0L) int size) {
        return RequestOptions.overrideOf(size, size);
    }

    @CheckResult
    public static RequestOptions signatureOf(@NonNull Key signature) {
        return new RequestOptions().signature(signature);
    }

    @CheckResult
    public static RequestOptions fitCenterTransform() {
        if (fitCenterOptions == null) {
            fitCenterOptions = new RequestOptions().fitCenter().autoClone();
        }
        return fitCenterOptions;
    }

    @CheckResult
    public static RequestOptions centerInsideTransform() {
        if (centerInsideOptions == null) {
            centerInsideOptions = new RequestOptions().centerInside().autoClone();
        }
        return centerInsideOptions;
    }

    @CheckResult
    public static RequestOptions centerCropTransform() {
        if (centerCropOptions == null) {
            centerCropOptions = new RequestOptions().centerCrop().autoClone();
        }
        return centerCropOptions;
    }

    @CheckResult
    public static RequestOptions circleCropTransform() {
        if (circleCropOptions == null) {
            circleCropOptions = new RequestOptions().circleCrop().autoClone();
        }
        return circleCropOptions;
    }

    @CheckResult
    public static RequestOptions bitmapTransform(@NonNull Transformation<Bitmap> transformation) {
        return new RequestOptions().transform(transformation);
    }

    @CheckResult
    public static RequestOptions noTransformation() {
        if (noTransformOptions == null) {
            noTransformOptions = new RequestOptions().dontTransform().autoClone();
        }
        return noTransformOptions;
    }

    @CheckResult
    public static <T> RequestOptions option(@NonNull Option<T> option, @NonNull T value) {
        return new RequestOptions().set(option, value);
    }

    @CheckResult
    public static RequestOptions decodeTypeOf(@NonNull Class<?> resourceClass) {
        return new RequestOptions().decode(resourceClass);
    }

    @CheckResult
    public static RequestOptions formatOf(@NonNull DecodeFormat format) {
        return new RequestOptions().format(format);
    }

    @CheckResult
    public static RequestOptions frameOf(@IntRange(from=0L) long frameTimeMicros) {
        return new RequestOptions().frame(frameTimeMicros);
    }

    @CheckResult
    public static RequestOptions downsampleOf(@NonNull DownsampleStrategy strategy) {
        return new RequestOptions().downsample(strategy);
    }

    @CheckResult
    public static RequestOptions timeoutOf(@IntRange(from=0L) int timeout2) {
        return new RequestOptions().timeout(timeout2);
    }

    @CheckResult
    public static RequestOptions encodeQualityOf(@IntRange(from=0L, to=100L) int quality) {
        return new RequestOptions().encodeQuality(quality);
    }

    @CheckResult
    public static RequestOptions encodeFormatOf(@NonNull Bitmap.CompressFormat format) {
        return new RequestOptions().encodeFormat(format);
    }

    @CheckResult
    public static RequestOptions noAnimation() {
        if (noAnimationOptions == null) {
            noAnimationOptions = new RequestOptions().dontAnimate().autoClone();
        }
        return noAnimationOptions;
    }

    private static boolean isSet(int fields, int flag) {
        return (fields & flag) != 0;
    }

    @CheckResult
    public RequestOptions sizeMultiplier(@FloatRange(from=0.0, to=1.0) float sizeMultiplier) {
        if (this.isAutoCloneEnabled) {
            return this.clone().sizeMultiplier(sizeMultiplier);
        }
        if (sizeMultiplier < 0.0f || sizeMultiplier > 1.0f) {
            throw new IllegalArgumentException("sizeMultiplier must be between 0 and 1");
        }
        this.sizeMultiplier = sizeMultiplier;
        this.fields |= 2;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions useUnlimitedSourceGeneratorsPool(boolean flag) {
        if (this.isAutoCloneEnabled) {
            return this.clone().useUnlimitedSourceGeneratorsPool(flag);
        }
        this.useUnlimitedSourceGeneratorsPool = flag;
        this.fields |= 0x40000;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions useAnimationPool(boolean flag) {
        if (this.isAutoCloneEnabled) {
            return this.clone().useAnimationPool(flag);
        }
        this.useAnimationPool = flag;
        this.fields |= 0x100000;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions onlyRetrieveFromCache(boolean flag) {
        if (this.isAutoCloneEnabled) {
            return this.clone().onlyRetrieveFromCache(flag);
        }
        this.onlyRetrieveFromCache = flag;
        this.fields |= 0x80000;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions diskCacheStrategy(@NonNull DiskCacheStrategy strategy) {
        if (this.isAutoCloneEnabled) {
            return this.clone().diskCacheStrategy(strategy);
        }
        this.diskCacheStrategy = Preconditions.checkNotNull(strategy);
        this.fields |= 4;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions priority(@NonNull Priority priority) {
        if (this.isAutoCloneEnabled) {
            return this.clone().priority(priority);
        }
        this.priority = Preconditions.checkNotNull(priority);
        this.fields |= 8;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions placeholder(@Nullable Drawable drawable) {
        if (this.isAutoCloneEnabled) {
            return this.clone().placeholder(drawable);
        }
        this.placeholderDrawable = drawable;
        this.fields |= 0x40;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions placeholder(@DrawableRes int resourceId) {
        if (this.isAutoCloneEnabled) {
            return this.clone().placeholder(resourceId);
        }
        this.placeholderId = resourceId;
        this.fields |= 0x80;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions fallback(@Nullable Drawable drawable) {
        if (this.isAutoCloneEnabled) {
            return this.clone().fallback(drawable);
        }
        this.fallbackDrawable = drawable;
        this.fields |= 0x2000;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions fallback(@DrawableRes int resourceId) {
        if (this.isAutoCloneEnabled) {
            return this.clone().fallback(resourceId);
        }
        this.fallbackId = resourceId;
        this.fields |= 0x4000;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions error(@Nullable Drawable drawable) {
        if (this.isAutoCloneEnabled) {
            return this.clone().error(drawable);
        }
        this.errorPlaceholder = drawable;
        this.fields |= 0x10;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions error(@DrawableRes int resourceId) {
        if (this.isAutoCloneEnabled) {
            return this.clone().error(resourceId);
        }
        this.errorId = resourceId;
        this.fields |= 0x20;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions theme(@Nullable Resources.Theme theme) {
        if (this.isAutoCloneEnabled) {
            return this.clone().theme(theme);
        }
        this.theme = theme;
        this.fields |= 0x8000;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions skipMemoryCache(boolean skip) {
        if (this.isAutoCloneEnabled) {
            return this.clone().skipMemoryCache(true);
        }
        this.isCacheable = !skip;
        this.fields |= 0x100;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions override(int width, int height) {
        if (this.isAutoCloneEnabled) {
            return this.clone().override(width, height);
        }
        this.overrideWidth = width;
        this.overrideHeight = height;
        this.fields |= 0x200;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions override(int size) {
        return this.override(size, size);
    }

    @CheckResult
    public RequestOptions signature(@NonNull Key signature) {
        if (this.isAutoCloneEnabled) {
            return this.clone().signature(signature);
        }
        this.signature = Preconditions.checkNotNull(signature);
        this.fields |= 0x400;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions clone() {
        try {
            RequestOptions result = (RequestOptions)super.clone();
            result.options = new Options();
            result.options.putAll(this.options);
            result.transformations = new HashMap();
            result.transformations.putAll(this.transformations);
            result.isLocked = false;
            result.isAutoCloneEnabled = false;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @CheckResult
    public <T> RequestOptions set(@NonNull Option<T> option, @NonNull T value) {
        if (this.isAutoCloneEnabled) {
            return this.clone().set(option, value);
        }
        Preconditions.checkNotNull(option);
        Preconditions.checkNotNull(value);
        this.options.set(option, value);
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions decode(@NonNull Class<?> resourceClass) {
        if (this.isAutoCloneEnabled) {
            return this.clone().decode(resourceClass);
        }
        this.resourceClass = Preconditions.checkNotNull(resourceClass);
        this.fields |= 0x1000;
        return this.selfOrThrowIfLocked();
    }

    public final boolean isTransformationAllowed() {
        return this.isTransformationAllowed;
    }

    public final boolean isTransformationSet() {
        return this.isSet(2048);
    }

    public final boolean isLocked() {
        return this.isLocked;
    }

    @CheckResult
    public RequestOptions encodeFormat(@NonNull Bitmap.CompressFormat format) {
        return this.set(BitmapEncoder.COMPRESSION_FORMAT, Preconditions.checkNotNull(format));
    }

    @CheckResult
    public RequestOptions encodeQuality(@IntRange(from=0L, to=100L) int quality) {
        return this.set(BitmapEncoder.COMPRESSION_QUALITY, quality);
    }

    @CheckResult
    public RequestOptions frame(@IntRange(from=0L) long frameTimeMicros) {
        return this.set(VideoBitmapDecoder.TARGET_FRAME, frameTimeMicros);
    }

    @CheckResult
    public RequestOptions format(@NonNull DecodeFormat format) {
        Preconditions.checkNotNull(format);
        return this.set(Downsampler.DECODE_FORMAT, format).set(GifOptions.DECODE_FORMAT, format);
    }

    @CheckResult
    public RequestOptions disallowHardwareConfig() {
        return this.set(Downsampler.ALLOW_HARDWARE_CONFIG, false);
    }

    @CheckResult
    public RequestOptions downsample(@NonNull DownsampleStrategy strategy) {
        return this.set(Downsampler.DOWNSAMPLE_STRATEGY, Preconditions.checkNotNull(strategy));
    }

    @CheckResult
    public RequestOptions timeout(@IntRange(from=0L) int timeoutMs) {
        return this.set(HttpGlideUrlLoader.TIMEOUT, timeoutMs);
    }

    @CheckResult
    public RequestOptions optionalCenterCrop() {
        return this.optionalTransform(DownsampleStrategy.CENTER_OUTSIDE, new CenterCrop());
    }

    @CheckResult
    public RequestOptions centerCrop() {
        return this.transform(DownsampleStrategy.CENTER_OUTSIDE, new CenterCrop());
    }

    @CheckResult
    public RequestOptions optionalFitCenter() {
        return this.optionalScaleOnlyTransform(DownsampleStrategy.FIT_CENTER, new FitCenter());
    }

    @CheckResult
    public RequestOptions fitCenter() {
        return this.scaleOnlyTransform(DownsampleStrategy.FIT_CENTER, new FitCenter());
    }

    @CheckResult
    public RequestOptions optionalCenterInside() {
        return this.optionalScaleOnlyTransform(DownsampleStrategy.CENTER_INSIDE, new CenterInside());
    }

    @CheckResult
    public RequestOptions centerInside() {
        return this.scaleOnlyTransform(DownsampleStrategy.CENTER_INSIDE, new CenterInside());
    }

    @CheckResult
    public RequestOptions optionalCircleCrop() {
        return this.optionalTransform(DownsampleStrategy.CENTER_OUTSIDE, new CircleCrop());
    }

    @CheckResult
    public RequestOptions circleCrop() {
        return this.transform(DownsampleStrategy.CENTER_INSIDE, new CircleCrop());
    }

    final RequestOptions optionalTransform(DownsampleStrategy downsampleStrategy, Transformation<Bitmap> transformation) {
        if (this.isAutoCloneEnabled) {
            return this.clone().optionalTransform(downsampleStrategy, transformation);
        }
        this.downsample(downsampleStrategy);
        return this.transform(transformation, false);
    }

    @CheckResult
    final RequestOptions transform(DownsampleStrategy downsampleStrategy, Transformation<Bitmap> transformation) {
        if (this.isAutoCloneEnabled) {
            return this.clone().transform(downsampleStrategy, transformation);
        }
        this.downsample(downsampleStrategy);
        return this.transform(transformation);
    }

    private RequestOptions scaleOnlyTransform(DownsampleStrategy strategy, Transformation<Bitmap> transformation) {
        return this.scaleOnlyTransform(strategy, transformation, true);
    }

    private RequestOptions optionalScaleOnlyTransform(DownsampleStrategy strategy, Transformation<Bitmap> transformation) {
        return this.scaleOnlyTransform(strategy, transformation, false);
    }

    private RequestOptions scaleOnlyTransform(DownsampleStrategy strategy, Transformation<Bitmap> transformation, boolean isTransformationRequired) {
        RequestOptions result = isTransformationRequired ? this.transform(strategy, transformation) : this.optionalTransform(strategy, transformation);
        result.isScaleOnlyOrNoTransform = true;
        return result;
    }

    @CheckResult
    public RequestOptions transform(@NonNull Transformation<Bitmap> transformation) {
        return this.transform(transformation, true);
    }

    @CheckResult
    public RequestOptions transforms(Transformation<Bitmap> ... transformations) {
        return this.transform(new MultiTransformation<Bitmap>(transformations), true);
    }

    @CheckResult
    public RequestOptions optionalTransform(@NonNull Transformation<Bitmap> transformation) {
        return this.transform(transformation, false);
    }

    private RequestOptions transform(@NonNull Transformation<Bitmap> transformation, boolean isRequired) {
        if (this.isAutoCloneEnabled) {
            return this.clone().transform(transformation, isRequired);
        }
        DrawableTransformation drawableTransformation = new DrawableTransformation(transformation, isRequired);
        this.transform(Bitmap.class, transformation, isRequired);
        this.transform(Drawable.class, drawableTransformation, isRequired);
        this.transform(BitmapDrawable.class, drawableTransformation.asBitmapDrawable(), isRequired);
        this.transform(GifDrawable.class, new GifDrawableTransformation(transformation), isRequired);
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public <T> RequestOptions optionalTransform(@NonNull Class<T> resourceClass, @NonNull Transformation<T> transformation) {
        return this.transform(resourceClass, transformation, false);
    }

    private <T> RequestOptions transform(@NonNull Class<T> resourceClass, @NonNull Transformation<T> transformation, boolean isRequired) {
        if (this.isAutoCloneEnabled) {
            return this.clone().transform(resourceClass, transformation, isRequired);
        }
        Preconditions.checkNotNull(resourceClass);
        Preconditions.checkNotNull(transformation);
        this.transformations.put(resourceClass, transformation);
        this.fields |= 0x800;
        this.isTransformationAllowed = true;
        this.fields |= 0x10000;
        this.isScaleOnlyOrNoTransform = false;
        if (isRequired) {
            this.fields |= 0x20000;
            this.isTransformationRequired = true;
        }
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public <T> RequestOptions transform(@NonNull Class<T> resourceClass, @NonNull Transformation<T> transformation) {
        return this.transform(resourceClass, transformation, true);
    }

    @CheckResult
    public RequestOptions dontTransform() {
        if (this.isAutoCloneEnabled) {
            return this.clone().dontTransform();
        }
        this.transformations.clear();
        this.fields &= 0xFFFFF7FF;
        this.isTransformationRequired = false;
        this.fields &= 0xFFFDFFFF;
        this.isTransformationAllowed = false;
        this.fields |= 0x10000;
        this.isScaleOnlyOrNoTransform = true;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public RequestOptions dontAnimate() {
        return this.set(GifOptions.DISABLE_ANIMATION, true);
    }

    @CheckResult
    public RequestOptions apply(@NonNull RequestOptions other) {
        if (this.isAutoCloneEnabled) {
            return this.clone().apply(other);
        }
        if (RequestOptions.isSet(other.fields, 2)) {
            this.sizeMultiplier = other.sizeMultiplier;
        }
        if (RequestOptions.isSet(other.fields, 262144)) {
            this.useUnlimitedSourceGeneratorsPool = other.useUnlimitedSourceGeneratorsPool;
        }
        if (RequestOptions.isSet(other.fields, 0x100000)) {
            this.useAnimationPool = other.useAnimationPool;
        }
        if (RequestOptions.isSet(other.fields, 4)) {
            this.diskCacheStrategy = other.diskCacheStrategy;
        }
        if (RequestOptions.isSet(other.fields, 8)) {
            this.priority = other.priority;
        }
        if (RequestOptions.isSet(other.fields, 16)) {
            this.errorPlaceholder = other.errorPlaceholder;
        }
        if (RequestOptions.isSet(other.fields, 32)) {
            this.errorId = other.errorId;
        }
        if (RequestOptions.isSet(other.fields, 64)) {
            this.placeholderDrawable = other.placeholderDrawable;
        }
        if (RequestOptions.isSet(other.fields, 128)) {
            this.placeholderId = other.placeholderId;
        }
        if (RequestOptions.isSet(other.fields, 256)) {
            this.isCacheable = other.isCacheable;
        }
        if (RequestOptions.isSet(other.fields, 512)) {
            this.overrideWidth = other.overrideWidth;
            this.overrideHeight = other.overrideHeight;
        }
        if (RequestOptions.isSet(other.fields, 1024)) {
            this.signature = other.signature;
        }
        if (RequestOptions.isSet(other.fields, 4096)) {
            this.resourceClass = other.resourceClass;
        }
        if (RequestOptions.isSet(other.fields, 8192)) {
            this.fallbackDrawable = other.fallbackDrawable;
        }
        if (RequestOptions.isSet(other.fields, 16384)) {
            this.fallbackId = other.fallbackId;
        }
        if (RequestOptions.isSet(other.fields, 32768)) {
            this.theme = other.theme;
        }
        if (RequestOptions.isSet(other.fields, 65536)) {
            this.isTransformationAllowed = other.isTransformationAllowed;
        }
        if (RequestOptions.isSet(other.fields, 131072)) {
            this.isTransformationRequired = other.isTransformationRequired;
        }
        if (RequestOptions.isSet(other.fields, 2048)) {
            this.transformations.putAll(other.transformations);
            this.isScaleOnlyOrNoTransform = other.isScaleOnlyOrNoTransform;
        }
        if (RequestOptions.isSet(other.fields, 524288)) {
            this.onlyRetrieveFromCache = other.onlyRetrieveFromCache;
        }
        if (!this.isTransformationAllowed) {
            this.transformations.clear();
            this.fields &= 0xFFFFF7FF;
            this.isTransformationRequired = false;
            this.fields &= 0xFFFDFFFF;
            this.isScaleOnlyOrNoTransform = true;
        }
        this.fields |= other.fields;
        this.options.putAll(other.options);
        return this.selfOrThrowIfLocked();
    }

    public boolean equals(Object o) {
        if (o instanceof RequestOptions) {
            RequestOptions other = (RequestOptions)o;
            return Float.compare(other.sizeMultiplier, this.sizeMultiplier) == 0 && this.errorId == other.errorId && Util.bothNullOrEqual(this.errorPlaceholder, other.errorPlaceholder) && this.placeholderId == other.placeholderId && Util.bothNullOrEqual(this.placeholderDrawable, other.placeholderDrawable) && this.fallbackId == other.fallbackId && Util.bothNullOrEqual(this.fallbackDrawable, other.fallbackDrawable) && this.isCacheable == other.isCacheable && this.overrideHeight == other.overrideHeight && this.overrideWidth == other.overrideWidth && this.isTransformationRequired == other.isTransformationRequired && this.isTransformationAllowed == other.isTransformationAllowed && this.useUnlimitedSourceGeneratorsPool == other.useUnlimitedSourceGeneratorsPool && this.onlyRetrieveFromCache == other.onlyRetrieveFromCache && this.diskCacheStrategy.equals(other.diskCacheStrategy) && this.priority == other.priority && this.options.equals(other.options) && this.transformations.equals(other.transformations) && this.resourceClass.equals(other.resourceClass) && Util.bothNullOrEqual(this.signature, other.signature) && Util.bothNullOrEqual(this.theme, other.theme);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = Util.hashCode(this.sizeMultiplier);
        hashCode = Util.hashCode(this.errorId, hashCode);
        hashCode = Util.hashCode(this.errorPlaceholder, hashCode);
        hashCode = Util.hashCode(this.placeholderId, hashCode);
        hashCode = Util.hashCode(this.placeholderDrawable, hashCode);
        hashCode = Util.hashCode(this.fallbackId, hashCode);
        hashCode = Util.hashCode(this.fallbackDrawable, hashCode);
        hashCode = Util.hashCode(this.isCacheable, hashCode);
        hashCode = Util.hashCode(this.overrideHeight, hashCode);
        hashCode = Util.hashCode(this.overrideWidth, hashCode);
        hashCode = Util.hashCode(this.isTransformationRequired, hashCode);
        hashCode = Util.hashCode(this.isTransformationAllowed, hashCode);
        hashCode = Util.hashCode(this.useUnlimitedSourceGeneratorsPool, hashCode);
        hashCode = Util.hashCode(this.onlyRetrieveFromCache, hashCode);
        hashCode = Util.hashCode(this.diskCacheStrategy, hashCode);
        hashCode = Util.hashCode((Object)this.priority, hashCode);
        hashCode = Util.hashCode(this.options, hashCode);
        hashCode = Util.hashCode(this.transformations, hashCode);
        hashCode = Util.hashCode(this.resourceClass, hashCode);
        hashCode = Util.hashCode(this.signature, hashCode);
        hashCode = Util.hashCode(this.theme, hashCode);
        return hashCode;
    }

    public RequestOptions lock() {
        this.isLocked = true;
        return this;
    }

    public RequestOptions autoClone() {
        if (this.isLocked && !this.isAutoCloneEnabled) {
            throw new IllegalStateException("You cannot auto lock an already locked options object, try clone() first");
        }
        this.isAutoCloneEnabled = true;
        return this.lock();
    }

    private RequestOptions selfOrThrowIfLocked() {
        if (this.isLocked) {
            throw new IllegalStateException("You cannot modify locked RequestOptions, consider clone()");
        }
        return this;
    }

    protected boolean isAutoCloneEnabled() {
        return this.isAutoCloneEnabled;
    }

    public final boolean isDiskCacheStrategySet() {
        return this.isSet(4);
    }

    public final boolean isSkipMemoryCacheSet() {
        return this.isSet(256);
    }

    @NonNull
    public final Map<Class<?>, Transformation<?>> getTransformations() {
        return this.transformations;
    }

    public final boolean isTransformationRequired() {
        return this.isTransformationRequired;
    }

    @NonNull
    public final Options getOptions() {
        return this.options;
    }

    @NonNull
    public final Class<?> getResourceClass() {
        return this.resourceClass;
    }

    @NonNull
    public final DiskCacheStrategy getDiskCacheStrategy() {
        return this.diskCacheStrategy;
    }

    @Nullable
    public final Drawable getErrorPlaceholder() {
        return this.errorPlaceholder;
    }

    public final int getErrorId() {
        return this.errorId;
    }

    public final int getPlaceholderId() {
        return this.placeholderId;
    }

    @Nullable
    public final Drawable getPlaceholderDrawable() {
        return this.placeholderDrawable;
    }

    public final int getFallbackId() {
        return this.fallbackId;
    }

    @Nullable
    public final Drawable getFallbackDrawable() {
        return this.fallbackDrawable;
    }

    @Nullable
    public final Resources.Theme getTheme() {
        return this.theme;
    }

    public final boolean isMemoryCacheable() {
        return this.isCacheable;
    }

    @NonNull
    public final Key getSignature() {
        return this.signature;
    }

    public final boolean isPrioritySet() {
        return this.isSet(8);
    }

    @NonNull
    public final Priority getPriority() {
        return this.priority;
    }

    public final int getOverrideWidth() {
        return this.overrideWidth;
    }

    public final boolean isValidOverride() {
        return Util.isValidDimensions(this.overrideWidth, this.overrideHeight);
    }

    public final int getOverrideHeight() {
        return this.overrideHeight;
    }

    public final float getSizeMultiplier() {
        return this.sizeMultiplier;
    }

    boolean isScaleOnlyOrNoTransform() {
        return this.isScaleOnlyOrNoTransform;
    }

    private boolean isSet(int flag) {
        return RequestOptions.isSet(this.fields, flag);
    }

    public final boolean getUseUnlimitedSourceGeneratorsPool() {
        return this.useUnlimitedSourceGeneratorsPool;
    }

    public final boolean getUseAnimationPool() {
        return this.useAnimationPool;
    }

    public final boolean getOnlyRetrieveFromCache() {
        return this.onlyRetrieveFromCache;
    }
}

