/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import io.intercom.com.bumptech.glide.load.model.Headers;
import io.intercom.com.bumptech.glide.load.model.LazyHeaderFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LazyHeaders
implements Headers {
    private final Map<String, List<LazyHeaderFactory>> headers;
    private volatile Map<String, String> combinedHeaders;

    LazyHeaders(Map<String, List<LazyHeaderFactory>> headers) {
        this.headers = Collections.unmodifiableMap(headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getHeaders() {
        if (this.combinedHeaders == null) {
            LazyHeaders lazyHeaders = this;
            synchronized (lazyHeaders) {
                if (this.combinedHeaders == null) {
                    this.combinedHeaders = Collections.unmodifiableMap(this.generateHeaders());
                }
            }
        }
        return this.combinedHeaders;
    }

    private Map<String, String> generateHeaders() {
        HashMap<String, String> combinedHeaders = new HashMap<String, String>();
        for (Map.Entry<String, List<LazyHeaderFactory>> entry : this.headers.entrySet()) {
            StringBuilder sb = new StringBuilder();
            List<LazyHeaderFactory> factories = entry.getValue();
            int size = factories.size();
            for (int i = 0; i < size; ++i) {
                LazyHeaderFactory factory2 = factories.get(i);
                String header = factory2.buildHeader();
                if (TextUtils.isEmpty((CharSequence)header)) continue;
                sb.append(header);
                if (i == factories.size() - 1) continue;
                sb.append(',');
            }
            String values = sb.toString();
            if (TextUtils.isEmpty((CharSequence)values)) continue;
            combinedHeaders.put(entry.getKey(), sb.toString());
        }
        return combinedHeaders;
    }

    public String toString() {
        return "LazyHeaders{headers=" + this.headers + '}';
    }

    public boolean equals(Object o) {
        if (o instanceof LazyHeaders) {
            LazyHeaders other = (LazyHeaders)o;
            return this.headers.equals(other.headers);
        }
        return false;
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    static final class StringHeaderFactory
    implements LazyHeaderFactory {
        private final String value;

        StringHeaderFactory(String value) {
            this.value = value;
        }

        @Override
        public String buildHeader() {
            return this.value;
        }

        public String toString() {
            return "StringHeaderFactory{value='" + this.value + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (o instanceof StringHeaderFactory) {
                StringHeaderFactory other = (StringHeaderFactory)o;
                return this.value.equals(other.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class Builder {
        private static final String USER_AGENT_HEADER = "User-Agent";
        private static final String DEFAULT_USER_AGENT = Builder.getSanitizedUserAgent();
        private static final Map<String, List<LazyHeaderFactory>> DEFAULT_HEADERS;
        private boolean copyOnModify = true;
        private Map<String, List<LazyHeaderFactory>> headers = DEFAULT_HEADERS;
        private boolean isUserAgentDefault = true;

        public Builder addHeader(String key, String value) {
            return this.addHeader(key, new StringHeaderFactory(value));
        }

        public Builder addHeader(String key, LazyHeaderFactory factory2) {
            if (this.isUserAgentDefault && USER_AGENT_HEADER.equalsIgnoreCase(key)) {
                return this.setHeader(key, factory2);
            }
            this.copyIfNecessary();
            this.getFactories(key).add(factory2);
            return this;
        }

        public Builder setHeader(String key, String value) {
            return this.setHeader(key, value == null ? null : new StringHeaderFactory(value));
        }

        public Builder setHeader(String key, LazyHeaderFactory factory2) {
            this.copyIfNecessary();
            if (factory2 == null) {
                this.headers.remove(key);
            } else {
                List<LazyHeaderFactory> factories = this.getFactories(key);
                factories.clear();
                factories.add(factory2);
            }
            if (this.isUserAgentDefault && USER_AGENT_HEADER.equalsIgnoreCase(key)) {
                this.isUserAgentDefault = false;
            }
            return this;
        }

        private List<LazyHeaderFactory> getFactories(String key) {
            List<LazyHeaderFactory> factories = this.headers.get(key);
            if (factories == null) {
                factories = new ArrayList<LazyHeaderFactory>();
                this.headers.put(key, factories);
            }
            return factories;
        }

        private void copyIfNecessary() {
            if (this.copyOnModify) {
                this.copyOnModify = false;
                this.headers = this.copyHeaders();
            }
        }

        public LazyHeaders build() {
            this.copyOnModify = true;
            return new LazyHeaders(this.headers);
        }

        private Map<String, List<LazyHeaderFactory>> copyHeaders() {
            HashMap<String, List<LazyHeaderFactory>> result = new HashMap<String, List<LazyHeaderFactory>>(this.headers.size());
            for (Map.Entry<String, List<LazyHeaderFactory>> entry : this.headers.entrySet()) {
                result.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            return result;
        }

        @VisibleForTesting
        static String getSanitizedUserAgent() {
            String defaultUserAgent = System.getProperty("http.agent");
            if (TextUtils.isEmpty((CharSequence)defaultUserAgent)) {
                return defaultUserAgent;
            }
            int length = defaultUserAgent.length();
            StringBuilder sb = new StringBuilder(defaultUserAgent.length());
            for (int i = 0; i < length; ++i) {
                char c = defaultUserAgent.charAt(i);
                if ((c > '\u001f' || c == '\t') && c < '\u007f') {
                    sb.append(c);
                    continue;
                }
                sb.append('?');
            }
            return sb.toString();
        }

        static {
            HashMap<String, List<StringHeaderFactory>> temp = new HashMap<String, List<StringHeaderFactory>>(2);
            if (!TextUtils.isEmpty((CharSequence)DEFAULT_USER_AGENT)) {
                temp.put(USER_AGENT_HEADER, Collections.singletonList(new StringHeaderFactory(DEFAULT_USER_AGENT)));
            }
            DEFAULT_HEADERS = Collections.unmodifiableMap(temp);
        }
    }
}

