/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.commons.utilities.HtmlCompat;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.ExpandableLayout;
import io.intercom.android.sdk.views.holder.ConversationListener;
import io.intercom.android.sdk.views.holder.ConversationPartViewHolder;
import io.intercom.com.bumptech.glide.RequestManager;
import java.util.List;

abstract class BlocksPartViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener,
ConversationPartViewHolder {
    final ConversationListener conversationListener;
    @Nullable
    private final ClipboardManager clipboardManager;
    final ImageView networkAvatar;
    protected final ViewGroup cellLayout;
    @Nullable
    final ExpandableLayout bubble;
    private final String clipboardMessage;
    private final Twig twig = LumberMill.getLogger();

    BlocksPartViewHolder(View itemView, ConversationListener conversationListener) {
        this(itemView, conversationListener, null);
    }

    BlocksPartViewHolder(View itemView, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager) {
        super(itemView);
        this.conversationListener = conversationListener;
        this.clipboardManager = clipboardManager;
        this.clipboardMessage = itemView.getContext().getString(R.string.intercom_copied_to_clipboard);
        this.networkAvatar = (ImageView)itemView.findViewById(R.id.avatarView);
        this.cellLayout = (ViewGroup)itemView.findViewById(R.id.cellLayout);
        this.bubble = (ExpandableLayout)itemView.findViewById(R.id.intercom_bubble);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    ViewGroup setUpHolderBlocks(Part conversationPart, ViewGroup cellLayout, ExpandableLayout bubble, ViewGroup blocksLayout) {
        cellLayout.setVisibility(0);
        if (blocksLayout.getParent() != null) {
            ((ViewGroup)blocksLayout.getParent()).removeView((View)blocksLayout);
        }
        if (cellLayout.getChildCount() > 0) {
            cellLayout.removeAllViews();
        }
        cellLayout.addView((View)blocksLayout, 0);
        this.setUpRowFocusRules(this.itemView, conversationPart, bubble);
        return blocksLayout;
    }

    private void setUpRowFocusRules(View row, Part conversationPart, ExpandableLayout bubble) {
        if (bubble == null) {
            return;
        }
        bubble.setAlpha(1.0f);
        if (Part.MessageState.FAILED == conversationPart.getMessageState() || Part.MessageState.UPLOAD_FAILED == conversationPart.getMessageState()) {
            ((ViewGroup)row).setDescendantFocusability(393216);
        }
    }

    void checkForEntranceAnimation(int type, Part part, ImageView networkAvatar, View cellLayout, ViewGroup blocks) {
        if (part.hasEntranceAnimation()) {
            if (type == 5) {
                part.setEntranceAnimation(false);
                networkAvatar.setAlpha(0.0f);
                networkAvatar.setScaleX(0.5f);
                networkAvatar.setScaleY(0.5f);
                networkAvatar.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setDuration(300L).setStartDelay(100L).start();
                cellLayout.setAlpha(0.0f);
                cellLayout.setScaleX(0.5f);
                cellLayout.setScaleY(0.5f);
                cellLayout.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setDuration(300L).setStartDelay(150L).start();
                ((AdminIsTypingView)blocks.getChildAt(0)).beginAnimation();
            } else if (Part.MessageState.SENDING == part.getMessageState()) {
                part.setEntranceAnimation(false);
                cellLayout.setAlpha(0.0f);
                cellLayout.setTranslationY(cellLayout.getTranslationY() + 100.0f);
                cellLayout.animate().setStartDelay(100L).alpha(1.0f).translationYBy(-100.0f).start();
            }
        }
    }

    void showAvatar(Participant user, ImageView networkAvatar, AppConfig appConfig, RequestManager requestManager) {
        networkAvatar.setVisibility(0);
        AvatarUtils.loadAvatarIntoView(user.getAvatar(), networkAvatar, appConfig, requestManager);
    }

    public boolean onLongClick(View v) {
        if (this.clipboardManager == null) {
            return false;
        }
        int adapterPosition = this.getAdapterPosition();
        if (adapterPosition == -1) {
            return false;
        }
        try {
            Part part = this.conversationListener.getPart(adapterPosition);
            this.clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)"message", (CharSequence)BlocksPartViewHolder.getPartText(part)));
            Toast.makeText((Context)this.itemView.getContext(), (CharSequence)this.clipboardMessage, (int)0).show();
        }
        catch (Exception e) {
            this.twig.internal(e.getMessage());
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static String getPartText(Part part) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        block5: for (Block block : part.getBlocks()) {
            switch (block.getType()) {
                case SUBHEADING: 
                case HEADING: 
                case CODE: 
                case PARAGRAPH: {
                    BlocksPartViewHolder.appendLine(builder, (CharSequence)HtmlCompat.fromHtml((String)block.getText()));
                    break;
                }
                case LINK: {
                    BlocksPartViewHolder.appendLine(builder, block.getUrl());
                    break;
                }
                case UNORDEREDLIST: 
                case ORDEREDLIST: {
                    for (String item : block.getItems()) {
                        BlocksPartViewHolder.appendLine(builder, item);
                    }
                    continue block5;
                }
            }
        }
        return builder.length() == 0 ? part.getSummary() : builder.toString();
    }

    private static void appendLine(SpannableStringBuilder builder, @Nullable CharSequence text) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (builder.length() > 0) {
            builder.append('\n');
        }
        builder.append(text);
    }

    void updateAvatarMarginForCard(Part part) {
        Resources resources = this.networkAvatar.getContext().getResources();
        boolean isCard = part.isLinkCard() || part.isLinkList() || this.isSingleCardPart(part);
        int bottomMargin = isCard ? (int)resources.getDimension(R.dimen.intercom_card_shadow_bottom_margin) : 0;
        int rightMargin = isCard ? 0 : (int)resources.getDimension(R.dimen.intercom_conversation_row_icon_spacer);
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.networkAvatar.getLayoutParams();
        params.setMargins(params.leftMargin, params.topMargin, rightMargin, bottomMargin);
    }

    boolean isSingleCardPart(Part part) {
        List<Block> blocks = part.getBlocks();
        if (blocks.size() != 1) {
            return false;
        }
        Block block = blocks.get(0);
        return block.getType() == BlockType.MESSENGERCARD && !TextUtils.isEmpty((CharSequence)block.getFallbackUrl());
    }
}

