/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;

class BackButtonCountDrawable
extends Drawable {
    private static final String COUNT_BACKGROUND_COLOR = "#FE536C";
    private static final int ICON_PADDING_DP = 16;
    private static final int COUNT_BACKGROUND_RADIUS_DP = 8;
    private static final int COUNT_TEXT_SIZE_DP = 11;
    private static final int COUNT_TEXT_PADDING_TOP = 4;
    private static final int ICON_SIZE_DP = 24;
    private final Drawable backIcon;
    private final int iconPadding;
    private final int iconSize;
    private final Paint countBackgroundPaint;
    private final int countBackgroundRadius;
    private final int textTopPadding;
    private final Paint textPaint;
    @Nullable
    private String text;

    BackButtonCountDrawable(Context context, @Nullable String text) {
        this.text = text;
        this.backIcon = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_back);
        this.iconPadding = ScreenUtils.dpToPx((float)16.0f, (Context)context);
        this.iconSize = ScreenUtils.dpToPx((float)24.0f, (Context)context);
        this.countBackgroundPaint = new Paint();
        this.countBackgroundPaint.setAntiAlias(true);
        this.countBackgroundPaint.setColor(Color.parseColor((String)COUNT_BACKGROUND_COLOR));
        this.countBackgroundPaint.setStyle(Paint.Style.FILL);
        this.countBackgroundRadius = ScreenUtils.dpToPx((float)8.0f, (Context)context);
        this.textPaint = new Paint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setColor(-1);
        this.textPaint.setTextSize((float)ScreenUtils.dpToPx((float)11.0f, (Context)context));
        this.textPaint.setFakeBoldText(true);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textTopPadding = ScreenUtils.dpToPx((float)4.0f, (Context)context);
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        int iconLeft = bounds.left + this.iconPadding;
        int iconTop = bounds.top + this.iconPadding;
        int iconRight = iconLeft + this.iconSize;
        int iconBottom = iconTop + this.iconSize;
        this.backIcon.setBounds(iconLeft, iconTop, iconRight, iconBottom);
        this.backIcon.draw(canvas);
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            canvas.drawCircle((float)iconRight, (float)iconTop, (float)this.countBackgroundRadius, this.countBackgroundPaint);
            canvas.drawText(this.text, (float)iconRight, (float)(iconTop + this.textTopPadding), this.textPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.textPaint.setAlpha(alpha);
        this.countBackgroundPaint.setAlpha(alpha);
        this.backIcon.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.backIcon.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public void setText(@Nullable String text) {
        this.text = text;
        this.invalidateSelf();
    }
}

