/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.carousel;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PermissionManager {
    private static final Twig twig = LumberMill.getLogger();
    private static final String BACKGROUND_LOCATION_PERMISSION = "android.permission.ACCESS_BACKGROUND_LOCATION";
    private final Activity activity;

    public PermissionManager(Activity activity) {
        this.activity = activity;
    }

    public boolean permissionsGranted(List<String> permissions) {
        for (String permission2 : permissions) {
            if (this.getPermissionStatus(permission2) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean anyPermissionPermanentlyDeniedInResult(String[] permissions, int[] grantResults) {
        for (int index = 0; index < permissions.length; ++index) {
            if (grantResults[index] != -1 || ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)permissions[index])) continue;
            return true;
        }
        return false;
    }

    public List<String> permissionsExistInManifest(List<String> permissions) {
        ArrayList<String> filteredPermissions = new ArrayList<String>();
        List<String> permissionsInManifest = this.permissionsInManifest();
        for (String permission2 : permissions) {
            boolean isBelowApi29;
            if (!permissionsInManifest.contains(permission2)) continue;
            boolean isBackgroundLocationPermission = BACKGROUND_LOCATION_PERMISSION.equals(permission2);
            boolean bl = isBelowApi29 = Build.VERSION.SDK_INT < 29;
            if (isBackgroundLocationPermission && isBelowApi29) continue;
            filteredPermissions.add(permission2);
        }
        return filteredPermissions;
    }

    @VisibleForTesting
    int getPermissionStatus(String androidPermissionName) {
        if (ContextCompat.checkSelfPermission((Context)this.activity, (String)androidPermissionName) == 0) {
            return 0;
        }
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)androidPermissionName)) {
            return 1;
        }
        return 2;
    }

    @VisibleForTesting
    List<String> permissionsInManifest() {
        try {
            PackageManager manager = this.activity.getPackageManager();
            PackageInfo packageInfo = manager.getPackageInfo(this.activity.getPackageName(), 4096);
            String[] permissions = packageInfo.requestedPermissions;
            return Arrays.asList(permissions);
        }
        catch (PackageManager.NameNotFoundException e) {
            twig.internal("Package name is unknown, error: " + e.getMessage());
            return new ArrayList<String>();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionStatus {
        public static final int GRANTED = 0;
        public static final int DENIED_TEMPORARILY = 1;
        public static final int NEVER_ASKED_OR_DENIED_PERMANENTLY = 2;
    }
}

